/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.converter;

import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.vaadin.data.util.converter.Converter;
import com.vaadin.ui.UI;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Locale;

public class LocalDateTimeToDateConverter
implements Converter<Date, LocalDateTime> {
    private static final long serialVersionUID = -830307549693107753L;

    public LocalDateTime convertToModel(Date value, Class<? extends LocalDateTime> targetType, Locale locale) {
        if (value == null) {
            return null;
        }
        ZoneId tz = VaadinUtils.getTimeZone(UI.getCurrent()).toZoneId();
        return value.toInstant().atZone(tz).toLocalDateTime();
    }

    public Date convertToPresentation(LocalDateTime value, Class<? extends Date> targetType, Locale locale) {
        if (value == null) {
            return null;
        }
        ZoneId tz = VaadinUtils.getTimeZone(UI.getCurrent()).toZoneId();
        return Date.from(value.atZone(tz).toInstant());
    }

    public Class<LocalDateTime> getModelType() {
        return LocalDateTime.class;
    }

    public Class<Date> getPresentationType() {
        return Date.class;
    }
}

