/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.converter;

import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.vaadin.data.util.converter.Converter;
import com.vaadin.ui.UI;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.Locale;

public class LocalDateToDateConverter
implements Converter<Date, LocalDate> {
    private static final long serialVersionUID = -830307549693107753L;

    public LocalDate convertToModel(Date value, Class<? extends LocalDate> targetType, Locale locale) {
        if (value == null) {
            return null;
        }
        ZoneId tz = VaadinUtils.getTimeZone(UI.getCurrent()).toZoneId();
        return value.toInstant().atZone(tz).toLocalDate();
    }

    public Date convertToPresentation(LocalDate value, Class<? extends Date> targetType, Locale locale) {
        if (value == null) {
            return null;
        }
        ZoneId tz = VaadinUtils.getTimeZone(UI.getCurrent()).toZoneId();
        return Date.from(value.atStartOfDay(tz).toInstant());
    }

    public Class<LocalDate> getModelType() {
        return LocalDate.class;
    }

    public Class<Date> getPresentationType() {
        return Date.class;
    }
}

