/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.converter;

import com.ocs.dynamo.utils.DateUtils;
import com.vaadin.data.util.converter.Converter;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Locale;

public class ZonedDateTimeToDateConverter
implements Converter<Date, ZonedDateTime> {
    private static final long serialVersionUID = -830307549693107753L;

    public ZonedDateTime convertToModel(Date value, Class<? extends ZonedDateTime> targetType, Locale locale) {
        if (value == null) {
            return null;
        }
        return DateUtils.convertSQLDate((Date)value).toInstant().atZone(ZoneId.systemDefault());
    }

    public Date convertToPresentation(ZonedDateTime value, Class<? extends Date> targetType, Locale locale) {
        if (value == null) {
            return null;
        }
        return Date.from(value.toInstant());
    }

    public Class<ZonedDateTime> getModelType() {
        return ZonedDateTime.class;
    }

    public Class<Date> getPresentationType() {
        return Date.class;
    }
}

