/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.menu;

import com.ocs.dynamo.service.MessageService;
import com.ocs.dynamo.ui.auth.impl.DefaultPermissionCheckerImpl;
import com.ocs.dynamo.ui.menu.NavigateCommand;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.vaadin.navigator.Navigator;
import com.vaadin.ui.MenuBar;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class MenuService {
    public static final String DESTINATION = "destination";
    public static final String DISPLAY_NAME = "displayName";
    public static final String MODE = "mode";
    public static final String TAB_INDEX = "tabIndex";
    public static final String DESCRIPTION = "description";
    @Autowired(required=false)
    private DefaultPermissionCheckerImpl checker;
    @Autowired
    private MessageService messageService;

    private MenuBar.MenuItem constructMenu(MenuBar bar, Object parent, String key, Navigator navigator) {
        String caption = this.messageService.getMessageNoDefault(key + "." + DISPLAY_NAME, VaadinUtils.getLocale());
        MenuBar.MenuItem menuItem = null;
        if (!StringUtils.isEmpty((String)caption)) {
            String destination = this.messageService.getMessageNoDefault(key + "." + DESTINATION, VaadinUtils.getLocale());
            String tabIndex = this.messageService.getMessageNoDefault(key + "." + TAB_INDEX, VaadinUtils.getLocale());
            String mode = this.messageService.getMessageNoDefault(key + "." + MODE, VaadinUtils.getLocale());
            String description = this.messageService.getMessageNoDefault(key + "." + DESCRIPTION, VaadinUtils.getLocale());
            NavigateCommand command = null;
            if (!StringUtils.isEmpty((String)destination)) {
                command = new NavigateCommand(navigator, bar, destination, tabIndex, mode);
            }
            menuItem = parent instanceof MenuBar ? ((MenuBar)parent).addItem(caption, command) : ((MenuBar.MenuItem)parent).addItem(caption, command);
            if (description != null) {
                menuItem.setDescription(description);
            }
            int index = 1;
            String childKey = this.messageService.getMessageNoDefault(key + "." + index + "." + DISPLAY_NAME, VaadinUtils.getLocale());
            while (childKey != null) {
                this.constructMenu(bar, menuItem, key + "." + index, navigator);
                childKey = this.messageService.getMessageNoDefault(key + "." + ++index + "." + DISPLAY_NAME, VaadinUtils.getLocale());
            }
            if (this.checker != null && !this.checker.isAccessAllowed(destination)) {
                menuItem.setVisible(false);
            }
        }
        return menuItem;
    }

    public MenuBar constructMenu(String rootName, Navigator navigator) {
        MenuBar mainMenu = new MenuBar();
        int i = 1;
        while (this.constructMenu(mainMenu, mainMenu, rootName + "." + i, navigator) != null) {
            ++i;
        }
        this.hideRecursively(mainMenu);
        return mainMenu;
    }

    private boolean hideIfAllChildrenHidden(MenuBar.MenuItem item) {
        if (item.getChildren() != null && !item.getChildren().isEmpty()) {
            boolean found = false;
            for (MenuBar.MenuItem child : item.getChildren()) {
                boolean visible = this.hideIfAllChildrenHidden(child);
                found |= visible;
            }
            if (!found) {
                item.setVisible(false);
            }
            return found;
        }
        return item.isVisible();
    }

    private boolean hasChildWithDestination(MenuBar.MenuItem item, String destination) {
        NavigateCommand command;
        if (item.getChildren() != null && !item.getChildren().isEmpty()) {
            boolean found = false;
            for (MenuBar.MenuItem child : item.getChildren()) {
                boolean t = this.hasChildWithDestination(child, destination);
                found |= t;
            }
            return found;
        }
        return item.getCommand() instanceof NavigateCommand && (command = (NavigateCommand)item.getCommand()).getDestination().equals(destination);
    }

    private void hideRecursively(MenuBar bar) {
        for (MenuBar.MenuItem item : bar.getItems()) {
            this.hideIfAllChildrenHidden(item);
        }
    }

    public void setVisible(MenuBar menu, String destination, boolean visible) {
        this.setVisible(menu, destination, null, visible);
    }

    public void setVisible(MenuBar menu, String destination, String mode, boolean visible) {
        List items = menu.getItems();
        for (MenuBar.MenuItem item : items) {
            this.setVisible(item, destination, mode, visible);
        }
        this.hideRecursively(menu);
    }

    public void setLastVisited(MenuBar menuBar, String destination) {
        for (MenuBar.MenuItem item : menuBar.getItems()) {
            item.setStyleName(null);
            if (!this.hasChildWithDestination(item, destination)) continue;
            item.setStyleName("lastVisited");
        }
    }

    private void setVisible(MenuBar.MenuItem item, String destination, String mode, boolean visible) {
        NavigateCommand command;
        if (item.getCommand() instanceof NavigateCommand && (command = (NavigateCommand)item.getCommand()).getDestination().equals(destination) && (mode == null || mode.equals(command.getMode()))) {
            item.setVisible(visible);
        }
        if (item.getChildren() != null) {
            for (MenuBar.MenuItem child : item.getChildren()) {
                this.setVisible(child, destination, mode, visible);
            }
        }
    }
}

