/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.menu;

import com.ocs.dynamo.ui.BaseUI;
import com.vaadin.navigator.Navigator;
import com.vaadin.ui.MenuBar;
import com.vaadin.ui.UI;

public class NavigateCommand
implements MenuBar.Command {
    private static final long serialVersionUID = 5192333331107840255L;
    private final Navigator navigator;
    private MenuBar menuBar;
    private final String destination;
    private final String selectedTab;
    private final String mode;

    public NavigateCommand(Navigator navigator, MenuBar menuBar, String destination, String selectedTab, String mode) {
        this.menuBar = menuBar;
        this.navigator = navigator;
        this.destination = destination;
        this.selectedTab = selectedTab;
        this.mode = mode;
    }

    public void menuSelected(MenuBar.MenuItem selectedItem) {
        UI ui = UI.getCurrent();
        if (ui instanceof BaseUI) {
            BaseUI b = (BaseUI)ui;
            if (this.selectedTab != null) {
                b.setSelectedTab(Integer.valueOf(this.selectedTab));
            } else {
                b.setSelectedTab(null);
            }
            b.setScreenMode(this.mode);
        }
        for (MenuBar.MenuItem item : this.menuBar.getItems()) {
            item.setStyleName(null);
        }
        while (selectedItem.getParent() != null) {
            selectedItem = selectedItem.getParent();
        }
        selectedItem.setStyleName("lastVisited");
        this.navigator.navigateTo(this.destination);
    }

    public String getDestination() {
        return this.destination;
    }

    public String getSelectedTab() {
        return this.selectedTab;
    }

    public String getMode() {
        return this.mode;
    }
}

