/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.navigator;

import com.ocs.dynamo.exception.OCSRuntimeException;
import com.vaadin.navigator.NavigationStateManager;
import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.navigator.ViewDisplay;
import com.vaadin.navigator.ViewProvider;
import com.vaadin.shared.util.SharedUtil;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.SingleComponentContainer;
import com.vaadin.ui.UI;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CustomNavigator
extends Navigator {
    private static final long serialVersionUID = 4919429256404050039L;
    private List<ViewProvider> providers = new LinkedList<ViewProvider>();
    private String currentNavigationState = null;
    private ViewProvider errorProvider;
    private boolean alwaysReload = true;

    protected CustomNavigator() {
    }

    public CustomNavigator(UI ui, ComponentContainer container) {
        this(ui, (ViewDisplay)new Navigator.ComponentContainerViewDisplay(container));
    }

    public CustomNavigator(UI ui, NavigationStateManager stateManager, ViewDisplay display) {
        this.init(ui, stateManager, display);
    }

    public CustomNavigator(UI ui, SingleComponentContainer container) {
        this(ui, (ViewDisplay)new Navigator.SingleComponentContainerViewDisplay(container));
    }

    public CustomNavigator(UI ui, ViewDisplay display) {
        this(ui, (NavigationStateManager)new Navigator.UriFragmentManager(ui.getPage()), display);
    }

    public void addProvider(ViewProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Cannot add a null view provider");
        }
        this.providers.add(provider);
    }

    private ViewProvider getViewProvider(String state) {
        String longestViewName = null;
        ViewProvider longestViewNameProvider = null;
        for (ViewProvider provider : this.providers) {
            String viewName = provider.getViewName(state);
            if (null == viewName || longestViewName != null && viewName.length() <= longestViewName.length()) continue;
            longestViewName = viewName;
            longestViewNameProvider = provider;
        }
        return longestViewNameProvider;
    }

    public boolean isAlwaysReload() {
        return this.alwaysReload;
    }

    public void navigateTo(String navigationState) {
        ViewProvider longestViewNameProvider = this.getViewProvider(navigationState);
        String longestViewName = longestViewNameProvider == null ? null : longestViewNameProvider.getViewName(navigationState);
        View viewWithLongestName = null;
        if (longestViewName != null) {
            viewWithLongestName = longestViewNameProvider.getView(longestViewName);
        }
        if (viewWithLongestName == null && this.errorProvider != null) {
            longestViewName = this.errorProvider.getViewName(navigationState);
            viewWithLongestName = this.errorProvider.getView(longestViewName);
        }
        if (viewWithLongestName == null) {
            throw new IllegalArgumentException("Trying to navigate to an unknown state '" + navigationState + "' and an error view provider not present");
        }
        String parameters = "";
        if (navigationState.length() > longestViewName.length() + 1) {
            parameters = navigationState.substring(longestViewName.length() + 1);
        } else if (navigationState.endsWith("/")) {
            navigationState = navigationState.substring(0, navigationState.length() - 1);
        }
        if (this.isAlwaysReload() || this.getCurrentView() == null || !SharedUtil.equals((Object)this.getCurrentView(), (Object)viewWithLongestName) || !SharedUtil.equals((Object)this.currentNavigationState, (Object)navigationState)) {
            this.navigateTo(viewWithLongestName, longestViewName, parameters);
        } else {
            this.updateNavigationState(new ViewChangeListener.ViewChangeEvent((Navigator)this, this.getCurrentView(), viewWithLongestName, longestViewName, parameters));
        }
    }

    public void removeProvider(ViewProvider provider) {
        this.providers.remove(provider);
    }

    public void removeView(String viewName) {
        Iterator<ViewProvider> it = this.providers.iterator();
        while (it.hasNext()) {
            Navigator.ClassBasedViewProvider classBasedProvider;
            ViewProvider provider = it.next();
            if (provider instanceof Navigator.StaticViewProvider) {
                Navigator.StaticViewProvider staticProvider = (Navigator.StaticViewProvider)provider;
                if (!staticProvider.getViewName().equals(viewName)) continue;
                it.remove();
                continue;
            }
            if (!(provider instanceof Navigator.ClassBasedViewProvider) || !(classBasedProvider = (Navigator.ClassBasedViewProvider)provider).getViewName().equals(viewName)) continue;
            it.remove();
        }
    }

    protected void revertNavigation() {
        if (this.currentNavigationState != null) {
            this.getStateManager().setState(this.currentNavigationState);
        }
    }

    public void setAlwaysReload(boolean alwaysReload) {
        this.alwaysReload = alwaysReload;
    }

    public void setErrorProvider(ViewProvider provider) {
        this.errorProvider = provider;
    }

    public void setErrorView(final Class<? extends View> viewClass) {
        this.setErrorProvider(new ViewProvider(){
            private static final long serialVersionUID = 2848938026523077039L;

            public View getView(String viewName) {
                try {
                    return (View)viewClass.newInstance();
                }
                catch (Exception e) {
                    throw new OCSRuntimeException(e.getMessage(), (Throwable)e);
                }
            }

            public String getViewName(String navigationState) {
                return navigationState;
            }
        });
    }

    public void setErrorView(final View view) {
        this.setErrorProvider(new ViewProvider(){
            private static final long serialVersionUID = -3641455197804342745L;

            public View getView(String viewName) {
                return view;
            }

            public String getViewName(String navigationState) {
                return navigationState;
            }
        });
    }

    protected void updateNavigationState(ViewChangeListener.ViewChangeEvent event) {
        String viewName = event.getViewName();
        String parameters = event.getParameters();
        if (null != viewName && this.getStateManager() != null) {
            String navigationState = viewName;
            if (!parameters.isEmpty()) {
                navigationState = navigationState + "/" + parameters;
            }
            if (!navigationState.equals(this.getStateManager().getState())) {
                this.getStateManager().setState(navigationState);
            }
            this.currentNavigationState = navigationState;
        }
    }
}

