/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.utils;

import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.NumberSelectMode;
import com.ocs.dynamo.ui.converter.WeekCodeConverter;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.ocs.dynamo.util.SystemPropertyUtils;
import com.ocs.dynamo.utils.DateUtils;
import com.ocs.dynamo.utils.NumberUtils;
import java.math.BigDecimal;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.Locale;

public final class ConvertUtil {
    private ConvertUtil() {
    }

    public static Object convertToPresentationValue(AttributeModel attributeModel, Object input) {
        if (input == null) {
            return null;
        }
        Locale locale = VaadinUtils.getLocale();
        boolean grouping = SystemPropertyUtils.useThousandsGroupingInEditMode();
        boolean percentage = attributeModel.isPercentage();
        if (attributeModel.isWeek()) {
            WeekCodeConverter converter = new WeekCodeConverter();
            return converter.convertToPresentation((Date)input, String.class, locale);
        }
        if (Integer.class.equals((Object)attributeModel.getType())) {
            return VaadinUtils.integerToString(grouping, percentage, (Integer)input);
        }
        if (Long.class.equals((Object)attributeModel.getType())) {
            return VaadinUtils.longToString(grouping, percentage, (Long)input);
        }
        if (BigDecimal.class.equals((Object)attributeModel.getType())) {
            return VaadinUtils.bigDecimalToString(attributeModel.isCurrency(), attributeModel.isPercentage(), grouping, attributeModel.getPrecision(), (BigDecimal)input, locale);
        }
        if (input instanceof Temporal) {
            return DateUtils.toLegacyDate((Temporal)((Temporal)input));
        }
        return input;
    }

    public static Object convertSearchValue(AttributeModel attributeModel, Object input) {
        if (input == null) {
            return null;
        }
        boolean grouping = SystemPropertyUtils.useThousandsGroupingInEditMode();
        Locale locale = VaadinUtils.getLocale();
        if (attributeModel.isWeek()) {
            WeekCodeConverter converter = new WeekCodeConverter();
            return converter.convertToModel((String)input, Date.class, locale);
        }
        if (NumberUtils.isInteger((Class)attributeModel.getType())) {
            if (NumberSelectMode.TEXTFIELD.equals((Object)attributeModel.getNumberSelectMode())) {
                return VaadinUtils.stringToInteger(grouping, (String)input, locale);
            }
        } else if (NumberUtils.isLong((Class)attributeModel.getType())) {
            if (NumberSelectMode.TEXTFIELD.equals((Object)attributeModel.getNumberSelectMode())) {
                return VaadinUtils.stringToLong(grouping, (String)input, locale);
            }
        } else if (BigDecimal.class.equals((Object)attributeModel.getType()) && NumberSelectMode.TEXTFIELD.equals((Object)attributeModel.getNumberSelectMode())) {
            return VaadinUtils.stringToBigDecimal(attributeModel.isPercentage(), grouping, attributeModel.isCurrency(), attributeModel.getPrecision(), (String)input, locale);
        }
        return input;
    }
}

