/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.utils;

import com.google.common.collect.Sets;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.AttributeType;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.domain.model.EntityModelFactory;
import com.ocs.dynamo.service.MessageService;
import com.ocs.dynamo.ui.utils.FormatUtils;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.ocs.dynamo.util.SystemPropertyUtils;
import com.ocs.dynamo.utils.ClassUtils;
import com.vaadin.ui.DefaultFieldFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.ObjectUtils;

public final class EntityModelUtil {
    private static final Set<String> ALWAYS_IGNORE = Sets.newHashSet((Object[])new String[]{"createdOn", "createdBy", "changedBy", "changedOn"});

    private EntityModelUtil() {
    }

    public static List<String> compare(Object oldEntity, Object newEntity, EntityModel<?> model, EntityModelFactory entityModelFactory, MessageService messageService, String ... ignore) {
        ArrayList<String> results = new ArrayList<String>();
        HashSet toIgnore = new HashSet();
        if (ignore != null) {
            toIgnore = Sets.newHashSet((Object[])ignore);
        }
        toIgnore.addAll(ALWAYS_IGNORE);
        String noValue = messageService.getMessage("ocs.no.value", VaadinUtils.getLocale());
        for (AttributeModel am : model.getAttributeModels()) {
            if ((AttributeType.BASIC.equals((Object)am.getAttributeType()) || AttributeType.MASTER.equals((Object)am.getAttributeType())) && !toIgnore.contains(am.getName())) {
                Object newValue;
                Object oldValue = ClassUtils.getFieldValue((Object)oldEntity, (String)am.getName());
                if (ObjectUtils.equals((Object)oldValue, (Object)(newValue = ClassUtils.getFieldValue((Object)newEntity, (String)am.getName())))) continue;
                String oldValueStr = FormatUtils.formatPropertyValue(entityModelFactory, am, oldValue, ", ");
                String newValueStr = FormatUtils.formatPropertyValue(entityModelFactory, am, newValue, ", ");
                results.add(messageService.getMessage("ocs.value.changed", VaadinUtils.getLocale(), new Object[]{am.getDisplayName(), oldValue == null ? noValue : oldValueStr, newValue == null ? noValue : newValueStr}));
                continue;
            }
            if (!AttributeType.DETAIL.equals((Object)am.getAttributeType())) continue;
            Collection ocol = (Collection)ClassUtils.getFieldValue((Object)oldEntity, (String)am.getName());
            Collection ncol = (Collection)ClassUtils.getFieldValue((Object)newEntity, (String)am.getName());
            for (Object o : ncol) {
                if (ocol.contains(o)) continue;
                results.add(messageService.getMessage("ocs.value.added", VaadinUtils.getLocale(), new Object[]{EntityModelUtil.getDescription(o, am.getNestedEntityModel()), am.getDisplayName()}));
            }
            for (Object o : ocol) {
                if (ncol.contains(o)) continue;
                results.add(messageService.getMessage("ocs.value.removed", VaadinUtils.getLocale(), new Object[]{EntityModelUtil.getDescription(o, am.getNestedEntityModel()), am.getDisplayName()}));
            }
            for (Object o : ocol) {
                for (Object o2 : ncol) {
                    if (!o.equals(o2)) continue;
                    List<String> nested = EntityModelUtil.compare(o, o2, am.getNestedEntityModel(), entityModelFactory, messageService, ignore);
                    results.addAll(nested);
                }
            }
        }
        return results;
    }

    public static <T> void copySimpleAttributes(T source, T target, EntityModel<T> model, String ... ignore) {
        HashSet toIgnore = new HashSet();
        if (ignore != null) {
            toIgnore = Sets.newHashSet((Object[])ignore);
        }
        toIgnore.addAll(ALWAYS_IGNORE);
        for (AttributeModel am : model.getAttributeModels()) {
            if (!AttributeType.BASIC.equals((Object)am.getAttributeType()) && !AttributeType.LOB.equals((Object)am.getAttributeType()) || toIgnore.contains(am.getName()) || "id".equals(am.getName())) continue;
            Object value = ClassUtils.getFieldValue(source, (String)am.getName());
            if (!ClassUtils.canSetProperty(target, (String)am.getName())) continue;
            if (value != null) {
                ClassUtils.setFieldValue(target, (String)am.getName(), (Object)value);
                continue;
            }
            ClassUtils.clearFieldValue(target, (String)am.getName(), (Class)am.getType());
        }
    }

    private static String getDescription(Object o, EntityModel<?> model) {
        if (o instanceof AbstractEntity && model.getDisplayProperty() != null) {
            String property = model.getDisplayProperty();
            return ClassUtils.getFieldValueAsString((Object)o, (String)property);
        }
        return o.toString();
    }

    public static <T> String getDisplayPropertyValue(Collection<T> entities, EntityModel<T> model, int maxItems, MessageService messageService) {
        String property = model.getDisplayProperty();
        StringBuilder result = new StringBuilder();
        int i = 0;
        for (T t : entities) {
            if (result.length() > 0) {
                result.append(", ");
            }
            if (i >= maxItems) {
                result.append(messageService.getMessage("ocs.and.others", VaadinUtils.getLocale(), new Object[]{entities.size() - maxItems}));
                break;
            }
            result.append(ClassUtils.getFieldValueAsString(t, (String)property));
            ++i;
        }
        return result.toString();
    }

    public static <T> String getDisplayPropertyValue(T entity, EntityModel<T> model) {
        String property = model.getDisplayProperty();
        return ClassUtils.getFieldValueAsString(entity, (String)property);
    }

    public static <T> String getMainAttributeValue(T entity, EntityModel<T> model) {
        AttributeModel main = model.getMainAttributeModel();
        if (main != null) {
            return ClassUtils.getFieldValueAsString(entity, (String)main.getName());
        }
        return null;
    }

    public static String getCaptionByPropertyId(String fieldName) {
        String displayName = DefaultFieldFactory.createCaptionByPropertyId((Object)fieldName);
        if (SystemPropertyUtils.getDefaultCaptionFormat().equals("vaadin")) {
            return displayName;
        }
        StringBuilder formatted = new StringBuilder();
        StringTokenizer st = new StringTokenizer(displayName, " ");
        if (st.hasMoreTokens()) {
            formatted.append(st.nextToken());
        }
        while (st.hasMoreTokens()) {
            formatted.append(" " + st.nextToken().toLowerCase());
        }
        return formatted.toString();
    }
}

