/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.utils;

import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeDateType;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.domain.model.EntityModelFactory;
import com.ocs.dynamo.exception.OCSRuntimeException;
import com.ocs.dynamo.service.MessageService;
import com.ocs.dynamo.service.ServiceLocatorFactory;
import com.ocs.dynamo.ui.composite.table.TableUtils;
import com.ocs.dynamo.ui.container.hierarchical.ModelBasedHierarchicalContainer;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.ocs.dynamo.utils.ClassUtils;
import com.ocs.dynamo.utils.DateUtils;
import com.ocs.dynamo.utils.NumberUtils;
import com.vaadin.data.Property;
import com.vaadin.ui.Table;
import com.vaadin.ui.UI;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;

public final class FormatUtils {
    private static MessageService messageService = ServiceLocatorFactory.getServiceLocator().getMessageService();

    private FormatUtils() {
    }

    public static String formatEntity(EntityModel<?> entityModel, Object value) {
        if (value instanceof AbstractEntity) {
            AbstractEntity entity = (AbstractEntity)value;
            if (entityModel.getDisplayProperty() != null) {
                return ClassUtils.getFieldValueAsString((Object)entity, (String)entityModel.getDisplayProperty());
            }
            return entity.toString();
        }
        return null;
    }

    public static String formatEntityCollection(EntityModelFactory entityModelFactory, AttributeModel attributeModel, Object collection, String separator) {
        ArrayList<String> result = new ArrayList<String>();
        Iterable col = (Iterable)collection;
        for (Object next : col) {
            if (next instanceof AbstractEntity) {
                EntityModel entityModel = entityModelFactory.getModel(next.getClass());
                String displayProperty = entityModel.getDisplayProperty();
                if (displayProperty != null) {
                    result.add(ClassUtils.getFieldValueAsString(next, (String)displayProperty));
                    continue;
                }
                result.add(next.toString());
                continue;
            }
            if (next instanceof Number) {
                result.add(VaadinUtils.numberToString(attributeModel, attributeModel.getNormalizedType(), next, true, VaadinUtils.getLocale()));
                continue;
            }
            result.add(next.toString());
        }
        return result.stream().collect(Collectors.joining(separator));
    }

    public static String formatEntityCollection(EntityModelFactory entityModelFactory, AttributeModel attributeModel, Property<?> property) {
        return FormatUtils.formatEntityCollection(entityModelFactory, attributeModel, property.getValue(), "<br/> ");
    }

    public static String formatPropertyValue(EntityModelFactory entityModelFactory, AttributeModel model, Object value, String separator) {
        return FormatUtils.formatPropertyValue(null, entityModelFactory, model, value, VaadinUtils.getLocale(), separator);
    }

    public static <T> String formatPropertyValue(Table table, EntityModelFactory entityModelFactory, EntityModel<T> entityModel, Object rowId, Object colId, Property<?> property, String separator) {
        return FormatUtils.formatPropertyValue(table, entityModelFactory, entityModel, rowId, colId, property, VaadinUtils.getLocale(), separator);
    }

    public static <T> String formatPropertyValue(Table table, EntityModelFactory entityModelFactory, EntityModel<T> entityModel, Object rowId, Object colId, Property<?> property, Locale locale, String separator) {
        if (table.getContainerDataSource() instanceof ModelBasedHierarchicalContainer) {
            ModelBasedHierarchicalContainer.ModelBasedHierarchicalDefinition def;
            ModelBasedHierarchicalContainer c = (ModelBasedHierarchicalContainer)table.getContainerDataSource();
            Object path = c.unmapProperty(def = c.getHierarchicalDefinitionByItemId(rowId), colId);
            return FormatUtils.formatPropertyValue(table, entityModelFactory, path == null ? null : def.getEntityModel().getAttributeModel(path.toString()), property.getValue(), locale, separator);
        }
        return FormatUtils.formatPropertyValue(table, entityModelFactory, entityModel.getAttributeModel(colId.toString()), property.getValue(), locale, separator);
    }

    public static String formatPropertyValue(Table table, EntityModelFactory entityModelFactory, AttributeModel model, Object value, Locale locale, String separator) {
        if (model != null && value != null) {
            if (model.isWeek()) {
                if (value instanceof Date) {
                    return DateUtils.toWeekCode((Date)((Date)value));
                }
                if (value instanceof LocalDate) {
                    return DateUtils.toWeekCode((LocalDate)((LocalDate)value));
                }
            } else {
                if (Boolean.class.equals((Object)model.getType()) || Boolean.TYPE.equals(model.getType())) {
                    if (!StringUtils.isEmpty((Object)model.getTrueRepresentation()) && Boolean.TRUE.equals(value)) {
                        return model.getTrueRepresentation();
                    }
                    if (!StringUtils.isEmpty((Object)model.getFalseRepresentation()) && Boolean.FALSE.equals(value)) {
                        return model.getFalseRepresentation();
                    }
                    return Boolean.toString(Boolean.TRUE.equals(value));
                }
                if (Date.class.equals((Object)model.getType())) {
                    SimpleDateFormat format = new SimpleDateFormat(model.getDisplayFormat());
                    if (AttributeDateType.TIMESTAMP.equals((Object)model.getDateType())) {
                        format.setTimeZone(VaadinUtils.getTimeZone(UI.getCurrent()));
                    }
                    return format.format((Date)value);
                }
                if (DateUtils.isJava8DateType((Class)model.getType())) {
                    return DateUtils.formatJava8Date((Class)model.getType(), (Object)value, (String)model.getDisplayFormat());
                }
                if (BigDecimal.class.equals((Object)model.getType())) {
                    String cs = TableUtils.getCurrencySymbol(table);
                    return VaadinUtils.bigDecimalToString(model.isCurrency(), model.isPercentage(), model.isUseThousandsGrouping(), model.getPrecision(), (BigDecimal)value, locale, cs);
                }
                if (NumberUtils.isNumeric((Class)model.getType())) {
                    return VaadinUtils.numberToString(model, model.getType(), value, model.isUseThousandsGrouping(), locale);
                }
                if (model.getType().isEnum()) {
                    String msg = messageService.getEnumMessage(model.getType(), (Enum)value, VaadinUtils.getLocale());
                    if (msg != null) {
                        return msg;
                    }
                } else {
                    if (value instanceof Iterable) {
                        String result = FormatUtils.formatEntityCollection(entityModelFactory, model, value, separator);
                        return table == null ? result : FormatUtils.restrictToMaxLength(result, model);
                    }
                    if (AbstractEntity.class.isAssignableFrom(model.getType())) {
                        String displayProperty;
                        EntityModel detailEntityModel = model.getNestedEntityModel();
                        if (detailEntityModel == null) {
                            detailEntityModel = entityModelFactory.getModel(model.getType());
                        }
                        if ((displayProperty = detailEntityModel.getDisplayProperty()) == null) {
                            throw new OCSRuntimeException("No displayProperty set for entity " + detailEntityModel.getEntityClass());
                        }
                        AttributeModel detailModel = detailEntityModel.getAttributeModel(displayProperty);
                        return FormatUtils.formatPropertyValue(table, entityModelFactory, detailModel, ClassUtils.getFieldValue((Object)value, (String)displayProperty), locale, separator);
                    }
                    if (value instanceof AbstractEntity) {
                        Object result = ClassUtils.getFieldValue((Object)value, (String)model.getPath());
                        if (result == null) {
                            return null;
                        }
                        return table == null ? result.toString() : FormatUtils.restrictToMaxLength(result.toString(), model);
                    }
                    return table == null ? value.toString() : FormatUtils.restrictToMaxLength(value.toString(), model);
                }
            }
        }
        return null;
    }

    private static String restrictToMaxLength(String input, AttributeModel am) {
        if (am.getMaxLengthInTable() != null && input != null && input.length() > am.getMaxLengthInTable()) {
            return input.substring(0, am.getMaxLengthInTable()) + "...";
        }
        return input;
    }
}

