/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.utils;

import com.ocs.dynamo.ui.utils.PasteUtils;
import com.vaadin.event.FieldEvents;
import com.vaadin.ui.Table;
import java.util.Locale;
import org.apache.log4j.Logger;

public abstract class PasteTemplate {
    private static final Logger LOG = Logger.getLogger(PasteTemplate.class);
    private FieldEvents.TextChangeEvent event;
    private Locale locale;
    private Table table;

    public PasteTemplate(Locale locale, Table table, FieldEvents.TextChangeEvent event) {
        this.locale = locale;
        this.event = event;
        this.table = table;
    }

    public void execute() {
        String[] values;
        String text = this.event.getText();
        if (text != null && (values = PasteUtils.split(text)).length > 1) {
            this.clearSourceField(this.event);
            for (int i = 0; i < values.length; ++i) {
                try {
                    String temp = values[i];
                    temp = PasteUtils.translateSeparators(temp, this.locale);
                    String s = temp.replaceAll("%", "");
                    this.process(i, s);
                    continue;
                }
                catch (Exception ex) {
                    LOG.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            if (this.table != null) {
                this.table.refreshRowCache();
            }
        }
    }

    protected abstract void process(int var1, String var2);

    protected abstract void clearSourceField(FieldEvents.TextChangeEvent var1);

    public Table getTable() {
        return this.table;
    }
}

