/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.utils;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class SubList<E>
extends AbstractList<E> {
    private final List<E> list;
    private final int offset;
    private int size;

    public SubList(List<E> list, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > list.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        this.list = list;
        this.offset = fromIndex;
        this.size = toIndex - fromIndex;
    }

    @Override
    public E set(int index, E element) {
        this.rangeCheck(index);
        return this.list.set(index + this.offset, element);
    }

    @Override
    public E get(int index) {
        this.rangeCheck(index);
        return this.list.get(index + this.offset);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void add(int index, E element) {
        this.rangeCheckForAdd(index);
        this.list.add(index + this.offset, element);
        ++this.size;
    }

    @Override
    public E remove(int index) {
        this.rangeCheck(index);
        E result = this.list.remove(index + this.offset);
        --this.size;
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.addAll(this.size, c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.rangeCheckForAdd(index);
        int cSize = c.size();
        if (cSize == 0) {
            return false;
        }
        this.list.addAll(this.offset + index, c);
        this.size += cSize;
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        this.rangeCheckForAdd(index);
        return new ListIteratorImpl(this.list.listIterator(index + this.offset));
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new SubList<E>(this, fromIndex, toIndex);
    }

    protected void rangeCheck(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    protected void rangeCheckForAdd(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    protected String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size;
    }

    public List<E> getList() {
        return this.list;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getOffset() {
        return this.offset;
    }

    protected class ListIteratorImpl
    implements ListIterator<E> {
        private ListIterator<E> i;

        protected ListIteratorImpl(ListIterator<E> i) {
            this.i = i;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex() < SubList.this.size;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                return this.i.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return this.previousIndex() >= 0;
        }

        @Override
        public E previous() {
            if (this.hasPrevious()) {
                return this.i.previous();
            }
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return this.i.nextIndex() - SubList.this.offset;
        }

        @Override
        public int previousIndex() {
            return this.i.previousIndex() - SubList.this.offset;
        }

        @Override
        public void remove() {
            this.i.remove();
            SubList.this.size--;
        }

        @Override
        public void set(E e) {
            this.i.set(e);
        }

        @Override
        public void add(E e) {
            this.i.add(e);
            SubList.this.size++;
        }
    }
}

