/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.utils;

import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.service.MessageService;
import com.ocs.dynamo.ui.container.pivot.PivotItem;
import com.ocs.dynamo.ui.converter.BigDecimalConverter;
import com.ocs.dynamo.ui.converter.ConverterFactory;
import com.ocs.dynamo.util.SystemPropertyUtils;
import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Validator;
import com.vaadin.data.util.BeanItem;
import com.vaadin.data.util.converter.Converter;
import com.vaadin.data.util.converter.StringToIntegerConverter;
import com.vaadin.data.util.converter.StringToLongConverter;
import com.vaadin.server.Page;
import com.vaadin.server.VaadinSession;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Layout;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.Table;
import com.vaadin.ui.UI;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.vaadin.addons.lazyquerycontainer.CompositeItem;
import org.vaadin.addons.lazyquerycontainer.NestingBeanItem;
import org.vaadin.dialogs.ConfirmDialog;

public final class VaadinUtils {
    private VaadinUtils() {
    }

    public static <T> void addPropertyIdToContainer(Container container, EntityModel<T> entityModel, String attributeName) {
        if (entityModel != null) {
            AttributeModel attributeModel = entityModel.getAttributeModel(attributeName);
            VaadinUtils.addPropertyIdToContainer(container, attributeModel);
        }
    }

    public static void addPropertyIdToContainer(Container container, AttributeModel attributeModel) {
        if (container != null && attributeModel != null && attributeModel.isVisibleInTable() && !container.getContainerPropertyIds().contains(attributeModel.getPath())) {
            container.addContainerProperty((Object)attributeModel.getPath(), attributeModel.getType(), attributeModel.getDefaultValue());
        }
    }

    public static boolean allFixedTableFieldsValid(Table table) {
        boolean allValid = true;
        Iterator component = table.iterator();
        while (component.hasNext() && allValid) {
            Component next = (Component)component.next();
            if (!(next instanceof Field)) continue;
            allValid &= ((Field)next).isValid();
        }
        return allValid;
    }

    public static String bigDecimalToString(boolean percentage, boolean useGrouping, BigDecimal value) {
        return VaadinUtils.bigDecimalToString(false, percentage, useGrouping, SystemPropertyUtils.getDefaultDecimalPrecision(), value, VaadinUtils.getLocale());
    }

    public static String bigDecimalToString(boolean currency, boolean percentage, boolean useGrouping, BigDecimal value) {
        return VaadinUtils.bigDecimalToString(currency, percentage, useGrouping, SystemPropertyUtils.getDefaultDecimalPrecision(), value, VaadinUtils.getLocale());
    }

    public static String bigDecimalToString(boolean currency, boolean percentage, boolean useGrouping, int precision, BigDecimal value, Locale locale) {
        return VaadinUtils.bigDecimalToString(currency, percentage, useGrouping, precision, value, locale, VaadinUtils.getCurrencySymbol());
    }

    public static String bigDecimalToString(boolean currency, boolean percentage, boolean useGrouping, int precision, BigDecimal value, Locale locale, String currencySymbol) {
        BigDecimalConverter converter = ConverterFactory.createBigDecimalConverter(currency, percentage, useGrouping, precision, currencySymbol);
        return converter.convertToPresentation(value, String.class, locale);
    }

    public static void enableCopyPaste() {
        String js = "$(document).ready(function() {  $('input').off('paste');   $('input').on('paste', function(e) {     if (clipboardData) {       setTimeout(function() {        var pasted = clipboardData.getData('text');        pasted = pasted.replace(/(\\r\\n|\\r|\\n)/g,'\t');        clipboardData.setData('text', pasted); $(e.target).val(pasted);}       , 100);      }  }) });";
        Page.getCurrent().getJavaScript().execute(js);
    }

    public static String getCurrencySymbol() {
        String cs = SystemPropertyUtils.getDefaultCurrencySymbol();
        VaadinSession vs = VaadinSession.getCurrent();
        if (vs != null && vs.getAttribute("currencySymbol") != null) {
            cs = (String)vs.getAttribute("currencySymbol");
        }
        return cs;
    }

    public static <ID, T> T getEntityFromContainer(Container container, ID id) {
        Item obj = container.getItem(id);
        return VaadinUtils.getEntityFromItem(obj);
    }

    public static <T> T getEntityFromItem(Object obj) {
        if (obj instanceof CompositeItem) {
            CompositeItem item = (CompositeItem)obj;
            NestingBeanItem bi = (NestingBeanItem)item.getItem("bean");
            return (T)bi.getBean();
        }
        if (obj instanceof BeanItem) {
            BeanItem bi = (BeanItem)obj;
            return (T)bi.getBean();
        }
        return null;
    }

    public static <T> T getEntityFromPivotItem(Item item, String column) {
        PivotItem pi = (PivotItem)item;
        Item nested = pi.getColumn(column);
        return VaadinUtils.getEntityFromItem(nested);
    }

    public static String getFirstValueFromCollection(Map<String, Object> map, String key) {
        Collection col;
        if (map != null && (col = (Collection)map.get(key)) != null) {
            return col.iterator().next().toString();
        }
        return null;
    }

    public static Locale getLocale() {
        if (VaadinSession.getCurrent() != null) {
            return VaadinSession.getCurrent().getLocale();
        }
        return new Locale(SystemPropertyUtils.getDefaultLocale());
    }

    public static Locale getDateLocale() {
        if (VaadinSession.getCurrent() != null && VaadinSession.getCurrent().getAttribute("dateLocale") != null) {
            return new Locale((String)VaadinSession.getCurrent().getAttribute("dateLocale"));
        }
        return VaadinUtils.getLocale();
    }

    public static void storeDateLocale() {
        VaadinSession.getCurrent().setAttribute("dateLocale", (Object)SystemPropertyUtils.getDefaultDateLocale());
    }

    public static void storeLocale() {
        VaadinSession.getCurrent().setLocale(new Locale(SystemPropertyUtils.getDefaultLocale()));
    }

    public static int getTabIndex(TabSheet tabs, String caption) {
        int index = 0;
        for (int i = 0; i < tabs.getComponentCount(); ++i) {
            TabSheet.Tab t = tabs.getTab(i);
            if (!t.getCaption().equals(caption)) continue;
            index = i;
            break;
        }
        return index;
    }

    public static <T> T getParentOfClass(Component component, Class<T> clazz) {
        while (component.getParent() != null) {
            if (!clazz.isAssignableFrom((component = component.getParent()).getClass())) continue;
            return (T)component;
        }
        return null;
    }

    public static <T extends Component> T getFirstChildOfClass(Layout layout, Class<T> clazz) {
        for (Component c : layout) {
            if (!clazz.isAssignableFrom(c.getClass())) continue;
            return (T)c;
        }
        return null;
    }

    public static String getSessionAttributeValueFromMap(String attributeName, String key) {
        Map map = (Map)VaadinSession.getCurrent().getSession().getAttribute(attributeName);
        return VaadinUtils.getFirstValueFromCollection(map, key);
    }

    public static TimeZone getTimeZone(UI ui) {
        if (ui != null) {
            int offset = ui.getPage().getWebBrowser().getRawTimezoneOffset();
            boolean dst = ui.getPage().getWebBrowser().isDSTInEffect();
            String[] zones = TimeZone.getAvailableIDs(offset);
            if (zones != null && zones.length > 0) {
                for (String zone : zones) {
                    TimeZone tz = TimeZone.getTimeZone(zone);
                    if (tz.inDaylightTime(new Date()) != dst) continue;
                    return tz;
                }
            }
        }
        return TimeZone.getTimeZone("CET");
    }

    public static String integerToString(boolean grouping, boolean percentage, Integer value) {
        return VaadinUtils.integerToString(grouping, percentage, value, VaadinUtils.getLocale());
    }

    public static String integerToString(boolean grouping, boolean percentage, Integer value, Locale locale) {
        StringToIntegerConverter converter = ConverterFactory.createIntegerConverter(grouping, percentage);
        return converter.convertToPresentation((Object)value, String.class, locale);
    }

    public static String longToString(boolean grouping, boolean percentage, Long value) {
        return VaadinUtils.longToString(grouping, percentage, value, VaadinUtils.getLocale());
    }

    public static String longToString(boolean grouping, boolean percentage, Long value, Locale locale) {
        StringToLongConverter converter = ConverterFactory.createLongConverter(grouping, percentage);
        return converter.convertToPresentation((Object)value, String.class, locale);
    }

    public static void showConfirmDialog(MessageService messageService, String question, Runnable whenConfirmed) {
        if (UI.getCurrent() != null) {
            ConfirmDialog.show((UI)UI.getCurrent(), (String)messageService.getMessage("ocs.confirm", VaadinUtils.getLocale()), (String)question, (String)messageService.getMessage("ocs.yes", VaadinUtils.getLocale()), (String)messageService.getMessage("ocs.no", VaadinUtils.getLocale()), (ConfirmDialog.Listener & Serializable)dialog -> {
                if (dialog.isConfirmed()) {
                    whenConfirmed.run();
                }
            });
        } else {
            whenConfirmed.run();
        }
    }

    public static BigDecimal stringToBigDecimal(boolean percentage, boolean useGrouping, boolean currency, String value) {
        return VaadinUtils.stringToBigDecimal(percentage, useGrouping, currency, SystemPropertyUtils.getDefaultDecimalPrecision(), value, VaadinUtils.getLocale());
    }

    public static BigDecimal stringToBigDecimal(boolean percentage, boolean useGrouping, boolean currency, int precision, String value, Locale locale) {
        BigDecimalConverter converter = ConverterFactory.createBigDecimalConverter(currency, percentage, useGrouping, precision, VaadinUtils.getCurrencySymbol());
        return converter.convertToModel(value, BigDecimal.class, locale);
    }

    public static <T> String numberToString(AttributeModel attributeModel, Class<?> type, T value, boolean grouping, Locale locale) {
        Converter<String, ?> cv = ConverterFactory.createConverterFor(type, attributeModel, grouping);
        if (cv != null) {
            return (String)cv.convertToPresentation(value, String.class, locale);
        }
        return null;
    }

    public static Integer stringToInteger(boolean grouping, String value) {
        return VaadinUtils.stringToInteger(grouping, value, VaadinUtils.getLocale());
    }

    public static Integer stringToInteger(boolean grouping, String value, Locale locale) {
        StringToIntegerConverter converter = ConverterFactory.createIntegerConverter(grouping, false);
        return converter.convertToModel(value, Integer.class, locale);
    }

    public static Long stringToLong(boolean grouping, String value) {
        StringToLongConverter converter = ConverterFactory.createLongConverter(grouping, false);
        return converter.convertToModel(value, Long.class, VaadinUtils.getLocale());
    }

    public static Long stringToLong(boolean grouping, String value, Locale locale) {
        StringToLongConverter converter = ConverterFactory.createLongConverter(grouping, false);
        return converter.convertToModel(value, Long.class, locale);
    }

    public static void removeValidatorsOfType(Field<?> field, Class<?> validatorClass) {
        for (Validator v : field.getValidators()) {
            if (!v.getClass().equals(validatorClass)) continue;
            field.removeValidator(v);
        }
    }

    public static void loadScript(String id, String originalInput, boolean requireExternalScript, boolean execute) {
        if (!requireExternalScript) {
            String input = originalInput.replaceAll("'", "\"").replaceAll("\r\n", "\\\\r\\\\n").replaceAll("\n", "\\\\n").replaceAll("\\s+", " ").trim();
            Page.getCurrent().getJavaScript().execute("$('#" + id + "').html('" + input + "');");
        } else {
            String input = originalInput.replaceAll("'", "\"").replaceAll("\r\n", "").replaceAll("\n", "").replaceAll("\\s+", " ").replaceAll("\\\\n", "-").trim();
            Pattern pattern = Pattern.compile("<script.*?src=(.*?)></script>");
            Matcher matcher = pattern.matcher(input);
            if (matcher.find()) {
                String script = matcher.group(0);
                String url = matcher.group(1).replaceAll("\"", "").replaceAll("http://", "https://");
                input = input.replace(script, "");
                if (!execute) {
                    Page.getCurrent().getJavaScript().execute("$.getScript('" + url + "', function(){$('#" + id + "').html('" + input + "');})");
                } else {
                    Page.getCurrent().getJavaScript().execute("$('#" + id + "').html('" + input + "');");
                }
            }
        }
    }

    public static FormLayout wrapInFormLayout(Component c) {
        FormLayout fl = new FormLayout();
        fl.setMargin(false);
        fl.addComponent(c);
        return fl;
    }
}

