/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.validator;

import com.vaadin.data.Validator;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;

public class URLValidator
implements Validator {
    private static final String URL_PREFIX_SECURE = "https://";
    private static final String URL_PREFIX = "http://";
    private String message;
    private static final long serialVersionUID = 680372854650555066L;

    public URLValidator(String message) {
        this.message = message;
    }

    public void validate(Object value) {
        if (value == null || "".equals(value)) {
            return;
        }
        String str = (String)value;
        if (!str.contains(URL_PREFIX) && !str.contains(URL_PREFIX_SECURE)) {
            str = URL_PREFIX + str;
        }
        try {
            new URL(str);
        }
        catch (MalformedURLException ex) {
            throw new Validator.InvalidValueException(this.message);
        }
        if (StringUtils.countMatches((String)str, (String)".") < 2) {
            throw new Validator.InvalidValueException(this.message);
        }
    }
}

