/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.view;

import com.ocs.dynamo.domain.model.EntityModelFactory;
import com.ocs.dynamo.service.MessageService;
import com.ocs.dynamo.ui.BaseUI;
import com.ocs.dynamo.ui.component.DefaultVerticalLayout;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.vaadin.navigator.View;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.Layout;
import com.vaadin.ui.UI;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseView
extends CustomComponent
implements View {
    public static final String SELECTED_ID = "selectedId";
    private static final long serialVersionUID = 8340448520371840427L;
    private UI ui = UI.getCurrent();
    @Autowired
    private EntityModelFactory modelFactory;
    @Autowired
    private MessageService messageService;

    public EntityModelFactory getModelFactory() {
        return this.modelFactory;
    }

    protected String getScreenMode() {
        if (this.ui instanceof BaseUI) {
            BaseUI b = (BaseUI)this.ui;
            return b.getScreenMode();
        }
        return null;
    }

    protected void clearScreenMode() {
        if (this.ui instanceof BaseUI) {
            BaseUI b = (BaseUI)this.ui;
            b.setScreenMode(null);
        }
    }

    protected void navigate(String viewId) {
        this.ui.getNavigator().navigateTo(viewId);
    }

    protected String message(String key) {
        return this.messageService.getMessage(key, VaadinUtils.getLocale());
    }

    protected String message(String key, Object ... args) {
        return this.messageService.getMessage(key, VaadinUtils.getLocale(), args);
    }

    protected Layout initLayout() {
        DefaultVerticalLayout container = new DefaultVerticalLayout(true, true);
        this.setCompositionRoot((Component)container);
        return container;
    }

    public MessageService getMessageService() {
        return this.messageService;
    }
}

