/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.aop;

import com.ocs.dynamo.aop.AuditAspect;
import com.ocs.dynamo.domain.AbstractAuditableEntity;
import com.ocs.dynamo.service.UserDetailsService;
import org.aspectj.lang.ProceedingJoinPoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
public class AuditAspectTest {
    @InjectMocks
    private AuditAspect aspect = new AuditAspect();
    @Mock
    private UserDetailsService userDetailsService;
    @Mock
    private ProceedingJoinPoint joinPoint;

    @BeforeEach
    public void setUp() {
        Mockito.when((Object)this.userDetailsService.getCurrentUserName()).thenReturn((Object)"Kevin");
    }

    @Test
    public void testSaveNew() throws Throwable {
        MyAuditableEntity entity = new MyAuditableEntity();
        this.aspect.auditSave(this.joinPoint, (AbstractAuditableEntity)entity);
        Assertions.assertEquals((Object)"Kevin", (Object)entity.getCreatedBy());
        Assertions.assertEquals((Object)"Kevin", (Object)entity.getChangedBy());
        Assertions.assertNotNull((Object)entity.getCreatedBy());
        Assertions.assertNotNull((Object)entity.getChangedOn());
    }

    @Test
    public void testSaveExisting() throws Throwable {
        MyAuditableEntity entity = new MyAuditableEntity();
        entity.setId(33);
        entity.setCreatedBy("Stuart");
        entity.setChangedBy("Stuart");
        this.aspect.auditSave(this.joinPoint, (AbstractAuditableEntity)entity);
        Assertions.assertEquals((Object)"Stuart", (Object)entity.getCreatedBy());
        Assertions.assertEquals((Object)"Kevin", (Object)entity.getChangedBy());
        Assertions.assertNotNull((Object)entity.getCreatedBy());
        Assertions.assertNotNull((Object)entity.getChangedOn());
    }

    private class MyAuditableEntity
    extends AbstractAuditableEntity<Integer> {
        private static final long serialVersionUID = 5076818539497538764L;
        private Integer id;

        private MyAuditableEntity() {
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }
    }
}

