/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.dao.impl;

import com.ocs.dynamo.domain.TestEntity;
import com.ocs.dynamo.domain.query.PagingDataSetIterator;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DataSetIteratorTest {
    private PagingDataSetIterator<Integer, TestEntity> iterator;
    private List<Integer> ids = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(9), Integer.valueOf(10));
    private List<Integer> ids2 = List.of(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12);
    private int pagesRead = 0;

    @Test
    public void test() {
        this.iterator = new PagingDataSetIterator<Integer, TestEntity>(this.ids, 5){

            protected List<TestEntity> readPage(List<Integer> ids) {
                ArrayList<TestEntity> result = new ArrayList<TestEntity>();
                for (Integer i : ids) {
                    TestEntity entity = new TestEntity();
                    entity.setId(i);
                    result.add(entity);
                }
                ++DataSetIteratorTest.this.pagesRead;
                return result;
            }
        };
        int i = 0;
        TestEntity entity = null;
        do {
            if ((entity = (TestEntity)this.iterator.next()) == null) continue;
            ++i;
        } while (entity != null);
        Assertions.assertEquals((int)10, (int)i);
        Assertions.assertEquals((int)2, (int)this.pagesRead);
    }

    @Test
    public void testPartial() {
        this.iterator = new PagingDataSetIterator<Integer, TestEntity>(this.ids2, 5){

            protected List<TestEntity> readPage(List<Integer> ids) {
                ArrayList<TestEntity> result = new ArrayList<TestEntity>();
                for (Integer i : ids) {
                    TestEntity entity = new TestEntity();
                    entity.setId(i);
                    result.add(entity);
                }
                ++DataSetIteratorTest.this.pagesRead;
                return result;
            }
        };
        int i = 0;
        TestEntity entity = null;
        do {
            if ((entity = (TestEntity)this.iterator.next()) == null) continue;
            ++i;
        } while (entity != null);
        Assertions.assertEquals((int)12, (int)i);
        Assertions.assertEquals((int)3, (int)this.pagesRead);
    }
}

