/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.dao.impl;

import com.ocs.dynamo.dao.SortOrder;
import com.ocs.dynamo.exception.OCSRuntimeException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SortOrderDaoTest {
    @Test
    public void testDefaultAscending() {
        SortOrder order = new SortOrder("property");
        Assertions.assertEquals((Object)SortOrder.Direction.ASC, (Object)order.getDirection());
        Assertions.assertEquals((Object)"property", (Object)order.getProperty());
    }

    @Test
    public void testPropertyAndDirection() {
        SortOrder order = new SortOrder("property", SortOrder.Direction.DESC);
        Assertions.assertEquals((Object)SortOrder.Direction.DESC, (Object)order.getDirection());
        Assertions.assertEquals((Object)"property", (Object)order.getProperty());
    }

    @Test
    public void testPropertyAndDirectionFromString() {
        SortOrder order = new SortOrder("property", SortOrder.Direction.fromString((String)"ASC"));
        Assertions.assertEquals((Object)SortOrder.Direction.ASC, (Object)order.getDirection());
        Assertions.assertEquals((Object)"property", (Object)order.getProperty());
    }

    @Test
    public void testPropertyAndDirectionFromString2() {
        SortOrder order = new SortOrder("property", SortOrder.Direction.fromString((String)"DESC"));
        Assertions.assertEquals((Object)SortOrder.Direction.DESC, (Object)order.getDirection());
        Assertions.assertEquals((Object)"property", (Object)order.getProperty());
    }

    @Test
    public void testPropertyAndDirectionFromString_Wrong() {
        Assertions.assertThrows(OCSRuntimeException.class, () -> new SortOrder("property", SortOrder.Direction.fromString((String)"AS")));
    }

    @Test
    public void testEquals() {
        SortOrder order = new SortOrder("property");
        SortOrder order2 = new SortOrder("property");
        SortOrder order3 = new SortOrder("property", SortOrder.Direction.DESC);
        Assertions.assertFalse((boolean)order.equals(null));
        Assertions.assertFalse((boolean)order.equals(new Object()));
        Assertions.assertTrue((boolean)order.equals((Object)order));
        Assertions.assertTrue((boolean)order.equals((Object)order2));
        Assertions.assertFalse((boolean)order.equals((Object)order3));
    }
}

