/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.dao.impl;

import com.google.common.collect.Lists;
import com.ocs.dynamo.BackendIntegrationTest;
import com.ocs.dynamo.dao.FetchJoinInformation;
import com.ocs.dynamo.dao.Pageable;
import com.ocs.dynamo.dao.PageableImpl;
import com.ocs.dynamo.dao.SortOrder;
import com.ocs.dynamo.dao.SortOrders;
import com.ocs.dynamo.dao.impl.TestEntityDao;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.TestEntity;
import com.ocs.dynamo.filter.And;
import com.ocs.dynamo.filter.Compare;
import com.ocs.dynamo.filter.Filter;
import com.ocs.dynamo.filter.In;
import com.ocs.dynamo.utils.DateUtils;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.transaction.annotation.Transactional;

public class TestEntityDaoTest
extends BackendIntegrationTest {
    @Inject
    TestEntityDao dao;

    private TestEntity save(String name, long age) {
        TestEntity entity = new TestEntity();
        entity.setName(name);
        entity.setAge(age);
        entity = (TestEntity)this.dao.save((AbstractEntity)entity);
        return entity;
    }

    @Test
    public void testByUniqueProperty() {
        this.save("Jan", 11L);
        TestEntity t = (TestEntity)this.dao.findByUniqueProperty("name", "Jan", false);
        Assertions.assertNotNull((Object)((Object)t));
        t = (TestEntity)this.dao.fetchByUniqueProperty("name", "Jan", false, new FetchJoinInformation[0]);
        Assertions.assertNotNull((Object)((Object)t));
        t = (TestEntity)this.dao.fetchByUniqueProperty("name", "Jan", true, new FetchJoinInformation[0]);
        Assertions.assertNotNull((Object)((Object)t));
        t = (TestEntity)this.dao.findByUniqueProperty("name", "JAN", false);
        Assertions.assertNotNull((Object)((Object)t));
        t = (TestEntity)this.dao.fetchByUniqueProperty("name", "JAN", true, new FetchJoinInformation[0]);
        Assertions.assertNull((Object)((Object)t));
        t = (TestEntity)this.dao.findByUniqueProperty("name", "Bert", false);
        Assertions.assertNull((Object)((Object)t));
    }

    @Test
    public void testDelete() {
        TestEntity entity = this.save("Piet", 12L);
        Integer id = entity.getId();
        this.dao.delete((AbstractEntity)entity);
        Assertions.assertNull((Object)this.dao.findById(id));
    }

    @Test
    public void testFetch() {
        this.save("Kevin", 11L);
        this.save("Stuart", 12L);
        this.save("Bob", 13L);
        List results = this.dao.fetch(null, new FetchJoinInformation[0]);
        Assertions.assertEquals((int)3, (int)results.size());
        results = this.dao.fetch((Filter)new Compare.Equal("name", (Object)"Bob"), new FetchJoinInformation[0]);
        Assertions.assertEquals((int)1, (int)results.size());
        results = this.dao.fetch(null, new SortOrders(new SortOrder[]{new SortOrder("name")}), new FetchJoinInformation[0]);
        Assertions.assertEquals((int)3, (int)results.size());
        Assertions.assertEquals((Object)"Bob", (Object)((TestEntity)((Object)results.get(0))).getName());
        results = this.dao.fetch(null, new SortOrders(new SortOrder[]{new SortOrder("name")}), new FetchJoinInformation[]{new FetchJoinInformation("testEntities")});
        Assertions.assertEquals((int)3, (int)results.size());
        Assertions.assertEquals((Object)"Bob", (Object)((TestEntity)((Object)results.get(0))).getName());
    }

    @Test
    public void testFetchSelect() {
        this.save("Pete", 1L);
        this.save("Bob", 2L);
        this.save("Isaac", 3L);
        TestEntity e1 = (TestEntity)((Object)this.entityManager.createQuery("from TestEntity t where t.name = 'Bob'", TestEntity.class).getSingleResult());
        TestEntity e2 = (TestEntity)((Object)this.entityManager.createQuery("from TestEntity t where t.name = 'Pete'", TestEntity.class).getSingleResult());
        SortOrder sortName = new SortOrder("name");
        In filter = new In("name", (Collection)Lists.newArrayList((Object[])new String[]{e1.getName(), e2.getName()}));
        List result = this.dao.findSelect((Filter)filter, new String[]{"name", "age"}, new SortOrders(new SortOrder[]{sortName}));
        Assertions.assertEquals((int)2, (int)result.size());
        Assertions.assertEquals((Object)e1.getName(), (Object)((Object[])result.get(0))[0]);
        Assertions.assertEquals((Object)e1.getAge(), (Object)((Object[])result.get(0))[1]);
        Assertions.assertEquals((Object)e2.getName(), (Object)((Object[])result.get(1))[0]);
        Assertions.assertEquals((Object)e2.getAge(), (Object)((Object[])result.get(1))[1]);
    }

    public void testFindByBirthDateLocal() {
        List<TestEntity> result = this.dao.findByBirthDate();
        Assertions.assertEquals((int)0, (int)result.size());
        TestEntity bob = this.save("Bob", 55L);
        bob.setBirthDate(DateUtils.createLocalDate((String)"10081980"));
        bob = (TestEntity)this.dao.save((AbstractEntity)bob);
        result = this.dao.findByBirthDate();
        Assertions.assertEquals((int)1, (int)result.size());
    }

    @Test
    public void testFindDistinct() {
        this.save("Kevin", 11L);
        this.save("Bob", 11L);
        this.save("Bob", 11L);
        List names = this.dao.findDistinct(null, "name", String.class, new SortOrder[]{new SortOrder("name")});
        Assertions.assertEquals((int)2, (int)names.size());
        Assertions.assertEquals((Object)"Bob", names.get(0));
        Assertions.assertEquals((Object)"Kevin", names.get(1));
        List ages = this.dao.findDistinct(null, "age", String.class, new SortOrder[]{new SortOrder("age")});
        Assertions.assertEquals((int)1, (int)ages.size());
        Assertions.assertEquals((Object)11L, ages.get(0));
    }

    @Test
    public void testFindDistinctForCollectionTable() {
        this.save("Kevin", 11L);
        this.save("Bob", 11L);
        this.save("Bob", 11L);
        List names = this.dao.findDistinctInCollectionTable("test_entity", "name", String.class);
        Assertions.assertEquals((int)2, (int)names.size());
        List ages = this.dao.findDistinctInCollectionTable("test_entity", "age", Long.class);
        Assertions.assertEquals((int)1, (int)ages.size());
    }

    @Test
    public void testFindFilter() {
        TestEntity jan = this.save("Jan", 11L);
        this.save("Piet", 12L);
        this.save("Klaas", 13L);
        Compare.Equal filter = new Compare.Equal("name", (Object)"Jan");
        Assertions.assertEquals((long)1L, (long)this.dao.count((Filter)filter, true));
        List list = this.dao.find((Filter)filter);
        Assertions.assertEquals((Object)((Object)jan), list.get(0));
        And and = new And(new Filter[]{filter, new Compare.Equal("age", (Object)99L)});
        list = this.dao.find((Filter)and);
        Assertions.assertEquals((int)0, (int)list.size());
        and = new And(new Filter[]{filter, new Compare.Equal("age", (Object)11L)});
        SortOrder order = new SortOrder("name", SortOrder.Direction.ASC);
        list = this.dao.find((Filter)and, new SortOrder[]{order});
        Assertions.assertEquals((int)1, (int)list.size());
        list = this.dao.find(null, new SortOrder[]{order});
        Assertions.assertEquals((int)3, (int)list.size());
        Assertions.assertEquals((Object)"Jan", (Object)((TestEntity)((Object)list.get(0))).getName());
        Assertions.assertEquals((Object)"Klaas", (Object)((TestEntity)((Object)list.get(1))).getName());
        Assertions.assertEquals((Object)"Piet", (Object)((TestEntity)((Object)list.get(2))).getName());
    }

    @Test
    public void testFindIdsAndFetch() {
        this.save("Jan", 11L);
        this.save("Piet", 12L);
        this.save("Klaas", 13L);
        List ids = this.dao.findIds(null, new SortOrder[]{new SortOrder("name", SortOrder.Direction.ASC)});
        Assertions.assertEquals((int)3, (int)ids.size());
        TestEntity entity = (TestEntity)this.dao.fetchById((Integer)ids.get(0), new FetchJoinInformation[0]);
        Assertions.assertEquals((Object)"Jan", (Object)entity.getName());
        ids = this.dao.findIds(null, new SortOrder[]{new SortOrder("name", SortOrder.Direction.DESC)});
        Assertions.assertEquals((int)3, (int)ids.size());
        entity = (TestEntity)this.dao.fetchById((Integer)ids.get(0), new FetchJoinInformation[0]);
        Assertions.assertEquals((Object)"Piet", (Object)entity.getName());
        List list = this.dao.fetchByIds(ids, new SortOrders(new SortOrder[]{new SortOrder("name", SortOrder.Direction.ASC)}), new FetchJoinInformation[0]);
        Assertions.assertEquals((Object)"Jan", (Object)((TestEntity)((Object)list.get(0))).getName());
        Assertions.assertEquals((Object)"Klaas", (Object)((TestEntity)((Object)list.get(1))).getName());
        Assertions.assertEquals((Object)"Piet", (Object)((TestEntity)((Object)list.get(2))).getName());
    }

    @Test
    public void testFindSelect() {
        this.save("Pete", 1L);
        this.save("Bob", 2L);
        this.save("Isaac", 3L);
        List found = this.dao.findSelect(null, new String[]{"name", "age"}, new SortOrders(new SortOrder[]{new SortOrder("name")}));
        Assertions.assertEquals((int)3, (int)found.size());
        Object[] obj = (Object[])found.get(0);
        Assertions.assertEquals((Object)"Bob", (Object)obj[0]);
        Assertions.assertEquals((Object)2L, (Object)obj[1]);
    }

    @Test
    @Transactional
    public void testFindSelect2() {
        this.save("Pete", 1L);
        this.save("Bob", 2L);
        this.save("Isaac", 3L);
        SortOrders so = new SortOrders(new SortOrder[]{new SortOrder("name")});
        PageableImpl pag = new PageableImpl(0, 10, so);
        List found = this.dao.findSelect(null, new String[]{"name", "age"}, (Pageable)pag);
        Assertions.assertEquals((int)3, (int)found.size());
        Object[] obj = (Object[])found.get(0);
        Assertions.assertEquals((Object)"Bob", (Object)obj[0]);
        Assertions.assertEquals((Object)2L, (Object)obj[1]);
    }

    @Test
    @Transactional
    public void testFlushAndClear() {
        TestEntity entity = this.save("Jan", 11L);
        Assertions.assertTrue((boolean)this.getEntityManager().contains((Object)entity));
        this.dao.flushAndClear();
        Assertions.assertFalse((boolean)this.getEntityManager().contains((Object)entity));
    }

    @Test
    public void testSaveAndFind() {
        TestEntity entity = this.save("Piet", 12L);
        TestEntity detail = new TestEntity();
        detail.setAge(2L);
        detail.setName("Jantje");
        entity.addChild(detail);
        entity = (TestEntity)this.dao.save((AbstractEntity)entity);
        Assertions.assertNotNull((Object)entity.getId());
        Integer id = entity.getId();
        TestEntity other = (TestEntity)this.dao.findById(id);
        Assertions.assertEquals((Object)((Object)other), (Object)((Object)entity));
    }

    @Test
    public void testSaveBulk() {
        TestEntity entity1 = new TestEntity("Bob", 1L);
        TestEntity entity2 = new TestEntity("Bob", 2L);
        TestEntity entity3 = new TestEntity("Bob", 3L);
        this.dao.save(Lists.newArrayList((Object[])new TestEntity[]{entity1, entity2, entity3}));
        List list = this.dao.findAll();
        Assertions.assertEquals((int)3, (int)list.size());
    }

    @Test
    public void testTree() {
        TestEntity entity = this.save("Piet", 12L);
        TestEntity detail = new TestEntity();
        detail.setAge(24L);
        detail.setName("Jantje");
        entity.addChild(detail);
        entity.addChild(detail);
        entity = (TestEntity)this.dao.save((AbstractEntity)entity);
        detail = (TestEntity)((Object)entity.getChildren().get(0));
        Assertions.assertNotNull((Object)detail.getId());
        List roots = this.dao.findByParentIsNull();
        Assertions.assertEquals((int)1, (int)roots.size());
        Assertions.assertEquals((Object)((Object)entity), roots.get(0));
        List children = this.dao.findByParent((AbstractEntity)entity);
        Assertions.assertEquals((int)1, (int)children.size());
        Assertions.assertEquals((Object)((Object)detail), children.get(0));
    }
}

