/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.dao.query;

import com.google.common.collect.Lists;
import com.ocs.dynamo.BackendIntegrationTest;
import com.ocs.dynamo.dao.FetchJoinInformation;
import com.ocs.dynamo.dao.QueryFunction;
import com.ocs.dynamo.dao.SortOrder;
import com.ocs.dynamo.dao.SortOrders;
import com.ocs.dynamo.dao.impl.JpaQueryBuilder;
import com.ocs.dynamo.domain.TestEntity;
import com.ocs.dynamo.domain.TestEntity2;
import com.ocs.dynamo.filter.And;
import com.ocs.dynamo.filter.Between;
import com.ocs.dynamo.filter.Compare;
import com.ocs.dynamo.filter.Filter;
import com.ocs.dynamo.filter.In;
import com.ocs.dynamo.filter.IsNull;
import com.ocs.dynamo.filter.Like;
import com.ocs.dynamo.filter.Modulo;
import com.ocs.dynamo.filter.Not;
import com.ocs.dynamo.filter.Or;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JpaQueryBuilderTest
extends BackendIntegrationTest {
    @PersistenceContext
    private EntityManager entityManager;

    @BeforeEach
    public void setUp() {
        this.save("Bob", 25L);
        this.save("Sally", 35L);
        this.save("Pete", 44L);
    }

    private void insertNestedTestEntities() {
        TestEntity2 t1 = new TestEntity2();
        t1.setName("Likes science fiction");
        t1.setValue(12);
        TestEntity2 t2 = new TestEntity2();
        t2.setName("Likes adventure");
        t2.setValue(24);
        TestEntity m1 = this.createTestEntity("Manager 1", 30L, TestEntity.TestEnum.C, t1);
        t1.setTestEntityAlt(m1);
        TestEntity m2 = this.createTestEntity("Manager 2", 40L, TestEntity.TestEnum.A, t2);
        t2.setTestEntityAlt(m2);
        TestEntity2 t3 = new TestEntity2();
        t3.setName("Not into much");
        t3.setValue(0);
        this.entityManager.persist((Object)t3);
    }

    @Test
    public void testCreateCountQuery() {
        TypedQuery tQuery = JpaQueryBuilder.createCountQuery((EntityManager)this.entityManager, TestEntity.class, null, (boolean)false);
        long count = (Long)tQuery.getSingleResult();
        Assertions.assertEquals((long)3L, (long)count);
    }

    @Test
    public void testCreateCountQuery_Equals() {
        TypedQuery tQuery = JpaQueryBuilder.createCountQuery((EntityManager)this.entityManager, TestEntity.class, (Filter)new Compare.Equal("name", (Object)"Bob"), (boolean)false);
        long count = (Long)tQuery.getSingleResult();
        Assertions.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testCreateCountQuery_Greater() {
        TypedQuery tQuery = JpaQueryBuilder.createCountQuery((EntityManager)this.entityManager, TestEntity.class, (Filter)new Compare.Greater("age", (Object)25L), (boolean)false);
        long count = (Long)tQuery.getSingleResult();
        Assertions.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testCreateCountQuery_GreaterOrEqual() {
        TypedQuery tQuery = JpaQueryBuilder.createCountQuery((EntityManager)this.entityManager, TestEntity.class, (Filter)new Compare.GreaterOrEqual("age", (Object)25L), (boolean)false);
        long count = (Long)tQuery.getSingleResult();
        Assertions.assertEquals((long)3L, (long)count);
    }

    @Test
    public void testCreateCountQuery_Less() {
        TypedQuery tQuery = JpaQueryBuilder.createCountQuery((EntityManager)this.entityManager, TestEntity.class, (Filter)new Compare.Less("age", (Object)25L), (boolean)false);
        long count = (Long)tQuery.getSingleResult();
        Assertions.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testCreateCountQuery_LessOrEqual() {
        TypedQuery tQuery = JpaQueryBuilder.createCountQuery((EntityManager)this.entityManager, TestEntity.class, (Filter)new Compare.LessOrEqual("age", (Object)25L), (boolean)false);
        long count = (Long)tQuery.getSingleResult();
        Assertions.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testCreateCountQuery_LikeCaseSensitive() {
        TypedQuery tQuery = JpaQueryBuilder.createCountQuery((EntityManager)this.entityManager, TestEntity.class, (Filter)new Like("name", "s%", true), (boolean)false);
        long count = (Long)tQuery.getSingleResult();
        Assertions.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testCreateCountQuery_LikeCaseInsensitive() {
        TypedQuery tQuery = JpaQueryBuilder.createCountQuery((EntityManager)this.entityManager, TestEntity.class, (Filter)new Like("name", "s%", false), (boolean)false);
        long count = (Long)tQuery.getSingleResult();
        Assertions.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testCreateCountQuery_LikeCaseInsensitiveInfx() {
        TypedQuery tQuery = JpaQueryBuilder.createCountQuery((EntityManager)this.entityManager, TestEntity.class, (Filter)new Like("name", "%a%", false), (boolean)false);
        long count = (Long)tQuery.getSingleResult();
        Assertions.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testCreateCountQuery_Between() {
        TypedQuery tQuery = JpaQueryBuilder.createCountQuery((EntityManager)this.entityManager, TestEntity.class, (Filter)new Between("age", (Comparable)Long.valueOf(20L), (Comparable)Long.valueOf(30L)), (boolean)false);
        long count = (Long)tQuery.getSingleResult();
        Assertions.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testCreateCountQuery_IsNull() {
        TypedQuery tQuery = JpaQueryBuilder.createCountQuery((EntityManager)this.entityManager, TestEntity.class, (Filter)new IsNull("age"), (boolean)false);
        long count = (Long)tQuery.getSingleResult();
        Assertions.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testCreateCountQuery_In() {
        TypedQuery tQuery = JpaQueryBuilder.createCountQuery((EntityManager)this.entityManager, TestEntity.class, (Filter)new In("name", (Collection)Lists.newArrayList((Object[])new String[]{"Bob", "Sally"})), (boolean)false);
        long count = (Long)tQuery.getSingleResult();
        Assertions.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testCreateCountQuery_InEmpty() {
        TypedQuery tQuery = JpaQueryBuilder.createCountQuery((EntityManager)this.entityManager, TestEntity.class, (Filter)new In("id", new ArrayList()), (boolean)false);
        long count = (Long)tQuery.getSingleResult();
        Assertions.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testCreateCountQuery_ModuloLiteral() {
        TypedQuery tQuery = JpaQueryBuilder.createCountQuery((EntityManager)this.entityManager, TestEntity.class, (Filter)new Modulo("age", Integer.valueOf(4), (Number)0), (boolean)false);
        long count = (Long)tQuery.getSingleResult();
        Assertions.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testCreateCountQuery_ModuloExpression() {
        TypedQuery tQuery = JpaQueryBuilder.createCountQuery((EntityManager)this.entityManager, TestEntity.class, (Filter)new Modulo("age", "age", (Number)0), (boolean)false);
        long count = (Long)tQuery.getSingleResult();
        Assertions.assertEquals((long)3L, (long)count);
    }

    @Test
    public void testCreateCountQuery_And() {
        TypedQuery tQuery = JpaQueryBuilder.createCountQuery((EntityManager)this.entityManager, TestEntity.class, (Filter)new And(new Filter[]{new Compare.Equal("name", (Object)"Bob"), new Compare.Equal("age", (Object)25L)}), (boolean)false);
        long count = (Long)tQuery.getSingleResult();
        Assertions.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testCreateCountQuery_Not() {
        TypedQuery tQuery = JpaQueryBuilder.createCountQuery((EntityManager)this.entityManager, TestEntity.class, (Filter)new Not((Filter)new Compare.Equal("name", (Object)"Bob")), (boolean)false);
        long count = (Long)tQuery.getSingleResult();
        Assertions.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testCreateCountQuery_Or() {
        TypedQuery tQuery = JpaQueryBuilder.createCountQuery((EntityManager)this.entityManager, TestEntity.class, (Filter)new Or(new Filter[]{new Compare.Equal("name", (Object)"Bob"), new Compare.Equal("age", (Object)35L)}), (boolean)false);
        long count = (Long)tQuery.getSingleResult();
        Assertions.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testCreateFetchQuery() {
        TestEntity e1 = (TestEntity)((Object)this.entityManager.createQuery("from TestEntity t where t.name = 'Bob'", TestEntity.class).getSingleResult());
        TypedQuery tQuery = JpaQueryBuilder.createFetchQuery((EntityManager)this.entityManager, TestEntity.class, (List)Lists.newArrayList((Object[])new Integer[]{e1.getId()}), null, null, (FetchJoinInformation[])new FetchJoinInformation[0]);
        List entity = tQuery.getResultList();
        Assertions.assertEquals((int)1, (int)entity.size());
    }

    @Test
    public void testCreateFetchQueryAdditionalFilter() {
        TestEntity e1 = (TestEntity)((Object)this.entityManager.createQuery("from TestEntity t where t.name = 'Bob'", TestEntity.class).getSingleResult());
        TypedQuery tQuery = JpaQueryBuilder.createFetchQuery((EntityManager)this.entityManager, TestEntity.class, (List)Lists.newArrayList((Object[])new Integer[]{e1.getId()}), (Filter)new Compare.Equal("name", (Object)"Bob"), null, (FetchJoinInformation[])new FetchJoinInformation[0]);
        List entity = tQuery.getResultList();
        Assertions.assertEquals((int)1, (int)entity.size());
    }

    @Test
    public void testCreateFetchQuery2() {
        TestEntity e1 = (TestEntity)((Object)this.entityManager.createQuery("from TestEntity t where t.name = 'Bob'", TestEntity.class).getSingleResult());
        TestEntity2 e2 = new TestEntity2();
        e2.setTestEntity(e1);
        this.entityManager.persist((Object)e2);
        TypedQuery tQuery = JpaQueryBuilder.createFetchQuery((EntityManager)this.entityManager, TestEntity2.class, (List)Lists.newArrayList((Object[])new Integer[]{e2.getId()}), null, null, (FetchJoinInformation[])new FetchJoinInformation[]{new FetchJoinInformation("testEntity")});
        List entity = tQuery.getResultList();
        Assertions.assertEquals((int)1, (int)entity.size());
        Assertions.assertEquals((Object)((Object)e1), (Object)((Object)((TestEntity2)((Object)entity.get(0))).getTestEntity()));
    }

    @Test
    public void testCreateFetchSingleObjectQuery() {
        TestEntity e1 = (TestEntity)((Object)this.entityManager.createQuery("from TestEntity t where t.name = 'Bob'", TestEntity.class).getSingleResult());
        TypedQuery tQuery = JpaQueryBuilder.createFetchSingleObjectQuery((EntityManager)this.entityManager, TestEntity.class, (Object)e1.getId(), null);
        TestEntity entity = (TestEntity)((Object)tQuery.getSingleResult());
        Assertions.assertEquals((Object)((Object)e1), (Object)((Object)entity));
    }

    private void save(String name, long age) {
        TestEntity entity = new TestEntity(name, age);
        this.entityManager.persist((Object)entity);
    }

    @Test
    public void testCreateSelectQuery() {
        TestEntity e1 = (TestEntity)((Object)this.entityManager.createQuery("from TestEntity t where t.name = 'Bob'", TestEntity.class).getSingleResult());
        TestEntity e2 = (TestEntity)((Object)this.entityManager.createQuery("from TestEntity t where t.name = 'Pete'", TestEntity.class).getSingleResult());
        SortOrder sortName = new SortOrder("name");
        In filter = new In("name", (Collection)Lists.newArrayList((Object[])new String[]{e1.getName(), e2.getName()}));
        TypedQuery tQuery = JpaQueryBuilder.createSelectQuery((Filter)filter, (EntityManager)this.entityManager, TestEntity.class, (String[])new String[]{"name", "age"}, (SortOrders)new SortOrders(new SortOrder[]{sortName}));
        List result = tQuery.getResultList();
        Assertions.assertEquals((int)2, (int)result.size());
        Assertions.assertEquals((Object)e1.getName(), (Object)((Object[])result.get(0))[0]);
        Assertions.assertEquals((Object)e1.getAge(), (Object)((Object[])result.get(0))[1]);
        Assertions.assertEquals((Object)e2.getName(), (Object)((Object[])result.get(1))[0]);
        Assertions.assertEquals((Object)e2.getAge(), (Object)((Object[])result.get(1))[1]);
    }

    @Test
    public void testCreateSelectAggregateQuery() {
        Object base = this.entityManager.createQuery("select avg(age), count(1), sum(age) from TestEntity").getSingleResult();
        TypedQuery tQuery = JpaQueryBuilder.createSelectQuery(null, (EntityManager)this.entityManager, TestEntity.class, (String[])new String[]{QueryFunction.AF_AVG.with("age"), QueryFunction.AF_COUNT.with("age"), QueryFunction.AF_SUM.with("age")}, null);
        List result = tQuery.getResultList();
        Assertions.assertEquals((int)1, (int)result.size());
        Object[] br = (Object[])base;
        Assertions.assertTrue((boolean)br[0].equals(((Object[])result.get(0))[0]));
        Assertions.assertTrue((boolean)br[1].equals(((Object[])result.get(0))[1]));
        Assertions.assertTrue((boolean)br[2].equals(((Object[])result.get(0))[2]));
    }

    @Test
    public void testCreateSelectAggregateAndGroupQuery() {
        this.insertNestedTestEntities();
        List base = this.entityManager.createQuery("select avg(age), count(1), sum(age), someEnum from TestEntity group by someEnum order by someEnum").getResultList();
        TypedQuery tQuery = JpaQueryBuilder.createSelectQuery(null, (EntityManager)this.entityManager, TestEntity.class, (String[])new String[]{QueryFunction.AF_AVG.with("age"), QueryFunction.AF_COUNT.with("age"), QueryFunction.AF_SUM.with("age"), "someEnum"}, (SortOrders)new SortOrders(new SortOrder[]{new SortOrder("someEnum")}));
        List result = tQuery.getResultList();
        Assertions.assertEquals((int)3, (int)result.size());
        Object[] br = (Object[])base.get(0);
        Assertions.assertTrue((boolean)br[0].equals(((Object[])result.get(0))[0]));
        Assertions.assertTrue((boolean)br[1].equals(((Object[])result.get(0))[1]));
        Assertions.assertTrue((boolean)br[2].equals(((Object[])result.get(0))[2]));
    }

    @Test
    public void testCreateSelectAggregateJoinAndGroupQuery() {
        this.insertNestedTestEntities();
        List base = this.entityManager.createQuery("select t1.name, sum(t2.value) from TestEntity t1 join t1.testEntities t2 group by t1.name order by t1.name").getResultList();
        TypedQuery tQuery = JpaQueryBuilder.createSelectQuery(null, (EntityManager)this.entityManager, TestEntity.class, (String[])new String[]{"name", QueryFunction.AF_SUM.with("testEntities.value")}, (SortOrders)new SortOrders(new SortOrder[]{new SortOrder("name")}));
        List result = tQuery.getResultList();
        Assertions.assertEquals((int)2, (int)result.size());
        Object[] br = (Object[])base.get(0);
        Assertions.assertTrue((boolean)br[0].equals(((Object[])result.get(0))[0]));
        Assertions.assertTrue((boolean)br[1].equals(((Object[])result.get(0))[1]));
        Object[] br1 = (Object[])base.get(1);
        Assertions.assertTrue((boolean)br1[0].equals(((Object[])result.get(1))[0]));
        Assertions.assertTrue((boolean)br1[1].equals(((Object[])result.get(1))[1]));
    }

    @Test
    public void testCreateSelectAggregateJoinAndGroupQuery2() {
        this.insertNestedTestEntities();
        List base = this.entityManager.createQuery("select t2.value, sum(t3.age) from TestEntity t1 join t1.testEntities t2 join t2.testEntityAlt t3 group by t2.value order by t2.value").getResultList();
        TypedQuery tQuery = JpaQueryBuilder.createSelectQuery(null, (EntityManager)this.entityManager, TestEntity.class, (String[])new String[]{"testEntities.value", QueryFunction.AF_SUM.with("testEntities.testEntityAlt.age")}, (SortOrders)new SortOrders(new SortOrder[]{new SortOrder("testEntities.value")}));
        List result = tQuery.getResultList();
        Assertions.assertEquals((int)2, (int)result.size());
        Object[] br = (Object[])base.get(0);
        Assertions.assertTrue((boolean)br[0].equals(((Object[])result.get(0))[0]));
        Assertions.assertTrue((boolean)br[1].equals(((Object[])result.get(0))[1]));
    }

    @Test
    public void testCreateDistinctQuery() {
        this.insertNestedTestEntities();
        TypedQuery tQuery = JpaQueryBuilder.createDistinctQuery((Filter)new Like("testEntities.name", "Lik%", false), (EntityManager)this.entityManager, TestEntity.class, (String)"testEntities.value", (SortOrder[])new SortOrder[0]);
        List result = tQuery.getResultList();
        Assertions.assertEquals((int)2, (int)result.size());
    }

    @Test
    public void testCreateSelectDistinctCountQuery() {
        List base = this.entityManager.createQuery("select count( distinct age) from TestEntity").getResultList();
        TypedQuery tQuery = JpaQueryBuilder.createSelectQuery(null, (EntityManager)this.entityManager, TestEntity.class, (String[])new String[]{QueryFunction.AF_COUNT_DISTINCT.with("age")}, null);
        List result = tQuery.getResultList();
        Assertions.assertEquals((int)1, (int)result.size());
        Long b = (Long)base.get(0);
        Long r = (Long)result.get(0);
        Assertions.assertTrue((boolean)b.equals(r));
    }

    private TestEntity createTestEntity(String name, long age, TestEntity.TestEnum te, TestEntity2 ... testEntities2) {
        TestEntity entity = new TestEntity(name, age);
        entity.setSomeEnum(te);
        if (testEntities2 != null) {
            for (TestEntity2 t : testEntities2) {
                entity.addTestEntity2(t);
            }
        }
        this.entityManager.persist((Object)entity);
        return entity;
    }
}

