/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.domain;

import com.ocs.dynamo.domain.AbstractTreeEntity;
import com.ocs.dynamo.domain.TestDomain;
import com.ocs.dynamo.domain.TestEntity2;
import com.ocs.dynamo.domain.model.AttributeTextFieldMode;
import com.ocs.dynamo.domain.model.annotation.Attribute;
import com.ocs.dynamo.domain.model.annotation.Model;
import com.ocs.dynamo.domain.model.annotation.SearchMode;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

@Entity
@Table(name="test_entity")
@Model(displayProperty="name", sortOrder="name,age")
public class TestEntity
extends AbstractTreeEntity<Integer, TestEntity> {
    private static final long serialVersionUID = 5557043276302609211L;
    @Id
    @GeneratedValue
    private Integer id;
    @Size(max=25)
    @Attribute(main=true, searchable=SearchMode.ALWAYS)
    @NotNull
    private @Size(max=25) @NotNull String name;
    @Attribute(searchable=SearchMode.ALWAYS)
    private Long age;
    @Attribute(searchable=SearchMode.ALWAYS)
    private BigDecimal discount;
    @Attribute(percentage=true, searchable=SearchMode.ALWAYS)
    private BigDecimal rate;
    @Attribute(displayFormat="dd/MM/yyyy", searchable=SearchMode.ALWAYS)
    private LocalDate birthDate;
    private LocalTime registrationTime;
    @Attribute(week=true)
    private LocalDate birthWeek;
    @Attribute(searchable=SearchMode.ALWAYS)
    private TestEnum someEnum;
    @Lob
    private byte[] someBytes;
    private Boolean someBoolean;
    private String someString;
    private Integer someInt;
    @Attribute(textFieldMode=AttributeTextFieldMode.TEXTAREA)
    private String someTextArea;
    @Attribute(trueRepresentation="On", falseRepresentation="Off")
    private Boolean someBoolean2;
    @OneToMany(mappedBy="testEntity", cascade={CascadeType.ALL})
    @Attribute(searchable=SearchMode.ALWAYS)
    private Set<TestEntity2> testEntities = new HashSet<TestEntity2>();
    @Attribute(displayFormat="HH:mm:ss")
    private LocalTime someTime;
    @ElementCollection
    @Attribute(maxLength=25)
    private Set<String> tags = new HashSet<String>();
    @Attribute(url=true)
    private String url;
    @Attribute(quickAddPropertyName="name", navigable=true)
    private TestDomain testDomain;
    @ElementCollection
    private Set<Integer> intTags = new HashSet<Integer>();
    @ElementCollection
    @Attribute(minValue=34L)
    private Set<Long> longTags = new HashSet<Long>();
    private ZonedDateTime zoned;
    private Double someDouble;

    public TestEntity() {
    }

    public TestEntity(int id, String name, Long age) {
        this.id = id;
        this.name = name;
        this.age = age;
    }

    public TestEntity(String name, Long age) {
        this.name = name;
        this.age = age;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getAge() {
        return this.age;
    }

    public void setAge(Long age) {
        this.age = age;
    }

    public BigDecimal getDiscount() {
        return this.discount;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }

    public LocalDate getBirthDate() {
        return this.birthDate;
    }

    public void setBirthDate(LocalDate birthDate) {
        this.birthDate = birthDate;
    }

    public LocalDate getBirthWeek() {
        return this.birthWeek;
    }

    public void setBirthWeek(LocalDate birthWeek) {
        this.birthWeek = birthWeek;
    }

    public TestEnum getSomeEnum() {
        return this.someEnum;
    }

    public void setSomeEnum(TestEnum someEnum) {
        this.someEnum = someEnum;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)((Object)this));
    }

    public byte[] getSomeBytes() {
        return this.someBytes;
    }

    public void setSomeBytes(byte[] someBytes) {
        this.someBytes = someBytes;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public Boolean getSomeBoolean() {
        return this.someBoolean;
    }

    public void setSomeBoolean(Boolean someBoolean) {
        this.someBoolean = someBoolean;
    }

    public String getSomeString() {
        return this.someString;
    }

    public void setSomeString(String someString) {
        this.someString = someString;
    }

    public Boolean getSomeBoolean2() {
        return this.someBoolean2;
    }

    public void setSomeBoolean2(Boolean someBoolean2) {
        this.someBoolean2 = someBoolean2;
    }

    public Integer getSomeInt() {
        return this.someInt;
    }

    public void setSomeInt(Integer someInt) {
        this.someInt = someInt;
    }

    public Set<TestEntity2> getTestEntities() {
        return this.testEntities;
    }

    public void setTestEntities(Set<TestEntity2> testEntities) {
        this.testEntities = testEntities;
    }

    public void addTestEntity2(TestEntity2 entity2) {
        this.testEntities.add(entity2);
        entity2.setTestEntity(this);
    }

    public LocalTime getSomeTime() {
        return this.someTime;
    }

    public void setSomeTime(LocalTime someTime) {
        this.someTime = someTime;
    }

    public String getSomeTextArea() {
        return this.someTextArea;
    }

    public void setSomeTextArea(String someTextArea) {
        this.someTextArea = someTextArea;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @AssertTrue
    public boolean isAssertSomething() {
        return !"bogus".equals(this.name);
    }

    public TestDomain getTestDomain() {
        return this.testDomain;
    }

    public void setTestDomain(TestDomain testDomain) {
        this.testDomain = testDomain;
    }

    public Set<Integer> getIntTags() {
        return this.intTags;
    }

    public void setIntTags(Set<Integer> intTags) {
        this.intTags = intTags;
    }

    public Set<Long> getLongTags() {
        return this.longTags;
    }

    public void setLongTags(Set<Long> longTags) {
        this.longTags = longTags;
    }

    public LocalTime getRegistrationTime() {
        return this.registrationTime;
    }

    public void setRegistrationTime(LocalTime registrationTime) {
        this.registrationTime = registrationTime;
    }

    public ZonedDateTime getZoned() {
        return this.zoned;
    }

    public void setZoned(ZonedDateTime zoned) {
        this.zoned = zoned;
    }

    public Double getSomeDouble() {
        return this.someDouble;
    }

    public void setSomeDouble(Double someDouble) {
        this.someDouble = someDouble;
    }

    public static enum TestEnum {
        A,
        B,
        C;

    }
}

