/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.domain.model.impl;

import com.ocs.dynamo.domain.model.AttributeDateType;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.AttributeSelectMode;
import com.ocs.dynamo.domain.model.AttributeTextFieldMode;
import com.ocs.dynamo.domain.model.AttributeType;
import com.ocs.dynamo.domain.model.CascadeMode;
import com.ocs.dynamo.domain.model.EditableType;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.domain.model.TrimType;
import com.ocs.dynamo.domain.model.VisibilityType;
import com.ocs.dynamo.domain.model.annotation.Attribute;
import com.ocs.dynamo.domain.model.annotation.AttributeGroup;
import com.ocs.dynamo.domain.model.annotation.AttributeGroups;
import com.ocs.dynamo.domain.model.annotation.AttributeOrder;
import com.ocs.dynamo.domain.model.annotation.Cascade;
import com.ocs.dynamo.domain.model.annotation.CustomSetting;
import com.ocs.dynamo.domain.model.annotation.CustomType;
import com.ocs.dynamo.domain.model.annotation.GridAttributeOrder;
import com.ocs.dynamo.domain.model.annotation.Model;
import com.ocs.dynamo.domain.model.annotation.SearchAttributeOrder;
import com.ocs.dynamo.domain.model.annotation.SearchMode;
import com.ocs.dynamo.domain.model.impl.EntityModelFactoryImpl;
import com.ocs.dynamo.domain.model.validator.Email;
import com.ocs.dynamo.service.MessageService;
import com.ocs.dynamo.service.impl.MessageServiceImpl;
import com.ocs.dynamo.test.BaseMockitoTest;
import com.ocs.dynamo.utils.DateUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.test.util.ReflectionTestUtils;

public class EntityModelFactoryImplTest
extends BaseMockitoTest {
    private EntityModelFactoryImpl factory = new EntityModelFactoryImpl();
    private ResourceBundleMessageSource source = new ResourceBundleMessageSource();
    private MessageService messageService = new MessageServiceImpl();
    private Locale locale = new Locale("en");

    @BeforeEach
    public void setupEntityModelFactoryTest() throws NoSuchFieldException {
        System.setProperty("ocs.use.default.prompt.value", "true");
        this.source.setBasename("META-INF/entitymodel");
        ReflectionTestUtils.setField((Object)this.messageService, (String)"source", (Object)this.source);
        ReflectionTestUtils.setField((Object)this.factory, (String)"messageService", (Object)this.messageService);
    }

    @Test
    public void testDefaults() {
        EntityModel model = this.factory.getModel(Entity1.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)"Entity1", (Object)model.getDisplayName(this.locale));
        Assertions.assertEquals((Object)"Entity1s", (Object)model.getDisplayNamePlural(this.locale));
        Assertions.assertEquals((Object)"Entity1", (Object)model.getDescription(this.locale));
        Assertions.assertNull((Object)model.getDisplayProperty());
        AttributeModel nameModel = model.getAttributeModel("name");
        Assertions.assertNotNull((Object)nameModel);
        Assertions.assertNull((Object)nameModel.getDefaultValue());
        Assertions.assertEquals((Object)"Name", (Object)nameModel.getPrompt(this.locale));
        Assertions.assertEquals((Object)"Name", (Object)nameModel.getDisplayName(this.locale));
        Assertions.assertEquals((int)4, (int)nameModel.getOrder());
        Assertions.assertEquals(String.class, (Object)nameModel.getType());
        Assertions.assertNull((Object)nameModel.getDisplayFormat());
        Assertions.assertEquals((Object)AttributeType.BASIC, (Object)nameModel.getAttributeType());
        Assertions.assertFalse((boolean)nameModel.isRequired());
        Assertions.assertTrue((boolean)nameModel.isVisible());
        Assertions.assertEquals((int)55, (int)nameModel.getMaxLength());
        Assertions.assertEquals((Object)AttributeTextFieldMode.TEXTAREA, (Object)nameModel.getTextFieldMode());
        Assertions.assertFalse((boolean)nameModel.isTrimSpaces());
        Assertions.assertEquals((Object)"ross", (Object)nameModel.getCustomSetting("bob"));
        Assertions.assertEquals((Object)4, (Object)nameModel.getCustomSetting("bobInt"));
        Assertions.assertEquals((Object)true, (Object)nameModel.getCustomSetting("bobBool"));
        Assertions.assertTrue((boolean)nameModel.isSortable());
        Assertions.assertTrue((boolean)nameModel.isMainAttribute());
        Assertions.assertEquals((Object)EditableType.EDITABLE, (Object)nameModel.getEditableType());
        AttributeModel ageModel = model.getAttributeModel("age");
        Assertions.assertNull((Object)ageModel.getDefaultValue());
        Assertions.assertEquals((Object)"Age", (Object)ageModel.getDisplayName(this.locale));
        Assertions.assertEquals((int)0, (int)ageModel.getOrder());
        Assertions.assertEquals(Integer.class, (Object)ageModel.getType());
        Assertions.assertNull((Object)nameModel.getDisplayFormat());
        Assertions.assertEquals((Object)AttributeType.BASIC, (Object)ageModel.getAttributeType());
        Assertions.assertTrue((boolean)ageModel.isRequired());
        Assertions.assertTrue((boolean)ageModel.isThousandsGrouping());
        AttributeModel birthDateModel = model.getAttributeModel("birthDate");
        Assertions.assertNull((Object)birthDateModel.getDefaultValue());
        Assertions.assertEquals((Object)"Birth Date", (Object)birthDateModel.getDisplayName(this.locale));
        Assertions.assertEquals((int)1, (int)birthDateModel.getOrder());
        Assertions.assertEquals(LocalDate.class, (Object)birthDateModel.getType());
        Assertions.assertNotNull((Object)birthDateModel.getDisplayFormat());
        Assertions.assertEquals((Object)AttributeType.BASIC, (Object)birthDateModel.getAttributeType());
        Assertions.assertTrue((boolean)model.usesDefaultGroupOnly());
        AttributeModel weightModel = model.getAttributeModel("weight");
        Assertions.assertEquals((int)2, (int)weightModel.getPrecision());
        AttributeModel boolModel = model.getAttributeModel("bool");
        Assertions.assertEquals((Object)"Yes", (Object)boolModel.getTrueRepresentation(this.locale));
        Assertions.assertEquals((Object)"No", (Object)boolModel.getFalseRepresentation(this.locale));
        AttributeModel mailModel = model.getAttributeModel("email");
        Assertions.assertTrue((boolean)mailModel.isEmail());
        AttributeModel urlModel = model.getAttributeModel("url");
        Assertions.assertTrue((boolean)urlModel.isUrl());
        Assertions.assertEquals((int)7, (int)model.getAttributeModels().size());
    }

    @Test
    public void testPropertyOrder() {
        EntityModel model = this.factory.getModel(Entity2.class);
        Assertions.assertNotNull((Object)model);
        AttributeModel nameModel = model.getAttributeModel("name");
        Assertions.assertEquals((int)0, (int)nameModel.getOrder());
        Assertions.assertTrue((boolean)nameModel.isTrimSpaces());
        AttributeModel birthDateModel = model.getAttributeModel("birthDate");
        Assertions.assertEquals((int)1, (int)birthDateModel.getOrder());
        AttributeModel age = model.getAttributeModel("age");
        Assertions.assertEquals((int)2, (int)age.getOrder());
    }

    @Test
    public void testAttributeGroups() {
        EntityModel model = this.factory.getModel(Entity3.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((int)3, (int)model.getAttributeGroups().size());
        String group1 = (String)model.getAttributeGroups().get(0);
        Assertions.assertEquals((Object)"group1.key", (Object)group1);
        List models = model.getAttributeModelsForGroup(group1);
        Assertions.assertEquals((Object)"name", (Object)((AttributeModel)models.get(0)).getName());
        Assertions.assertEquals((Object)SearchMode.ALWAYS, (Object)((AttributeModel)models.get(0)).getSearchMode());
        String group2 = (String)model.getAttributeGroups().get(1);
        Assertions.assertEquals((Object)"group2.key", (Object)group2);
        List models2 = model.getAttributeModelsForGroup(group2);
        Assertions.assertEquals((Object)"age", (Object)((AttributeModel)models2.get(0)).getName());
        Assertions.assertTrue((boolean)((AttributeModel)models2.get(0)).isRequiredForSearching());
        Assertions.assertEquals((int)1, (int)model.getRequiredForSearchingAttributeModels().size());
        List models3 = model.getAttributeModelsForGroup("ocs.default.attribute.group");
        Assertions.assertEquals((Object)"advancedAge", (Object)((AttributeModel)models3.get(0)).getName());
        Assertions.assertTrue((boolean)model.isAttributeGroupVisible("ocs.default.attribute.group", true));
        Assertions.assertTrue((boolean)model.isAttributeGroupVisible("ocs.default.attribute.group", false));
        AttributeModel advancedAgeModel = model.getAttributeModel("advancedAge");
        Assertions.assertEquals((Object)SearchMode.ADVANCED, (Object)advancedAgeModel.getSearchMode());
    }

    @Test
    public void testAnnotationOverrides() {
        EntityModel model = this.factory.getModel(Entity3.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)"dis", (Object)model.getDisplayName(this.locale));
        Assertions.assertEquals((Object)"diss", (Object)model.getDisplayNamePlural(this.locale));
        Assertions.assertEquals((Object)"desc", (Object)model.getDescription(this.locale));
        Assertions.assertEquals((Object)"prop", (Object)model.getDisplayProperty());
        AttributeModel nameModel = model.getAttributeModel("name");
        Assertions.assertNotNull((Object)nameModel);
        Assertions.assertEquals((Object)"Bas", (Object)nameModel.getDefaultValue());
        Assertions.assertEquals((Object)"Naampje", (Object)nameModel.getDisplayName(this.locale));
        Assertions.assertEquals((Object)"Test", (Object)nameModel.getDescription(this.locale));
        Assertions.assertEquals((Object)"Prompt", (Object)nameModel.getPrompt(this.locale));
        Assertions.assertEquals((Object)"myStyle", (Object)nameModel.getStyles());
        Assertions.assertEquals(String.class, (Object)nameModel.getType());
        Assertions.assertNull((Object)nameModel.getDisplayFormat());
        Assertions.assertEquals((Object)AttributeType.BASIC, (Object)nameModel.getAttributeType());
        Assertions.assertFalse((boolean)nameModel.isSearchCaseSensitive());
        Assertions.assertFalse((boolean)nameModel.isSearchPrefixOnly());
        Assertions.assertFalse((boolean)nameModel.isSortable());
        Assertions.assertTrue((boolean)nameModel.isSearchable());
        Assertions.assertTrue((boolean)nameModel.isMainAttribute());
        Assertions.assertEquals((Object)EditableType.READ_ONLY, (Object)nameModel.getEditableType());
        AttributeModel ageModel = model.getAttributeModel("age");
        Assertions.assertNotNull((Object)ageModel);
        Assertions.assertTrue((boolean)ageModel.isSearchCaseSensitive());
        Assertions.assertTrue((boolean)ageModel.isSearchPrefixOnly());
        Assertions.assertFalse((boolean)ageModel.isThousandsGrouping());
        AttributeModel entityModel = model.getAttributeModel("entity2");
        Assertions.assertEquals((Object)AttributeType.MASTER, (Object)entityModel.getAttributeType());
        Assertions.assertTrue((boolean)entityModel.isComplexEditable());
        Assertions.assertTrue((boolean)entityModel.isNavigable());
        AttributeModel entityListModel = model.getAttributeModel("entityList");
        Assertions.assertEquals((Object)AttributeType.DETAIL, (Object)entityListModel.getAttributeType());
        AttributeModel birthDateModel = model.getAttributeModel("birthDate");
        Assertions.assertEquals((Object)"dd/MM/yyyy", (Object)birthDateModel.getDisplayFormat());
        AttributeModel derivedModel = model.getAttributeModel("derived");
        Assertions.assertNotNull((Object)derivedModel);
        Assertions.assertEquals((Object)"deri", (Object)derivedModel.getDisplayName(this.locale));
        AttributeModel weightModel = model.getAttributeModel("weight");
        Assertions.assertNotNull((Object)weightModel);
        Assertions.assertEquals((int)4, (int)weightModel.getPrecision());
        Assertions.assertTrue((boolean)weightModel.isCurrency());
    }

    @Test
    public void testReference() {
        EntityModel model = this.factory.getModel("Special", Entity6.class);
        Assertions.assertEquals((Object)"Special", (Object)model.getDisplayName(this.locale));
        Assertions.assertEquals((Object)"SpecialPlural", (Object)model.getDisplayNamePlural(this.locale));
    }

    @Test
    public void testMessageOverrides() {
        EntityModel model = this.factory.getModel(Entity6.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)"Override", (Object)model.getDisplayName(this.locale));
        Assertions.assertEquals((Object)"Overrides", (Object)model.getDisplayNamePlural(this.locale));
        Assertions.assertEquals((Object)"Description override", (Object)model.getDescription(this.locale));
        Assertions.assertEquals((Object)"Prop", (Object)model.getDisplayProperty());
        AttributeModel nameModel = model.getAttributeModel("name");
        Assertions.assertNotNull((Object)nameModel);
        Assertions.assertTrue((boolean)nameModel.isSearchCaseSensitive());
        Assertions.assertTrue((boolean)nameModel.isSearchPrefixOnly());
        Assertions.assertEquals((Object)"customValue", (Object)nameModel.getCustomSetting("custom"));
        Assertions.assertEquals((Object)4, (Object)nameModel.getCustomSetting("custom2"));
        Assertions.assertEquals((Object)true, (Object)nameModel.getCustomSetting("custom3"));
        Assertions.assertEquals((Object)"Override", (Object)nameModel.getDisplayName(this.locale));
        Assertions.assertEquals((Object)"Prompt override", (Object)nameModel.getPrompt(this.locale));
        Assertions.assertEquals((Object)"Style override", (Object)nameModel.getStyles());
        Assertions.assertEquals((Object)EditableType.CREATE_ONLY, (Object)nameModel.getEditableType());
        Assertions.assertEquals((Object)"Style override", (Object)nameModel.getStyles());
        Assertions.assertFalse((boolean)model.usesDefaultGroupOnly());
        String group1 = (String)model.getAttributeGroups().get(0);
        Assertions.assertEquals((Object)"group1", model.getAttributeGroups().get(0));
        String group2 = (String)model.getAttributeGroups().get(1);
        Assertions.assertEquals((Object)"group2", (Object)group2);
        Assertions.assertEquals((Object)"age", (Object)((AttributeModel)model.getAttributeModelsForGroup(group2).get(0)).getName());
        Assertions.assertEquals((Object)"birthDate", (Object)((AttributeModel)model.getAttributeModelsForGroup(group2).get(1)).getName());
        String group3 = (String)model.getAttributeGroups().get(2);
        Assertions.assertEquals((Object)"ocs.default.attribute.group", (Object)group3);
    }

    @Test
    public void testLob() {
        EntityModel model = this.factory.getModel(Entity5.class);
        AttributeModel attributeModel = model.getAttributeModel("logo");
        Assertions.assertEquals((Object)AttributeType.LOB, (Object)attributeModel.getAttributeType());
        Assertions.assertTrue((boolean)attributeModel.isImage());
        Assertions.assertTrue((boolean)attributeModel.getAllowedExtensions().contains("gif"));
        Assertions.assertTrue((boolean)attributeModel.getAllowedExtensions().contains("bmp"));
    }

    @Test
    public void testAssertTrueIgnored() {
        EntityModel model = this.factory.getModel(Entity5.class);
        AttributeModel attributeModel = model.getAttributeModel("someValidation");
        Assertions.assertNull((Object)attributeModel);
    }

    @Test
    public void testNestedEntityModel() {
        EntityModel child = this.factory.getModel(EntityChild.class);
        AttributeModel attributeModel = child.getAttributeModel("parent");
        Assertions.assertNotNull((Object)attributeModel);
        EntityModel parent = attributeModel.getNestedEntityModel();
        Assertions.assertNotNull((Object)parent);
        Assertions.assertEquals((Object)"EntityChild.parent", (Object)parent.getReference());
        parent = this.factory.getModel(EntityParent.class);
        attributeModel = parent.getAttributeModel("children");
        Assertions.assertNotNull((Object)attributeModel);
        child = attributeModel.getNestedEntityModel();
        Assertions.assertNotNull((Object)child);
        Assertions.assertEquals((Object)"EntityParent.children", (Object)child.getReference());
        attributeModel = parent.getAttributeModel("calculatedChildren");
        Assertions.assertNotNull((Object)attributeModel);
        EntityModel grandChild = attributeModel.getNestedEntityModel();
        Assertions.assertNotNull((Object)grandChild);
        Assertions.assertEquals((Object)"EntityParent.calculatedChildren", (Object)grandChild.getReference());
        Assertions.assertEquals(EntityGrandChild.class, (Object)attributeModel.getMemberType());
        Assertions.assertEquals((Object)"children", (Object)attributeModel.getReplacementSearchPath());
        Assertions.assertNotNull((Object)parent.getAttributeModelByActualSortPath("children"));
        Assertions.assertFalse((boolean)this.factory.hasModel("EntityChild.parent.children"));
        Assertions.assertFalse((boolean)this.factory.hasModel("EntityParent.children.parent"));
        EntityModel child2 = this.factory.getModel("EntityChild.parent.children", EntityChild.class);
        Assertions.assertNotNull((Object)child2);
        EntityModel childModel = this.factory.getModel("EntityChild.parent", EntityChild.class);
        Assertions.assertNotNull((Object)childModel);
        Assertions.assertFalse((boolean)childModel.getAttributeModel("name").isSearchable());
        EntityModel parentModel = this.factory.getModel(EntityParent.class);
        Assertions.assertTrue((boolean)parentModel.getAttributeModel("name").isSearchable());
        Assertions.assertEquals((Object)"name", (Object)parentModel.getAttributeModel("name").getPath());
        Assertions.assertEquals((Object)"parent.name", (Object)childModel.getAttributeModel("name").getPath());
    }

    @Test
    public void testId() {
        EntityModel model = this.factory.getModel(EntityParent.class);
        AttributeModel attributeModel = model.getIdAttributeModel();
        Assertions.assertNotNull((Object)attributeModel);
    }

    @Test
    public void testGetAttributeModelsForType() {
        EntityModel model = this.factory.getModel(EntityChild.class);
        List models = model.getAttributeModelsForType(AttributeType.MASTER, EntityParent.class);
        Assertions.assertNotNull((Object)models);
        Assertions.assertEquals((int)2, (int)models.size());
        Assertions.assertEquals((Object)"parent", (Object)((AttributeModel)models.get(0)).getName());
        model = this.factory.getModel(EntityChild.class);
        models = model.getAttributeModelsForType(AttributeType.MASTER, null);
        Assertions.assertNotNull((Object)models);
        Assertions.assertEquals((int)2, (int)models.size());
        Assertions.assertEquals((Object)"parent", (Object)((AttributeModel)models.get(0)).getName());
        EntityModel pmodel = this.factory.getModel(EntityParent.class);
        models = pmodel.getAttributeModelsForType(null, EntityChild.class);
        Assertions.assertNotNull((Object)models);
        Assertions.assertEquals((int)1, (int)models.size());
        Assertions.assertEquals((Object)"children", (Object)((AttributeModel)models.get(0)).getName());
    }

    @Test
    public void testNestedAttributes() {
        EntityModel parentModel = this.factory.getModel(EntityParent.class);
        AttributeModel pm = parentModel.getAttributeModel("name");
        Assertions.assertNotNull((Object)pm);
        Assertions.assertEquals((Object)"name", (Object)pm.getName());
        Assertions.assertTrue((boolean)pm.isVisibleInGrid());
        EntityModel model = this.factory.getModel(EntityChild.class);
        AttributeModel am = model.getAttributeModel("parent.name");
        Assertions.assertNotNull((Object)am);
        Assertions.assertEquals((Object)"name", (Object)am.getName());
        Assertions.assertEquals(EntityParent.class, (Object)am.getEntityModel().getEntityClass());
        Assertions.assertFalse((boolean)am.isVisibleInGrid());
    }

    @Test
    public void testSortOrder() {
        EntityModel model = this.factory.getModel(EntityParent.class);
        Assertions.assertNotNull((Object)model.getSortOrder());
        Assertions.assertEquals((int)2, (int)model.getSortOrder().size());
        AttributeModel amName = model.getAttributeModel("name");
        AttributeModel amId = model.getAttributeModel("id");
        Assertions.assertEquals((Object)false, model.getSortOrder().get(amName));
        Assertions.assertEquals((Object)true, model.getSortOrder().get(amId));
        EntityModel semodel = this.factory.getModel(EntitySortError.class);
        Assertions.assertNotNull((Object)semodel.getSortOrder());
        Assertions.assertEquals((int)1, (int)semodel.getSortOrder().size());
        amName = semodel.getAttributeModel("code");
        Assertions.assertEquals((Object)true, semodel.getSortOrder().get(amName));
    }

    @Test
    public void testEmbedded() {
        EntityModel model = this.factory.getModel(EmbeddedParent.class);
        Assertions.assertNotNull((Object)model.getAttributeModel("name"));
        Assertions.assertEquals((Object)AttributeType.BASIC, (Object)model.getAttributeModel("name").getAttributeType());
        Assertions.assertNull((Object)model.getAttributeModel("child"));
        AttributeModel m = model.getAttributeModel("child.embedded2");
        Assertions.assertNotNull((Object)m);
        Assertions.assertTrue((boolean)m.isSearchable());
        Assertions.assertFalse((boolean)m.isVisible());
        Assertions.assertNull((Object)model.getAttributeModel("child.grandChild"));
        AttributeModel m2 = model.getAttributeModel("child.grandChild.sometAttribute");
        Assertions.assertNotNull((Object)m2);
    }

    @Test
    public void testSelectMode() {
        EntityModel model = this.factory.getModel(Entity7.class);
        AttributeModel am = model.getAttributeModel("entity6");
        Assertions.assertEquals((Object)AttributeSelectMode.LOOKUP, (Object)am.getSelectMode());
        Assertions.assertEquals((Object)AttributeSelectMode.LOOKUP, (Object)am.getSearchSelectMode());
        Assertions.assertEquals((Object)AttributeSelectMode.LOOKUP, (Object)am.getGridSelectMode());
        AttributeModel am2 = model.getAttributeModel("entity5");
        Assertions.assertEquals((Object)AttributeSelectMode.COMBO, (Object)am2.getSelectMode());
        Assertions.assertEquals((Object)AttributeSelectMode.LOOKUP, (Object)am2.getSearchSelectMode());
        Assertions.assertEquals((Object)AttributeSelectMode.COMBO, (Object)am2.getGridSelectMode());
        AttributeModel am3 = model.getAttributeModel("entity52");
        Assertions.assertEquals((Object)AttributeSelectMode.COMBO, (Object)am3.getSelectMode());
        Assertions.assertEquals((Object)AttributeSelectMode.TOKEN, (Object)am3.getSearchSelectMode());
        Assertions.assertEquals((Object)AttributeSelectMode.LIST, (Object)am3.getGridSelectMode());
    }

    @Test
    public void testDateType() {
        EntityModel model = this.factory.getModel(Entity8.class);
        AttributeModel am = model.getAttributeModel("date1");
        Assertions.assertEquals((Object)AttributeDateType.DATE, (Object)am.getDateType());
        Assertions.assertEquals((Object)"dd-MM-yyyy", (Object)am.getDisplayFormat());
        am = model.getAttributeModel("date2");
        Assertions.assertEquals((Object)AttributeDateType.TIMESTAMP, (Object)am.getDateType());
        Assertions.assertEquals((Object)"dd-MM-yyyy HH:mm:ss", (Object)am.getDisplayFormat());
        am = model.getAttributeModel("date3");
        Assertions.assertEquals((Object)AttributeDateType.TIME, (Object)am.getDateType());
        Assertions.assertEquals((Object)"HH:mm:ss", (Object)am.getDisplayFormat());
        am = model.getAttributeModel("date4");
        Assertions.assertEquals((Object)AttributeDateType.TIME, (Object)am.getDateType());
        Assertions.assertEquals((Object)"ss:mm:HH", (Object)am.getDisplayFormat());
        am = model.getAttributeModel("date5");
        Assertions.assertEquals((Object)AttributeDateType.DATE, (Object)am.getDateType());
        Assertions.assertEquals((Object)"yyyy-dd-MM ss:mm:HH", (Object)am.getDisplayFormat());
        am = model.getAttributeModel("date6");
        Assertions.assertEquals((Object)AttributeDateType.DATE, (Object)am.getDateType());
        Assertions.assertEquals((Object)"dd-MM-yyyy", (Object)am.getDisplayFormat());
    }

    @Test
    public void testElementCollection() {
        EntityModel model = this.factory.getModel(Entity9.class);
        AttributeModel am = model.getAttributeModel("elements");
        Assertions.assertEquals((Object)AttributeType.ELEMENT_COLLECTION, (Object)am.getAttributeType());
        Assertions.assertEquals((Object)"element_table", (Object)am.getCollectionTableName());
        Assertions.assertEquals((Object)"element", (Object)am.getCollectionTableFieldName());
        AttributeModel am2 = model.getAttributeModel("longElements");
        Assertions.assertEquals((Object)AttributeType.ELEMENT_COLLECTION, (Object)am2.getAttributeType());
        Assertions.assertEquals((long)100L, (long)am2.getMinValue());
        Assertions.assertEquals((long)500L, (long)am2.getMaxValue());
    }

    @Test
    public void testGroupTogetherWith() {
        EntityModel model = this.factory.getModel(Entity10.class);
        AttributeModel am = model.getAttributeModel("attribute1");
        Assertions.assertEquals((int)1, (int)am.getGroupTogetherWith().size());
        Assertions.assertEquals((Object)"attribute2", am.getGroupTogetherWith().get(0));
    }

    @Test
    public void testGroupTogetherWithWrongOrder() {
        EntityModel model = this.factory.getModel(Entity11.class);
        AttributeModel am = model.getAttributeModel("attribute2");
        Assertions.assertEquals((int)1, (int)am.getGroupTogetherWith().size());
        Assertions.assertEquals((Object)"attribute1", am.getGroupTogetherWith().get(0));
        AttributeModel am1 = model.getAttributeModel("attribute1");
        Assertions.assertTrue((boolean)am1.isAlreadyGrouped());
    }

    @Test
    public void testCascade() {
        EntityModel model = this.factory.getModel(Entity12.class);
        AttributeModel am = model.getAttributeModel("attribute1");
        Assertions.assertTrue((boolean)am.getCascadeAttributes().contains("attribute2"));
        Assertions.assertEquals((Object)"somePath", (Object)am.getCascadeFilterPath("attribute2"));
        Assertions.assertEquals((Object)CascadeMode.BOTH, (Object)am.getCascadeMode("attribute2"));
        Assertions.assertEquals((int)1, (int)model.getCascadeAttributeModels().size());
        Assertions.assertEquals((Object)"attribute1", (Object)((AttributeModel)model.getCascadeAttributeModels().iterator().next()).getPath());
    }

    @Test
    public void testCascadeMessageBundle() {
        EntityModel model = this.factory.getModel(Entity13.class);
        AttributeModel am = model.getAttributeModel("attribute1");
        Assertions.assertTrue((boolean)am.getCascadeAttributes().contains("attribute2"));
        Assertions.assertEquals((Object)"somePath", (Object)am.getCascadeFilterPath("attribute2"));
        Assertions.assertEquals((Object)CascadeMode.EDIT, (Object)am.getCascadeMode("attribute2"));
    }

    @Test
    public void testJava8DateTypes() {
        EntityModel model = this.factory.getModel(Entity14.class);
        AttributeModel am1 = model.getAttributeModel("localDate");
        Assertions.assertNotNull((Object)am1);
        Assertions.assertEquals((Object)"dd/MM/yyyy", (Object)am1.getDisplayFormat());
        Assertions.assertEquals((Object)AttributeDateType.DATE, (Object)am1.getDateType());
        Assertions.assertEquals((Object)DateUtils.createLocalDate((String)"01011980"), (Object)am1.getDefaultValue());
        AttributeModel am2 = model.getAttributeModel("localTime");
        Assertions.assertNotNull((Object)am2);
        Assertions.assertEquals((Object)"HH-mm-ss", (Object)am2.getDisplayFormat());
        Assertions.assertEquals((Object)AttributeDateType.TIME, (Object)am2.getDateType());
        Assertions.assertEquals((Object)DateUtils.createLocalTime((String)"121314"), (Object)am2.getDefaultValue());
        AttributeModel am3 = model.getAttributeModel("localDateTime");
        Assertions.assertNotNull((Object)am3);
        Assertions.assertEquals((Object)"dd/MM/yyyy HH-mm-ss", (Object)am3.getDisplayFormat());
        Assertions.assertEquals((Object)AttributeDateType.TIMESTAMP, (Object)am3.getDateType());
        Assertions.assertEquals((Object)DateUtils.createLocalDateTime((String)"01011980 121314"), (Object)am3.getDefaultValue());
        AttributeModel am4 = model.getAttributeModel("zonedDateTime");
        Assertions.assertNotNull((Object)am4);
        Assertions.assertEquals((Object)"dd-MM-yyyy HH:mm:ssZ", (Object)am4.getDisplayFormat());
        Assertions.assertEquals((Object)AttributeDateType.TIMESTAMP, (Object)am4.getDateType());
        Assertions.assertEquals((Object)DateUtils.createZonedDateTime((String)"01-01-2017 12:00:00+0100"), (Object)am4.getDefaultValue());
    }

    @Test
    public void testAttributeOrders() {
        EntityModel model = this.factory.getModel(SearchOrderEntity.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((int)3, (int)model.getAttributeModels().size());
        List attributeModels = model.getAttributeModels();
        Assertions.assertEquals((Object)"field1", (Object)((AttributeModel)attributeModels.get(0)).getName());
        Assertions.assertEquals((Object)"field2", (Object)((AttributeModel)attributeModels.get(1)).getName());
        Assertions.assertEquals((Object)"field3", (Object)((AttributeModel)attributeModels.get(2)).getName());
        attributeModels = model.getAttributeModelsSortedForGrid();
        Assertions.assertEquals((Object)"field2", (Object)((AttributeModel)attributeModels.get(0)).getName());
        Assertions.assertEquals((Object)"field1", (Object)((AttributeModel)attributeModels.get(1)).getName());
        Assertions.assertEquals((Object)"field3", (Object)((AttributeModel)attributeModels.get(2)).getName());
        attributeModels = model.getAttributeModelsSortedForSearch();
        Assertions.assertEquals((Object)"field3", (Object)((AttributeModel)attributeModels.get(0)).getName());
        Assertions.assertEquals((Object)"field2", (Object)((AttributeModel)attributeModels.get(1)).getName());
        Assertions.assertEquals((Object)"field1", (Object)((AttributeModel)attributeModels.get(2)).getName());
    }

    @Test
    public void testAttributeOrdersMessageBundle() {
        EntityModel model = this.factory.getModel(SearchOrderEntityMessage.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((int)3, (int)model.getAttributeModels().size());
        List attributeModels = model.getAttributeModels();
        Assertions.assertEquals((Object)"field1", (Object)((AttributeModel)attributeModels.get(0)).getName());
        Assertions.assertEquals((Object)"field2", (Object)((AttributeModel)attributeModels.get(1)).getName());
        Assertions.assertEquals((Object)"field3", (Object)((AttributeModel)attributeModels.get(2)).getName());
        attributeModels = model.getAttributeModelsSortedForGrid();
        Assertions.assertEquals((Object)"field3", (Object)((AttributeModel)attributeModels.get(0)).getName());
        Assertions.assertEquals((Object)"field2", (Object)((AttributeModel)attributeModels.get(1)).getName());
        Assertions.assertEquals((Object)"field1", (Object)((AttributeModel)attributeModels.get(2)).getName());
        attributeModels = model.getAttributeModelsSortedForSearch();
        Assertions.assertEquals((Object)"field2", (Object)((AttributeModel)attributeModels.get(0)).getName());
        Assertions.assertEquals((Object)"field3", (Object)((AttributeModel)attributeModels.get(1)).getName());
        Assertions.assertEquals((Object)"field1", (Object)((AttributeModel)attributeModels.get(2)).getName());
    }

    @AttributeOrder(attributeNames={"field1", "field2", "field3"})
    public class SearchOrderEntityMessage {
        private String field1;
        private String field2;
        private String field3;

        public String getField1() {
            return this.field1;
        }

        public void setField1(String field1) {
            this.field1 = field1;
        }

        public String getField2() {
            return this.field2;
        }

        public void setField2(String field2) {
            this.field2 = field2;
        }

        public String getField3() {
            return this.field3;
        }

        public void setField3(String field3) {
            this.field3 = field3;
        }
    }

    @AttributeOrder(attributeNames={"field1", "field2", "field3"})
    @GridAttributeOrder(attributeNames={"field2", "field1", "field3"})
    @SearchAttributeOrder(attributeNames={"field3", "field2", "field1"})
    public class SearchOrderEntity {
        private String field1;
        private String field2;
        private String field3;

        public String getField1() {
            return this.field1;
        }

        public void setField1(String field1) {
            this.field1 = field1;
        }

        public String getField2() {
            return this.field2;
        }

        public void setField2(String field2) {
            this.field2 = field2;
        }

        public String getField3() {
            return this.field3;
        }

        public void setField3(String field3) {
            this.field3 = field3;
        }
    }

    @Embeddable
    public class EmbeddedGrandChild {
        private String sometAttribute;

        public String getSometAttribute() {
            return this.sometAttribute;
        }

        public void setSometAttribute(String sometAttribute) {
            this.sometAttribute = sometAttribute;
        }
    }

    @Embeddable
    public class EmbeddedChild {
        @Attribute(visible=VisibilityType.HIDE)
        private String embedded1;
        @Attribute(searchable=SearchMode.ALWAYS)
        private String embedded2;
        @Embedded
        private EmbeddedGrandChild grandChild;

        public String getEmbedded1() {
            return this.embedded1;
        }

        public void setEmbedded1(String embedded1) {
            this.embedded1 = embedded1;
        }

        public String getEmbedded2() {
            return this.embedded2;
        }

        public void setEmbedded2(String embedded2) {
            this.embedded2 = embedded2;
        }

        public EmbeddedGrandChild getGrandChild() {
            return this.grandChild;
        }

        public void setGrandChild(EmbeddedGrandChild grandChild) {
            this.grandChild = grandChild;
        }
    }

    @AttributeOrder(attributeNames={"child.embedded1", "child.embedded2", "name"})
    public class EmbeddedParent {
        private String name;
        @Embedded
        private EmbeddedChild child;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public EmbeddedChild getChild() {
            return this.child;
        }

        public void setChild(EmbeddedChild child) {
            this.child = child;
        }
    }

    @Model(sortOrder="code unknown, unknown asc")
    public class EntitySortError {
        private String code;
        private String name;

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public class EntityGrandChild
    extends EntityChild {
    }

    @Model(nestingDepth=1)
    public class EntityChild {
        @Id
        private int id;
        private String name;
        private EntityParent parent;
        private EntityParent parent2;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public EntityParent getParent() {
            return this.parent;
        }

        public void setParent(EntityParent parent) {
            this.parent = parent;
        }

        public EntityParent getParent2() {
            return this.parent2;
        }

        public void setParent2(EntityParent parent2) {
            this.parent2 = parent2;
        }
    }

    @Model(sortOrder="name desc, id asc")
    public class EntityParent {
        @Id
        private int id;
        @Attribute(searchable=SearchMode.ALWAYS)
        private String name;
        @OneToMany
        private List<EntityChild> children;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<EntityChild> getChildren() {
            return this.children;
        }

        public void setChildren(List<EntityChild> children) {
            this.children = children;
        }

        @Attribute(memberType=EntityGrandChild.class, replacementSearchPath="children")
        public List<EntityGrandChild> getCalculatedChildren() {
            return null;
        }

        public void setCalculatedChildren(List<EntityGrandChild> children) {
        }
    }

    public class Entity5 {
        @Lob
        @Basic(fetch=FetchType.LAZY)
        @Attribute(image=true, allowedExtensions={"gif", "bmp"})
        private byte[] logo;

        public byte[] getLogo() {
            return this.logo;
        }

        public void setLogo(byte[] logo) {
            this.logo = logo;
        }

        @AssertTrue
        public boolean isSomeValidation() {
            return true;
        }
    }

    public class Entity4 {
    }

    public class Entity14 {
        @Attribute(displayFormat="dd/MM/yyyy", defaultValue="01/01/1980")
        private LocalDate localDate;
        @Attribute(displayFormat="dd/MM/yyyy HH-mm-ss", defaultValue="01/01/1980 12-13-14")
        private LocalDateTime localDateTime;
        @Attribute(displayFormat="HH-mm-ss", defaultValue="12-13-14")
        private LocalTime localTime;
        @Attribute(defaultValue="01-01-2017 12:00:00+0100")
        private ZonedDateTime zonedDateTime;

        public LocalDate getLocalDate() {
            return this.localDate;
        }

        public void setLocalDate(LocalDate localDate) {
            this.localDate = localDate;
        }

        public LocalDateTime getLocalDateTime() {
            return this.localDateTime;
        }

        public void setLocalDateTime(LocalDateTime localDateTime) {
            this.localDateTime = localDateTime;
        }

        public LocalTime getLocalTime() {
            return this.localTime;
        }

        public void setLocalTime(LocalTime localTime) {
            this.localTime = localTime;
        }

        public ZonedDateTime getZonedDateTime() {
            return this.zonedDateTime;
        }

        public void setZonedDateTime(ZonedDateTime zonedDateTime) {
            this.zonedDateTime = zonedDateTime;
        }
    }

    public class Entity13 {
        private String attribute1;
        private String attribute2;

        public String getAttribute1() {
            return this.attribute1;
        }

        public void setAttribute1(String attribute1) {
            this.attribute1 = attribute1;
        }

        public String getAttribute2() {
            return this.attribute2;
        }

        public void setAttribute2(String attribute2) {
            this.attribute2 = attribute2;
        }
    }

    public class Entity12 {
        @Attribute(cascade={@Cascade(cascadeTo="attribute2", filterPath="somePath")})
        private String attribute1;
        private String attribute2;

        public String getAttribute1() {
            return this.attribute1;
        }

        public void setAttribute1(String attribute1) {
            this.attribute1 = attribute1;
        }

        public String getAttribute2() {
            return this.attribute2;
        }

        public void setAttribute2(String attribute2) {
            this.attribute2 = attribute2;
        }
    }

    @AttributeOrder(attributeNames={"attribute1", "attribute2"})
    public class Entity11 {
        private String attribute1;
        @Attribute(groupTogetherWith={"attribute1"})
        private String attribute2;

        public String getAttribute1() {
            return this.attribute1;
        }

        public void setAttribute1(String attribute1) {
            this.attribute1 = attribute1;
        }

        public String getAttribute2() {
            return this.attribute2;
        }

        public void setAttribute2(String attribute2) {
            this.attribute2 = attribute2;
        }
    }

    public class Entity10 {
        @Attribute(groupTogetherWith={"attribute2"})
        private String attribute1;
        @Transient
        private String attribute2;

        public String getAttribute1() {
            return this.attribute1;
        }

        public void setAttribute1(String attribute1) {
            this.attribute1 = attribute1;
        }

        public String getAttribute2() {
            return this.attribute2;
        }

        public void setAttribute2(String attribute2) {
            this.attribute2 = attribute2;
        }
    }

    public class Entity9 {
        @ElementCollection
        @CollectionTable(name="element_table")
        @Column(name="element")
        private Set<String> elements = new HashSet<String>();
        @ElementCollection
        @CollectionTable(name="long_element_table")
        @Column(name="element")
        @Attribute(minValue=100L, maxValue=500L)
        private Set<Long> longElements = new HashSet<Long>();

        public Set<String> getElements() {
            return this.elements;
        }

        public void setElements(Set<String> elements) {
            this.elements = elements;
        }

        public Set<Long> getLongElements() {
            return this.longElements;
        }

        public void setLongElements(Set<Long> longElements) {
            this.longElements = longElements;
        }
    }

    public class Entity8 {
        private LocalDate date1;
        private LocalDateTime date2;
        @Attribute(dateType=AttributeDateType.TIME)
        private LocalTime date3;
        @Attribute(dateType=AttributeDateType.TIME, displayFormat="ss:mm:HH")
        private LocalTime date4;
        @Attribute(displayFormat="yyyy-dd-MM ss:mm:HH")
        private LocalDate date5;
        @Attribute
        private LocalDate date6;

        public LocalDate getDate1() {
            return this.date1;
        }

        public void setDate1(LocalDate date1) {
            this.date1 = date1;
        }

        public LocalDateTime getDate2() {
            return this.date2;
        }

        public void setDate2(LocalDateTime date2) {
            this.date2 = date2;
        }

        public LocalTime getDate3() {
            return this.date3;
        }

        public void setDate3(LocalTime date3) {
            this.date3 = date3;
        }

        public LocalTime getDate4() {
            return this.date4;
        }

        public void setDate4(LocalTime date4) {
            this.date4 = date4;
        }

        public LocalDate getDate5() {
            return this.date5;
        }

        public void setDate5(LocalDate date5) {
            this.date5 = date5;
        }

        public LocalDate getDate6() {
            return this.date6;
        }

        public void setDate6(LocalDate date6) {
            this.date6 = date6;
        }
    }

    public class Entity7 {
        @Attribute(selectMode=AttributeSelectMode.LOOKUP)
        private Entity6 entity6;
        @Attribute(multipleSearch=true)
        private Entity5 entity5;
        @Attribute(multipleSearch=true, searchSelectMode=AttributeSelectMode.TOKEN, gridSelectMode=AttributeSelectMode.LIST)
        private Entity5 entity52;

        public Entity6 getEntity6() {
            return this.entity6;
        }

        public void setEntity6(Entity6 entity6) {
            this.entity6 = entity6;
        }

        public Entity5 getEntity5() {
            return this.entity5;
        }

        public void setEntity5(Entity5 entity5) {
            this.entity5 = entity5;
        }

        public Entity5 getEntity52() {
            return this.entity52;
        }

        public void setEntity52(Entity5 entity52) {
            this.entity52 = entity52;
        }
    }

    public class Entity6 {
        private String name;
        private Integer age;
        private LocalDate birthDate;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getAge() {
            return this.age;
        }

        public void setAge(Integer age) {
            this.age = age;
        }

        public LocalDate getBirthDate() {
            return this.birthDate;
        }

        public void setBirthDate(LocalDate birthDate) {
            this.birthDate = birthDate;
        }
    }

    @Model(description="desc", displayName="dis", displayNamePlural="diss", displayProperty="prop", sortOrder="name asc")
    @AttributeGroups(value={@AttributeGroup(messageKey="group1.key", attributeNames={"name"}), @AttributeGroup(messageKey="group2.key", attributeNames={"age"})})
    public class Entity3 {
        @Attribute(defaultValue="Bas", description="Test", displayName="Naampje", editable=EditableType.READ_ONLY, prompt="Prompt", searchable=SearchMode.ALWAYS, main=true, sortable=false, styles="myStyle")
        private String name;
        @Attribute(searchCaseSensitive=true, searchPrefixOnly=true, thousandsGrouping=false, requiredForSearching=true, searchable=SearchMode.ALWAYS)
        private Integer age;
        @Attribute(displayFormat="dd/MM/yyyy")
        private LocalDate birthDate;
        @OneToOne
        @Attribute(complexEditable=true, navigable=true)
        private Entity2 entity2;
        @OneToMany
        private List<Entity4> entityList;
        @Attribute(precision=4, currency=true)
        private BigDecimal weight;
        @Attribute(searchable=SearchMode.ADVANCED)
        private Integer advancedAge;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getAge() {
            return this.age;
        }

        public void setAge(Integer age) {
            this.age = age;
        }

        public LocalDate getBirthDate() {
            return this.birthDate;
        }

        public void setBirthDate(LocalDate birthDate) {
            this.birthDate = birthDate;
        }

        public Entity2 getEntity2() {
            return this.entity2;
        }

        public void setEntity2(Entity2 entity2) {
            this.entity2 = entity2;
        }

        public List<Entity4> getEntityList() {
            return this.entityList;
        }

        public void setEntityList(List<Entity4> entityList) {
            this.entityList = entityList;
        }

        @Attribute(displayName="deri")
        public String getDerived() {
            return "test";
        }

        public BigDecimal getWeight() {
            return this.weight;
        }

        public void setWeight(BigDecimal weight) {
            this.weight = weight;
        }

        public Integer getAdvancedAge() {
            return this.advancedAge;
        }

        public void setAdvancedAge(Integer advancedAge) {
            this.advancedAge = advancedAge;
        }
    }

    @AttributeOrder(attributeNames={"name", "birthDate"})
    public class Entity2 {
        @Attribute(trimSpaces=TrimType.TRIM)
        private String name;
        private Integer age;
        private LocalDate birthDate;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getAge() {
            return this.age;
        }

        public void setAge(Integer age) {
            this.age = age;
        }

        public LocalDate getBirthDate() {
            return this.birthDate;
        }

        public void setBirthDate(LocalDate birthDate) {
            this.birthDate = birthDate;
        }
    }

    public class Entity1 {
        @Size(max=55)
        @Attribute(main=true, textFieldMode=AttributeTextFieldMode.TEXTAREA, custom={@CustomSetting(name="bob", value="ross"), @CustomSetting(name="bobInt", value="4", type=CustomType.INT), @CustomSetting(name="bobBool", value="true", type=CustomType.BOOLEAN)})
        private @Size(max=55) String name;
        @NotNull
        private Integer age;
        private BigDecimal weight;
        private LocalDate birthDate;
        @Attribute(trueRepresentation="Yes", falseRepresentation="No")
        private Boolean bool;
        @Email
        private String email;
        @Attribute(url=true)
        private String url;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getAge() {
            return this.age;
        }

        public void setAge(Integer age) {
            this.age = age;
        }

        public LocalDate getBirthDate() {
            return this.birthDate;
        }

        public void setBirthDate(LocalDate birthDate) {
            this.birthDate = birthDate;
        }

        public BigDecimal getWeight() {
            return this.weight;
        }

        public void setWeight(BigDecimal weight) {
            this.weight = weight;
        }

        public Boolean getBool() {
            return this.bool;
        }

        public void setBool(Boolean bool) {
            this.bool = bool;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }
}

