/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.domain.model.validator;

import com.ocs.dynamo.domain.model.validator.URLValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class URLValidatorTest {
    private URLValidator validator = new URLValidator();

    @Test
    public void testNull() {
        Assertions.assertTrue((boolean)this.validator.isValid(null, null));
    }

    @Test
    public void testValid() {
        Assertions.assertTrue((boolean)this.validator.isValid("http://www.google.nl", null));
        Assertions.assertTrue((boolean)this.validator.isValid("www.google.nl", null));
        Assertions.assertTrue((boolean)this.validator.isValid("mijn.site.nl", null));
        Assertions.assertFalse((boolean)this.validator.isValid("mijn.site", null));
    }

    @Test
    public void testValid_basic() {
        Assertions.assertFalse((boolean)this.validator.isValid("nowwwnonothing", null));
        Assertions.assertFalse((boolean)this.validator.isValid("no-www-no-nothing", null));
        Assertions.assertFalse((boolean)this.validator.isValid("no/www/no/nothing", null));
        Assertions.assertFalse((boolean)this.validator.isValid("no$www$no$nothing", null));
        Assertions.assertFalse((boolean)this.validator.isValid("no@www@no@nothing", null));
        Assertions.assertFalse((boolean)this.validator.isValid("no www no nothing", null));
    }

    @Test
    public void testValid_exoticCharacters() {
        Assertions.assertTrue((boolean)this.validator.isValid("http://www.goqs\u00f9df\u00f9^\u00f9\u00ea   \u00f9^z\u00f9'^^\"'t\"'^m\u00a7\"'ogle.nl", null));
    }
}

