/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.filter;

import com.google.common.collect.Lists;
import com.ocs.dynamo.domain.TestEntity;
import com.ocs.dynamo.domain.TestEntity2;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.domain.model.impl.EntityModelFactoryImpl;
import com.ocs.dynamo.filter.And;
import com.ocs.dynamo.filter.Between;
import com.ocs.dynamo.filter.Compare;
import com.ocs.dynamo.filter.Contains;
import com.ocs.dynamo.filter.DynamoFilterUtil;
import com.ocs.dynamo.filter.Filter;
import com.ocs.dynamo.filter.In;
import com.ocs.dynamo.filter.Like;
import com.ocs.dynamo.filter.Not;
import com.ocs.dynamo.filter.Or;
import com.ocs.dynamo.filter.PropertyFilter;
import java.util.Collection;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DynamoFilterUtilTest {
    private EntityModelFactoryImpl emf = new EntityModelFactoryImpl();

    @Test
    public void testReplaceFilter() {
        And and = new And(new Filter[]{new Compare.Equal("a", (Object)12), new Compare.Equal("b", (Object)24)});
        DynamoFilterUtil.replaceFilter((Filter)and, (Filter)new Compare.Equal("c", (Object)13), (String)"b", (boolean)false);
        Filter f = (Filter)and.getFilters().get(1);
        Assertions.assertTrue((boolean)(f instanceof Compare.Equal));
        Assertions.assertEquals((Object)"c", (Object)((Compare.Equal)f).getPropertyId());
    }

    @Test
    public void testReplaceFilterAll() {
        And and = new And(new Filter[]{new Compare.Equal("a", (Object)12), new Compare.Equal("a", (Object)12)});
        DynamoFilterUtil.replaceFilter((Filter)and, (Filter)new Compare.Equal("c", (Object)13), (String)"a", (boolean)false);
        Filter f0 = (Filter)and.getFilters().get(0);
        Assertions.assertTrue((boolean)(f0 instanceof Compare.Equal));
        Assertions.assertEquals((Object)"c", (Object)((Compare.Equal)f0).getPropertyId());
        Filter f1 = (Filter)and.getFilters().get(1);
        Assertions.assertTrue((boolean)(f1 instanceof Compare.Equal));
        Assertions.assertEquals((Object)"c", (Object)((Compare.Equal)f1).getPropertyId());
    }

    @Test
    public void testReplaceFilterFirstOnly() {
        And and = new And(new Filter[]{new Compare.Equal("a", (Object)12), new Compare.Equal("a", (Object)12)});
        DynamoFilterUtil.replaceFilter((Filter)and, (Filter)new Compare.Equal("c", (Object)13), (String)"a", (boolean)true);
        Filter f0 = (Filter)and.getFilters().get(0);
        Assertions.assertTrue((boolean)(f0 instanceof Compare.Equal));
        Assertions.assertEquals((Object)"c", (Object)((Compare.Equal)f0).getPropertyId());
        Filter f1 = (Filter)and.getFilters().get(1);
        Assertions.assertTrue((boolean)(f1 instanceof Compare.Equal));
        Assertions.assertEquals((Object)"a", (Object)((Compare.Equal)f1).getPropertyId());
    }

    @Test
    public void testReplaceNot() {
        Not not = new Not((Filter)new Compare.Equal("a", (Object)12));
        DynamoFilterUtil.replaceFilter((Filter)not, (Filter)new Compare.Equal("d", (Object)13), (String)"a", (boolean)false);
        Filter f = not.getFilter();
        Assertions.assertTrue((boolean)(f instanceof Compare.Equal));
        Assertions.assertEquals((Object)"d", (Object)((Compare.Equal)f).getPropertyId());
    }

    @Test
    public void testReplaceComplex() {
        Not not = new Not((Filter)new Compare.Equal("a", (Object)12));
        And and = new And(new Filter[]{new Compare.Equal("b", (Object)12), new Compare.Equal("c", (Object)24)});
        Or or = new Or(new Filter[]{not, and});
        DynamoFilterUtil.replaceFilter((Filter)or, (Filter)new And(new Filter[]{new Compare.Greater("f", (Object)4), new Compare.Less("g", (Object)7)}), (String)"b", (boolean)false);
        Filter f = (Filter)or.getFilters().get(1);
        Assertions.assertTrue((boolean)(f instanceof And));
        And inner = (And)((And)f).getFilters().get(0);
        Assertions.assertEquals((Object)"f", (Object)((PropertyFilter)inner.getFilters().get(0)).getPropertyId());
    }

    @Test
    public void testExtractFilter_Like2() {
        Like like = new Like("prop1", "someString");
        Filter f1 = DynamoFilterUtil.extractFilter((Filter)like, (String)"prop1");
        Assertions.assertNotNull((Object)f1);
        Filter f2 = DynamoFilterUtil.extractFilter((Filter)like, (String)"prop2");
        Assertions.assertNull((Object)f2);
    }

    @Test
    public void testExtractFilter_Between() {
        Between between = new Between("prop1", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200));
        Filter f1 = DynamoFilterUtil.extractFilter((Filter)between, (String)"prop1");
        Assertions.assertNotNull((Object)f1);
        Filter f2 = DynamoFilterUtil.extractFilter((Filter)between, (String)"prop2");
        Assertions.assertNull((Object)f2);
    }

    @Test
    public void testExtractFilter_Complex2() {
        Like compare = new Like("prop1", "someString");
        And and = new And(new Filter[]{compare, new Compare.Equal("prop3", (Object)"someString")});
        Filter f1 = DynamoFilterUtil.extractFilter((Filter)and, (String)"prop1");
        Assertions.assertNotNull((Object)f1);
        Filter f3 = DynamoFilterUtil.extractFilter((Filter)and, (String)"prop3");
        Assertions.assertNotNull((Object)f3);
        Filter f2 = DynamoFilterUtil.extractFilter((Filter)compare, (String)"prop2");
        Assertions.assertNull((Object)f2);
    }

    @Test
    public void testExtractFilter_In() {
        In in = new In("prop1", (Collection)Lists.newArrayList((Object[])new String[]{"a", "b"}));
        And and = new And(new Filter[]{in, new Compare.Equal("prop3", (Object)"someString")});
        Filter f1 = DynamoFilterUtil.extractFilter((Filter)and, (String)"prop1");
        Assertions.assertTrue((boolean)(f1 instanceof In));
    }

    @Test
    public void testExtractFilter_Contains() {
        Contains contains = new Contains("prop1", (Object)"a");
        And and = new And(new Filter[]{contains, new Compare.Equal("prop3", (Object)"someString")});
        Filter f1 = DynamoFilterUtil.extractFilter((Filter)and, (String)"prop1");
        Assertions.assertTrue((boolean)(f1 instanceof Contains));
    }

    @Test
    public void testExtractFilter_Compare2() {
        Compare.Equal compare = new Compare.Equal("prop1", (Object)"someString");
        Filter f1 = DynamoFilterUtil.extractFilter((Filter)compare, (String)"prop1");
        Assertions.assertNotNull((Object)f1);
        Filter f2 = DynamoFilterUtil.extractFilter((Filter)compare, (String)"prop2");
        Assertions.assertNull((Object)f2);
    }

    @Test
    public void testFlattenAnd() {
        Like compare = new Like("prop1", "someString");
        And and = new And(new Filter[]{compare, new Compare.Equal("prop3", (Object)"someString")});
        Like compare2 = new Like("prop1", "someString2");
        And and2 = new And(new Filter[]{and, compare2});
        List flattened2 = DynamoFilterUtil.flattenAnd((And)and);
        Assertions.assertEquals((int)2, (int)flattened2.size());
        Assertions.assertEquals((Object)compare, flattened2.get(0));
        List flattened = DynamoFilterUtil.flattenAnd((And)and2);
        Assertions.assertEquals((int)3, (int)flattened.size());
        Assertions.assertEquals((Object)compare, flattened.get(0));
        Assertions.assertEquals((Object)compare2, flattened.get(2));
    }

    @Test
    public void testRemoveFilters() {
        Compare.Equal compare1 = new Compare.Equal("prop1", (Object)"someString");
        Compare.Equal compare2 = new Compare.Equal("prop2", (Object)"someString");
        Compare.Equal compare3 = new Compare.Equal("prop3", (Object)"someString");
        And and = new And(new Filter[]{compare1, compare2, compare3});
        DynamoFilterUtil.removeFilters((Filter)and, (String[])new String[]{"prop1"});
        Assertions.assertEquals((int)2, (int)and.getFilters().size());
        and = new And(new Filter[]{compare1, compare2, compare3});
        DynamoFilterUtil.removeFilters((Filter)and, (String[])new String[]{"prop4"});
        Assertions.assertEquals((int)3, (int)and.getFilters().size());
        And nested = new And(new Filter[]{compare1, new And(new Filter[]{compare2, compare3})});
        DynamoFilterUtil.removeFilters((Filter)nested, (String[])new String[]{"prop2", "prop3"});
        Assertions.assertEquals((int)1, (int)nested.getFilters().size());
        and = new And(new Filter[]{compare1, new Not((Filter)compare2)});
        DynamoFilterUtil.removeFilters((Filter)and, (String[])new String[]{"prop2"});
        Assertions.assertEquals((int)1, (int)and.getFilters().size());
        and = new And(new Filter[]{compare1, new Not((Filter)new And(new Filter[]{compare2, compare3}))});
        DynamoFilterUtil.removeFilters((Filter)and, (String[])new String[]{"prop2", "prop3"});
        Assertions.assertEquals((int)1, (int)and.getFilters().size());
    }

    @Test
    public void testReplaceMasterAndDetailFilters1() {
        EntityModel model = this.emf.getModel(TestEntity.class);
        And and = new And(new Filter[]{new Compare.Equal("tags", (Object)Lists.newArrayList((Object[])new String[]{"abc"}))});
        DynamoFilterUtil.replaceMasterAndDetailFilters((Filter)and, (EntityModel)model);
        Filter replaced = (Filter)and.getFilters().get(0);
        Assertions.assertTrue((boolean)(replaced instanceof Or));
        Or or = (Or)replaced;
        Assertions.assertTrue((boolean)(or.getFilters().get(0) instanceof Contains));
        Contains ct = (Contains)or.getFilters().get(0);
        Assertions.assertEquals((Object)"abc", (Object)ct.getValue());
        and = new And(new Filter[]{new Compare.Equal("tags", (Object)"def")});
        DynamoFilterUtil.replaceMasterAndDetailFilters((Filter)and, (EntityModel)model);
        replaced = (Filter)and.getFilters().get(0);
        Assertions.assertTrue((boolean)(replaced instanceof Contains));
        ct = (Contains)replaced;
        Assertions.assertEquals((Object)"def", (Object)ct.getValue());
    }

    @Test
    public void testReplaceMasterAndDetailFilters2() {
        EntityModel model = this.emf.getModel(TestEntity2.class);
        And and = new And(new Filter[]{new Compare.Equal("testEntity", (Object)Lists.newArrayList((Object[])new TestEntity[]{new TestEntity(), new TestEntity()}))});
        DynamoFilterUtil.replaceMasterAndDetailFilters((Filter)and, (EntityModel)model);
        Filter replaced = (Filter)and.getFilters().get(0);
        Assertions.assertTrue((boolean)(replaced instanceof In));
        In in = (In)replaced;
        Assertions.assertEquals((int)2, (int)in.getValues().size());
        and = new And(new Filter[]{new Compare.Equal("testEntity", (Object)new TestEntity())});
        DynamoFilterUtil.replaceMasterAndDetailFilters((Filter)and, (EntityModel)model);
        replaced = (Filter)and.getFilters().get(0);
        Assertions.assertTrue((boolean)(replaced instanceof Compare.Equal));
    }

    @Test
    public void testReplaceMasterAndDetailFilters3() {
        EntityModel model = this.emf.getModel(TestEntity2.class);
        And and = new And(new Filter[]{new Compare.Equal("testEntity", (Object)Lists.newArrayList((Object[])new TestEntity[]{new TestEntity(), new TestEntity()}))});
        DynamoFilterUtil.replaceMasterAndDetailFilters((Filter)and, (EntityModel)model);
        Filter replaced = (Filter)and.getFilters().get(0);
        Assertions.assertTrue((boolean)(replaced instanceof In));
        In in = (In)replaced;
        Assertions.assertEquals((int)2, (int)in.getValues().size());
        and = new And(new Filter[]{new Compare.Equal("testEntity", (Object)new TestEntity())});
        DynamoFilterUtil.replaceMasterAndDetailFilters((Filter)and, (EntityModel)model);
        replaced = (Filter)and.getFilters().get(0);
        Assertions.assertTrue((boolean)(replaced instanceof Compare.Equal));
    }
}

