/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.filter;

import com.google.common.collect.Lists;
import com.ocs.dynamo.domain.TestEntity;
import com.ocs.dynamo.domain.TestEntity2;
import com.ocs.dynamo.filter.AbstractJunctionFilter;
import com.ocs.dynamo.filter.And;
import com.ocs.dynamo.filter.Between;
import com.ocs.dynamo.filter.CollectionHolder;
import com.ocs.dynamo.filter.Compare;
import com.ocs.dynamo.filter.Contains;
import com.ocs.dynamo.filter.Filter;
import com.ocs.dynamo.filter.In;
import com.ocs.dynamo.filter.IsNull;
import com.ocs.dynamo.filter.Like;
import com.ocs.dynamo.filter.Modulo;
import com.ocs.dynamo.filter.Not;
import com.ocs.dynamo.filter.Or;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FilterTest {
    @Test
    public void testFilterSingleProperty() {
        TestEntity entity = new TestEntity("Bert", 23L);
        Assertions.assertTrue((boolean)new Compare.Equal("name", (Object)"Bert").evaluate((Object)entity));
        Assertions.assertTrue((boolean)new Compare.LessOrEqual("name", (Object)"Bert").evaluate((Object)entity));
        Assertions.assertTrue((boolean)new Compare.LessOrEqual("age", (Object)23L).evaluate((Object)entity));
        Assertions.assertTrue((boolean)new Compare.Equal("age", (Object)23L).evaluate((Object)entity));
        Assertions.assertTrue((boolean)new Compare.Less("age", (Object)25L).evaluate((Object)entity));
        Assertions.assertFalse((boolean)new Compare.GreaterOrEqual("age", (Object)25L).evaluate((Object)entity));
    }

    @Test
    public void testFilterBetween() {
        TestEntity entity = new TestEntity("Bert", 23L);
        Between between = new Between("age", (Comparable)Long.valueOf(22L), (Comparable)Long.valueOf(24L));
        Assertions.assertTrue((boolean)between.evaluate((Object)entity));
        between = new Between("age", (Comparable)Long.valueOf(43L), (Comparable)Long.valueOf(45L));
        Assertions.assertFalse((boolean)between.evaluate((Object)entity));
        TestEntity2 e2 = new TestEntity2();
        between = new Between("testEntity", (Comparable)Long.valueOf(22L), (Comparable)Long.valueOf(24L));
        Assertions.assertFalse((boolean)between.evaluate((Object)e2));
        Assertions.assertFalse((boolean)between.equals(null));
        Assertions.assertTrue((boolean)between.equals((Object)between));
        Assertions.assertTrue((boolean)between.equals((Object)new Between("testEntity", (Comparable)Long.valueOf(22L), (Comparable)Long.valueOf(24L))));
        Assertions.assertFalse((boolean)between.equals((Object)new Between("testEntity", (Comparable)Long.valueOf(22L), (Comparable)Long.valueOf(23L))));
        Assertions.assertFalse((boolean)between.equals((Object)new Compare.Equal("testEntity", (Object)44)));
    }

    @Test
    public void testFilterNot() {
        TestEntity entity = new TestEntity("Bert", 23L);
        Compare.Equal filter = new Compare.Equal("name", (Object)"Bert");
        Assertions.assertTrue((boolean)filter.evaluate((Object)entity));
        Assertions.assertFalse((boolean)new Not((Filter)filter).evaluate((Object)entity));
        Assertions.assertTrue((boolean)filter.and().not((Filter)new Compare.Equal("age", (Object)24)).evaluate((Object)entity));
        Not not = new Not((Filter)filter);
        Assertions.assertFalse((boolean)not.equals(null));
        Assertions.assertFalse((boolean)not.equals((Object)filter));
        Assertions.assertTrue((boolean)not.equals((Object)not));
    }

    @Test
    public void testFilterAnd() {
        TestEntity entity = new TestEntity("Bert", 23L);
        And conjunction = new Compare.Equal("name", (Object)"Bert").and(new Filter[]{new Compare.Equal("age", (Object)23L)});
        Assertions.assertTrue((boolean)conjunction.evaluate((Object)entity));
        conjunction = new Compare.Equal("name", (Object)"Bert").and(new Filter[]{new Compare.Equal("age", (Object)24L)});
        Assertions.assertFalse((boolean)conjunction.evaluate((Object)entity));
        conjunction = new And(new Filter[]{new Like("name", "%er%"), new Compare.Equal("age", (Object)23L)});
        Assertions.assertTrue((boolean)conjunction.evaluate((Object)entity));
        Assertions.assertFalse((boolean)conjunction.equals(null));
        Assertions.assertFalse((boolean)conjunction.equals(new Object()));
        Assertions.assertTrue((boolean)conjunction.equals(conjunction));
        Assertions.assertFalse((boolean)conjunction.equals(new And(new Filter[]{new Like("name", "%er%"), new Compare.Equal("age", (Object)24L)})));
        Assertions.assertNotNull((Object)conjunction.toString());
    }

    @Test
    public void testFilterOr() {
        TestEntity entity = new TestEntity("Bert", 23L);
        Or disjunction = new Compare.Equal("name", (Object)"Bert").or(new Filter[]{new Compare.Equal("age", (Object)23L)});
        Assertions.assertTrue((boolean)disjunction.evaluate((Object)entity));
        disjunction = new Compare.Equal("name", (Object)"Bert").or(new Filter[]{new Compare.Equal("age", (Object)24L)});
        Assertions.assertTrue((boolean)disjunction.evaluate((Object)entity));
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.add(new Like("name", "%ob%"));
        filters.add(new Compare.Equal("age", (Object)25L));
        disjunction = new Or(filters);
        Assertions.assertFalse((boolean)disjunction.evaluate((Object)entity));
        Assertions.assertFalse((boolean)disjunction.equals(null));
        Assertions.assertFalse((boolean)disjunction.equals(new Object()));
        Assertions.assertTrue((boolean)disjunction.equals(disjunction));
        Assertions.assertFalse((boolean)disjunction.equals(new Or(new Filter[]{new Like("name", "%er%"), new Compare.Equal("age", (Object)24L)})));
    }

    @Test
    public void testFilterIsNull() {
        TestEntity entity = new TestEntity(null, 23L);
        IsNull isNull = new IsNull("name");
        Assertions.assertFalse((boolean)isNull.evaluate(null));
        Assertions.assertTrue((boolean)isNull.evaluate((Object)entity));
        IsNull isNull2 = new IsNull("age");
        Assertions.assertFalse((boolean)isNull2.evaluate((Object)entity));
        Assertions.assertTrue((boolean)isNull.equals((Object)isNull));
        Assertions.assertFalse((boolean)isNull.equals(null));
        Assertions.assertFalse((boolean)isNull.equals((Object)isNull2));
    }

    @Test
    public void testCompare() {
        TestEntity testEntity1 = new TestEntity("A", 14L);
        TestEntity testEntity2 = new TestEntity("B", 12L);
        Compare.Equal equal = new Compare.Equal("age", (Object)14L);
        Assertions.assertFalse((boolean)equal.evaluate(null));
        Assertions.assertFalse((boolean)equal.evaluate((Object)new TestEntity()));
        Assertions.assertTrue((boolean)equal.evaluate((Object)testEntity1));
        Assertions.assertFalse((boolean)equal.evaluate((Object)testEntity2));
        Assertions.assertFalse((boolean)equal.evaluate(null));
        Compare.Equal equalNull = new Compare.Equal("age", null);
        Assertions.assertFalse((boolean)equalNull.evaluate((Object)testEntity1));
        Compare.Less less = new Compare.Less("age", (Object)14L);
        Assertions.assertFalse((boolean)less.evaluate((Object)testEntity1));
        Assertions.assertTrue((boolean)less.evaluate((Object)testEntity2));
        Assertions.assertFalse((boolean)less.evaluate(null));
        Compare.Greater greater = new Compare.Greater("age", (Object)13L);
        Assertions.assertTrue((boolean)greater.evaluate((Object)testEntity1));
        Assertions.assertFalse((boolean)greater.evaluate((Object)testEntity2));
        Compare.GreaterOrEqual greaterEqual = new Compare.GreaterOrEqual("age", (Object)14L);
        Assertions.assertTrue((boolean)greaterEqual.evaluate((Object)testEntity1));
        Assertions.assertFalse((boolean)greaterEqual.evaluate((Object)testEntity2));
        Compare.LessOrEqual lessEqual = new Compare.LessOrEqual("age", (Object)12L);
        Assertions.assertFalse((boolean)lessEqual.evaluate((Object)testEntity1));
        Assertions.assertTrue((boolean)lessEqual.evaluate((Object)testEntity2));
        Assertions.assertFalse((boolean)equal.equals(null));
        Assertions.assertTrue((boolean)equal.equals((Object)equal));
        Assertions.assertFalse((boolean)equal.equals((Object)new Compare.Equal("age", (Object)15L)));
        Assertions.assertFalse((boolean)equal.equals((Object)less));
    }

    @Test
    public void testIn() {
        TestEntity testEntity = new TestEntity();
        testEntity.setId(1);
        In in = new In("id", (Collection)Lists.newArrayList((Object[])new Integer[]{1}));
        Assertions.assertFalse((boolean)in.evaluate(null));
        Assertions.assertTrue((boolean)in.evaluate((Object)testEntity));
        In in2 = new In("id", (Collection)Lists.newArrayList((Object[])new Integer[]{1}));
        In in3 = new In("id", (Collection)Lists.newArrayList((Object[])new Integer[]{1, 2}));
        Assertions.assertFalse((boolean)in.equals(null));
        Assertions.assertFalse((boolean)in.equals(new Object()));
        Assertions.assertTrue((boolean)in.equals((Object)in));
        Assertions.assertTrue((boolean)in.equals((Object)in2));
        Assertions.assertFalse((boolean)in.equals((Object)in3));
    }

    @Test
    public void testContains() {
        TestEntity testEntity = new TestEntity();
        testEntity.setId(1);
        Contains contains = new Contains("entities", (Object)testEntity);
        Contains contains2 = new Contains("other", (Object)testEntity);
        Assertions.assertFalse((boolean)contains.equals((Object)contains2));
        CollectionHolder holder = new CollectionHolder();
        holder.getEntities().add(testEntity);
        Assertions.assertTrue((boolean)contains.evaluate((Object)holder));
        Assertions.assertFalse((boolean)contains.evaluate((Object)new CollectionHolder()));
        Assertions.assertFalse((boolean)contains.evaluate(null));
        contains = new Contains("other", (Object)testEntity);
        holder = new CollectionHolder();
        holder.setOther(2);
        Assertions.assertFalse((boolean)contains.evaluate((Object)holder));
        Assertions.assertTrue((boolean)contains.equals((Object)contains));
        Assertions.assertFalse((boolean)contains.equals(null));
    }

    @Test
    public void testFilterModulo() {
        TestEntity testEntity = new TestEntity();
        testEntity.setId(4);
        testEntity.setAge(44L);
        testEntity.setName("Bob");
        Modulo modulo = new Modulo("age", "id", (Number)0);
        Assertions.assertTrue((boolean)modulo.evaluate((Object)testEntity));
        testEntity.setAge(45L);
        modulo = new Modulo("age", "id", (Number)0);
        Assertions.assertFalse((boolean)modulo.evaluate((Object)testEntity));
        modulo = new Modulo("age", "id", (Number)1);
        Assertions.assertTrue((boolean)modulo.evaluate((Object)testEntity));
        modulo = new Modulo("age", Integer.valueOf(9), (Number)0);
        Assertions.assertTrue((boolean)modulo.evaluate((Object)testEntity));
        modulo = new Modulo("age", Integer.valueOf(9), (Number)1);
        Assertions.assertFalse((boolean)modulo.evaluate((Object)testEntity));
        modulo = new Modulo("name", Integer.valueOf(9), (Number)1);
        Assertions.assertFalse((boolean)modulo.evaluate((Object)testEntity));
        modulo = new Modulo("name", Integer.valueOf(9), (Number)1);
        Assertions.assertFalse((boolean)modulo.evaluate(null));
    }

    @Test
    public void testFilterLike() {
        TestEntity testEntity = new TestEntity();
        testEntity.setName("Bob");
        Like like = new Like("name", "b%", false);
        Assertions.assertFalse((boolean)like.evaluate(null));
        Assertions.assertTrue((boolean)like.evaluate((Object)testEntity));
        like = new Like("name", "b%", true);
        Assertions.assertFalse((boolean)like.evaluate((Object)testEntity));
        Like notString = new Like("age", "b%", false);
        Assertions.assertFalse((boolean)notString.evaluate((Object)testEntity));
        Assertions.assertFalse((boolean)like.equals(null));
        Assertions.assertFalse((boolean)like.equals(new Object()));
        Assertions.assertTrue((boolean)like.equals((Object)like));
        Assertions.assertTrue((boolean)like.equals((Object)new Like("name", "b%", true)));
        Assertions.assertFalse((boolean)like.equals((Object)new Like("name", "b%", false)));
        Like like2 = new Like("name", "%o%", true);
        Assertions.assertTrue((boolean)like2.evaluate((Object)testEntity));
    }

    @Test
    public void testCompose() {
        Compare.Equal equal = new Compare.Equal("property1", (Object)1);
        AbstractJunctionFilter filter = equal.greater("property2", (Object)2);
        Assertions.assertTrue((boolean)(filter instanceof And));
        Assertions.assertEquals((int)2, (int)filter.getFilters().size());
        filter = filter.greaterOrEqual("property3", (Object)3);
        Assertions.assertTrue((boolean)(filter instanceof And));
        Assertions.assertEquals((int)3, (int)filter.getFilters().size());
        filter = filter.less("property4", (Object)4);
        Assertions.assertTrue((boolean)(filter instanceof And));
        Assertions.assertEquals((int)4, (int)filter.getFilters().size());
        filter = filter.lessOrEqual("property4", (Object)5);
        Assertions.assertTrue((boolean)(filter instanceof And));
        Assertions.assertEquals((int)5, (int)filter.getFilters().size());
        filter = filter.isNull("property5");
        Assertions.assertTrue((boolean)(filter instanceof And));
        Assertions.assertEquals((int)6, (int)filter.getFilters().size());
        filter = filter.between("property6", (Comparable)Integer.valueOf(6), (Comparable)Integer.valueOf(7));
        Assertions.assertTrue((boolean)(filter instanceof And));
        Assertions.assertEquals((int)7, (int)filter.getFilters().size());
        filter = filter.like("property7", "abc");
        Assertions.assertTrue((boolean)(filter instanceof And));
        Assertions.assertEquals((int)8, (int)filter.getFilters().size());
        Like like = (Like)filter.getFilters().get(7);
        Assertions.assertTrue((boolean)like.isCaseSensitive());
        filter = filter.isEqual("property8", (Object)8);
        Assertions.assertTrue((boolean)(filter instanceof And));
        Assertions.assertEquals((int)9, (int)filter.getFilters().size());
        filter = filter.like("property9", "abc", false);
        Assertions.assertTrue((boolean)(filter instanceof And));
        Assertions.assertEquals((int)10, (int)filter.getFilters().size());
        like = (Like)filter.getFilters().get(9);
        Assertions.assertFalse((boolean)like.isCaseSensitive());
        filter = filter.likeIgnoreCase("property8", "abc");
        Assertions.assertTrue((boolean)(filter instanceof And));
        Assertions.assertEquals((int)11, (int)filter.getFilters().size());
        like = (Like)filter.getFilters().get(10);
        Assertions.assertFalse((boolean)like.isCaseSensitive());
    }

    @Test
    public void testComposeOr() {
        Compare.Equal equal1 = new Compare.Equal("property1", (Object)1);
        Compare.Equal equal2 = new Compare.Equal("property2", (Object)1);
        Or or = equal1.or(new Filter[]{equal2});
        Assertions.assertEquals((int)2, (int)or.getFilters().size());
        AbstractJunctionFilter filter = or.greater("property3", (Object)3);
        Assertions.assertTrue((boolean)(filter instanceof Or));
        Assertions.assertEquals((int)3, (int)filter.getFilters().size());
        Or result = equal1.or();
        Assertions.assertTrue((boolean)(result instanceof Or));
    }

    @Test
    public void testApplyFilter() {
        Compare.Equal equal1 = new Compare.Equal("name", (Object)"Bob");
        TestEntity t1 = new TestEntity("Pete", 14L);
        TestEntity t2 = new TestEntity("Bob", 14L);
        ArrayList list = Lists.newArrayList((Object[])new TestEntity[]{t1, t2});
        List result = equal1.applyFilter((Collection)list);
        Assertions.assertEquals((int)1, (int)result.size());
    }
}

