/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.service.impl;

import com.google.common.collect.Lists;
import com.ocs.dynamo.dao.BaseDao;
import com.ocs.dynamo.dao.FetchJoinInformation;
import com.ocs.dynamo.dao.Pageable;
import com.ocs.dynamo.dao.PageableImpl;
import com.ocs.dynamo.dao.SortOrder;
import com.ocs.dynamo.dao.SortOrders;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.TestEntity;
import com.ocs.dynamo.exception.OCSNonUniqueException;
import com.ocs.dynamo.exception.OCSValidationException;
import com.ocs.dynamo.filter.Compare;
import com.ocs.dynamo.filter.Filter;
import com.ocs.dynamo.service.MessageService;
import com.ocs.dynamo.service.impl.BaseServiceImpl;
import com.ocs.dynamo.test.BaseMockitoTest;
import com.ocs.dynamo.test.MockUtil;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
public class BaseServiceImplTest
extends BaseMockitoTest {
    private static final int ID = 1;
    @Mock
    private BaseDao<Integer, TestEntity> dao;
    @Mock
    private Dependency dependency;
    @Mock
    private MessageService messageService;
    @InjectMocks
    private TestService service = new TestService();
    @Mock
    private Validator validator;
    @Spy
    private ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();

    @BeforeEach
    public void setupBaseServiceImplTest() throws NoSuchFieldException {
        Mockito.when((Object)this.dao.getEntityClass()).thenReturn(TestEntity.class);
    }

    @Test
    public void testCount() {
        this.service.count();
        ((BaseDao)Mockito.verify(this.dao)).count();
    }

    @Test
    public void testCountFilter() {
        Compare.Equal filter = new Compare.Equal("property1", (Object)1);
        this.service.count((Filter)filter, false);
        ((BaseDao)Mockito.verify(this.dao)).count((Filter)filter, false);
        this.service.count((Filter)filter, true);
        ((BaseDao)Mockito.verify(this.dao)).count((Filter)filter, true);
    }

    @Test
    public void testCreateNewEntity() {
        TestEntity entity = (TestEntity)this.service.createNewEntity();
        Assertions.assertNotNull((Object)((Object)entity));
    }

    @Test
    public void testCreatePageable() {
        Compare.Equal filter = new Compare.Equal("name", (Object)"Piet");
        SortOrder order = new SortOrder("name", SortOrder.Direction.ASC);
        SortOrder order2 = new SortOrder("age", SortOrder.Direction.DESC);
        this.service.fetch((Filter)filter, 2, 10, new SortOrders(new SortOrder[]{order, order2}), new FetchJoinInformation[0]);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Pageable.class);
        ((BaseDao)Mockito.verify(this.dao)).fetch((Filter)ArgumentMatchers.any(Filter.class), (Pageable)captor.capture(), new FetchJoinInformation[0]);
        Pageable p = (Pageable)captor.getValue();
        SortOrder.Direction dir = p.getSortOrders().getOrderFor("name").getDirection();
        Assertions.assertEquals((Object)SortOrder.Direction.ASC, (Object)dir);
        SortOrder.Direction dir2 = p.getSortOrders().getOrderFor("age").getDirection();
        Assertions.assertEquals((Object)SortOrder.Direction.DESC, (Object)dir2);
        Assertions.assertEquals((int)2, (int)p.getPageNumber());
        Assertions.assertEquals((int)20, (int)p.getOffset());
        Assertions.assertEquals((int)10, (int)p.getPageSize());
    }

    @Test
    public void testCreateSort() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ids.add(1);
        SortOrder order = new SortOrder("name", SortOrder.Direction.ASC);
        SortOrder order2 = new SortOrder("age", SortOrder.Direction.DESC);
        this.service.fetchByIds(ids, new SortOrders(new SortOrder[]{order, order2}), new FetchJoinInformation[]{new FetchJoinInformation("test")});
        ArgumentCaptor captor = ArgumentCaptor.forClass(SortOrders.class);
        ((BaseDao)Mockito.verify(this.dao)).fetchByIds((List)ArgumentMatchers.any(List.class), (Filter)Mockito.isNull(), (SortOrders)captor.capture(), (FetchJoinInformation[])ArgumentMatchers.any());
        SortOrders s = (SortOrders)captor.getValue();
        Assertions.assertNotNull((Object)s);
        SortOrder.Direction dir = s.getOrderFor("name").getDirection();
        Assertions.assertEquals((Object)SortOrder.Direction.ASC, (Object)dir);
        dir = s.getOrderFor("age").getDirection();
        Assertions.assertEquals((Object)SortOrder.Direction.DESC, (Object)dir);
        Assertions.assertNull((Object)s.getOrderFor("notExists"));
    }

    @Test
    public void testDelete() {
        TestEntity obj = new TestEntity();
        this.service.delete((AbstractEntity)obj);
        ((BaseDao)Mockito.verify(this.dao)).delete((AbstractEntity)obj);
    }

    @Test
    public void testDeleteList() {
        TestEntity obj = new TestEntity();
        TestEntity obj2 = new TestEntity();
        this.service.delete(Lists.newArrayList((Object[])new TestEntity[]{obj, obj2}));
        ((BaseDao)Mockito.verify(this.dao)).delete((List)Lists.newArrayList((Object[])new TestEntity[]{obj, obj2}));
    }

    @Test
    public void testFetchById() {
        this.service.fetchById(1, new FetchJoinInformation[0]);
        ((BaseDao)Mockito.verify(this.dao)).fetchById((Object)1, new FetchJoinInformation[0]);
        this.service.fetchById(1, new FetchJoinInformation[]{new FetchJoinInformation("property1")});
        ((BaseDao)Mockito.verify(this.dao)).fetchById((Object)1, new FetchJoinInformation[]{new FetchJoinInformation("property1")});
    }

    @Test
    public void testFetchByIds() {
        this.service.fetchByIds(Lists.newArrayList((Object[])new Integer[]{1, 2}), new FetchJoinInformation[0]);
        ((BaseDao)Mockito.verify(this.dao)).fetchByIds((List)Lists.newArrayList((Object[])new Integer[]{1, 2}), null, new FetchJoinInformation[0]);
        this.service.fetchByIds(Lists.newArrayList((Object[])new Integer[]{1, 2}), new FetchJoinInformation[]{new FetchJoinInformation("property1")});
        ((BaseDao)Mockito.verify(this.dao)).fetchByIds((List)Lists.newArrayList((Object[])new Integer[]{1, 2}), null, new FetchJoinInformation[]{new FetchJoinInformation("property1")});
    }

    @Test
    public void testFetchByUniqueProperty() {
        this.service.fetchByUniqueProperty("property1", "test", true, new FetchJoinInformation[0]);
        ((BaseDao)Mockito.verify(this.dao)).fetchByUniqueProperty("property1", (Object)"test", true, new FetchJoinInformation[0]);
        this.service.fetchByUniqueProperty("property1", "test", false, new FetchJoinInformation[0]);
        ((BaseDao)Mockito.verify(this.dao)).fetchByUniqueProperty("property1", (Object)"test", false, new FetchJoinInformation[0]);
    }

    @Test
    public void testFetchFilter() {
        Compare.Equal filter = new Compare.Equal("property1", (Object)1);
        this.service.fetch((Filter)filter, new FetchJoinInformation[]{new FetchJoinInformation("testEntities")});
        ((BaseDao)Mockito.verify(this.dao)).fetch((Filter)filter, new FetchJoinInformation[]{new FetchJoinInformation("testEntities")});
        this.service.fetch((Filter)filter, new FetchJoinInformation[0]);
        ((BaseDao)Mockito.verify(this.dao)).fetch((Filter)filter, new FetchJoinInformation[0]);
    }

    @Test
    public void testFetchFilterPageable() {
        Compare.Equal filter = new Compare.Equal("property1", (Object)1);
        this.service.fetch((Filter)filter, 2, 10, new FetchJoinInformation[]{new FetchJoinInformation("testEntities")});
        ArgumentCaptor captor = ArgumentCaptor.forClass(Pageable.class);
        ((BaseDao)Mockito.verify(this.dao)).fetch((Filter)ArgumentMatchers.eq((Object)filter), (Pageable)captor.capture(), new FetchJoinInformation[]{(FetchJoinInformation)ArgumentMatchers.eq((Object)new FetchJoinInformation("testEntities"))});
        Pageable pb = (Pageable)captor.getValue();
        Assertions.assertEquals((int)20, (int)pb.getOffset());
        Assertions.assertEquals((int)10, (int)pb.getPageSize());
        Assertions.assertEquals((int)2, (int)pb.getPageNumber());
    }

    @Test
    public void testFetchSortOrderJoins() {
        Compare.Equal filter = new Compare.Equal("property1", (Object)1);
        SortOrders orders = new SortOrders(new SortOrder[]{new SortOrder("property2")});
        FetchJoinInformation[] joins = new FetchJoinInformation[]{new FetchJoinInformation("testEntities")};
        this.service.fetch((Filter)filter, orders, joins);
        ((BaseDao)Mockito.verify(this.dao)).fetch((Filter)filter, orders, joins);
    }

    @Test
    public void testFilter() {
        Compare.Equal filter = new Compare.Equal("property1", (Object)1);
        this.service.find((Filter)filter);
        ((BaseDao)Mockito.verify(this.dao)).find((Filter)filter);
    }

    @Test
    public void testFindAll() {
        this.service.findAll();
        ((BaseDao)Mockito.verify(this.dao)).findAll();
        this.service.findAll(new SortOrder[]{new SortOrder("property1")});
        ((BaseDao)Mockito.verify(this.dao)).findAll(new SortOrder[]{new SortOrder("property1", SortOrder.Direction.ASC)});
        this.service.findAll(new SortOrder[]{new SortOrder("property1", SortOrder.Direction.DESC)});
        ((BaseDao)Mockito.verify(this.dao)).findAll(new SortOrder[]{new SortOrder("property1", SortOrder.Direction.DESC)});
    }

    @Test
    public void testFindById() {
        TestEntity obj = new TestEntity();
        Mockito.when((Object)((Object)((TestEntity)this.dao.findById((Object)1)))).thenReturn((Object)obj);
        TestEntity result = (TestEntity)this.service.findById(1);
        Assertions.assertNotNull((Object)((Object)result));
    }

    @Test
    public void testFindDistinct() {
        Compare.Equal filter = new Compare.Equal("property1", (Object)1);
        SortOrder so = new SortOrder("property2");
        this.service.findDistinct((Filter)filter, "property1", String.class, new SortOrder[]{so});
        ((BaseDao)Mockito.verify(this.dao)).findDistinct((Filter)filter, "property1", String.class, new SortOrder[]{so});
    }

    @Test
    public void testFindIds() {
        this.service.findIds((Filter)new Compare.Equal("property1", (Object)12), new SortOrder[]{new SortOrder("property1")});
        ((BaseDao)Mockito.verify(this.dao)).findIds((Filter)new Compare.Equal("property1", (Object)12), new SortOrder[]{new SortOrder("property1", SortOrder.Direction.ASC)});
    }

    @Test
    public void testFindSelect() {
        Compare.Equal filter = new Compare.Equal("property1", (Object)1);
        SortOrders so = new SortOrders(new SortOrder[]{new SortOrder("property1")});
        this.service.findSelect((Filter)filter, new String[]{"property1", "property2"}, so);
        ((BaseDao)Mockito.verify(this.dao)).findSelect((Filter)filter, new String[]{"property1", "property2"}, so);
    }

    @Test
    public void testFindSelect2() {
        Compare.Equal filter = new Compare.Equal("property1", (Object)1);
        SortOrders so = new SortOrders(new SortOrder[]{new SortOrder("property1")});
        this.service.findSelect((Filter)filter, new String[]{"property1", "property2"}, 1, 10, so);
        ((BaseDao)Mockito.verify(this.dao)).findSelect((Filter)ArgumentMatchers.eq((Object)filter), (String[])ArgumentMatchers.eq((Object)new String[]{"property1", "property2"}), (Pageable)ArgumentMatchers.any(PageableImpl.class));
    }

    @Test
    public void testNoop() {
        this.service.noop();
        ((Dependency)Mockito.verify((Object)this.dependency)).noop();
    }

    @Test
    public void testSave() {
        TestEntity obj = new TestEntity("name1", 14L);
        MockUtil.mockSave(this.dao, TestEntity.class);
        TestEntity result = (TestEntity)this.service.save((AbstractEntity)obj);
        Assertions.assertNotNull((Object)((Object)result));
        ((BaseDao)Mockito.verify(this.dao)).save((AbstractEntity)obj);
    }

    @Test
    public void testSaveList() {
        TestEntity obj1 = new TestEntity("name1", 14L);
        TestEntity obj2 = new TestEntity("name2", 15L);
        this.service.save(Lists.newArrayList((Object[])new TestEntity[]{obj1, obj2}));
        ((BaseDao)Mockito.verify(this.dao)).save((List)Lists.newArrayList((Object[])new TestEntity[]{obj1, obj2}));
    }

    @Test
    public void testValidate() {
        TestEntity entity = new TestEntity("name1", 15L);
        this.service.validate((AbstractEntity)entity);
    }

    @Test
    public void testValidate_AssertTrue() {
        TestEntity entity = new TestEntity("bogus", 15L);
        Assertions.assertThrows(OCSValidationException.class, () -> this.service.validate((AbstractEntity)entity));
    }

    @Test
    public void testValidate_Error() {
        TestEntity entity = new TestEntity(null, 15L);
        Assertions.assertThrows(OCSValidationException.class, () -> this.service.validate((AbstractEntity)entity));
    }

    @Test
    public void testValidate_Identical() {
        TestEntity entity = new TestEntity("kevin", 15L);
        TestEntity other = new TestEntity();
        other.setId(4);
        Mockito.when((Object)((Object)((TestEntity)this.dao.findByUniqueProperty("name", (Object)"kevin", true)))).thenReturn((Object)other);
        Assertions.assertThrows(OCSNonUniqueException.class, () -> this.service.validate((AbstractEntity)entity));
    }

    private class TestService
    extends BaseServiceImpl<Integer, TestEntity> {
        @Autowired
        private Dependency dependency;

        private TestService() {
        }

        protected TestEntity findIdenticalEntity(TestEntity entity) {
            return (TestEntity)BaseServiceImplTest.this.dao.findByUniqueProperty("name", (Object)entity.getName(), true);
        }

        protected BaseDao<Integer, TestEntity> getDao() {
            return BaseServiceImplTest.this.dao;
        }

        public void noop() {
            this.dependency.noop();
        }
    }

    private class Dependency {
        private Dependency() {
        }

        public void noop() {
        }
    }
}

