/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.service.impl;

import com.ocs.dynamo.dao.BaseDao;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.QTestEntity;
import com.ocs.dynamo.domain.TestEntity;
import com.ocs.dynamo.service.impl.DefaultServiceImpl;
import com.ocs.dynamo.test.BaseMockitoTest;
import com.querydsl.core.types.dsl.EntityPathBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;

public class DefaultServiceImplTest
extends BaseMockitoTest {
    @Mock
    private BaseDao<Integer, TestEntity> dao;
    private DefaultServiceImpl<Integer, TestEntity> service;

    @Test
    public void testConstructWithDao() {
        this.service = new DefaultServiceImpl(this.dao);
        Assertions.assertNull((Object)this.service.getUniquePropertyIds());
        TestEntity te = new TestEntity();
        te.setName("Kevin");
        this.service.findIdenticalEntity((AbstractEntity)te);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.dao});
    }

    @Test
    public void testConstructWithDaoAndUniqueProperty() {
        this.service = new DefaultServiceImpl(this.dao, new String[]{"name"});
        Assertions.assertEquals((Object)"name", (Object)this.service.getUniquePropertyIds()[0]);
        Assertions.assertFalse((boolean)this.service.isUniqueCaseSensitive());
        TestEntity te = new TestEntity();
        te.setName("Kevin");
        this.service.findIdenticalEntity((AbstractEntity)te);
        ((BaseDao)Mockito.verify(this.dao)).findByUniqueProperty("name", (Object)"Kevin", false);
    }

    @Test
    public void testConstructWithDaoAndUniquePropertyCaseSensitive() {
        this.service = new DefaultServiceImpl(this.dao, new String[]{"name"}, true);
        Assertions.assertEquals((Object)"name", (Object)this.service.getUniquePropertyIds()[0]);
        Assertions.assertTrue((boolean)this.service.isUniqueCaseSensitive());
        TestEntity te = new TestEntity();
        te.setName("Kevin");
        this.service.findIdenticalEntity((AbstractEntity)te);
        ((BaseDao)Mockito.verify(this.dao)).findByUniqueProperty("name", (Object)"Kevin", true);
    }

    @Test
    public void testConstructWithDslAndClass() {
        this.service = new DefaultServiceImpl((EntityPathBase)QTestEntity.testEntity, TestEntity.class);
        Assertions.assertNull((Object)this.service.getUniquePropertyIds());
    }

    @Test
    public void testConstructWithDslAndClassAndProperty() {
        this.service = new DefaultServiceImpl((EntityPathBase)QTestEntity.testEntity, TestEntity.class, new String[]{"name"});
        Assertions.assertEquals((Object)"name", (Object)this.service.getUniquePropertyIds()[0]);
        Assertions.assertFalse((boolean)this.service.isUniqueCaseSensitive());
    }

    @Test
    public void testConstructWithDslAndClassAndPropertyCaseSensitive() {
        this.service = new DefaultServiceImpl((EntityPathBase)QTestEntity.testEntity, TestEntity.class, new String[]{"name"}, true);
        Assertions.assertEquals((Object)"name", (Object)this.service.getUniquePropertyIds()[0]);
        Assertions.assertTrue((boolean)this.service.isUniqueCaseSensitive());
    }
}

