/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.utils;

import com.ocs.dynamo.domain.TestEntity;
import com.ocs.dynamo.domain.TestEntity2;
import com.ocs.dynamo.domain.model.annotation.Attribute;
import com.ocs.dynamo.exception.OCSRuntimeException;
import com.ocs.dynamo.utils.ClassUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import javax.validation.constraints.Size;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClassUtilsTest {
    @Test
    public void testClearFieldValue() {
        TestEntity entity = new TestEntity();
        entity.setSomeBytes(new byte[]{1, 2, 3, 4});
        entity.setName("Bob");
        entity.setAge(44L);
        ClassUtils.clearFieldValue((Object)((Object)entity), (String)"someBytes", byte[].class);
        Assertions.assertNull((Object)entity.getSomeBytes());
        ClassUtils.clearFieldValue((Object)((Object)entity), (String)"name", String.class);
        Assertions.assertNull((Object)entity.getName());
        TestEntity2 entity2 = new TestEntity2();
        entity2.setTestEntity(entity);
        ClassUtils.clearFieldValue((Object)((Object)entity2), (String)"testEntity.age", Long.class);
        Assertions.assertNull((Object)entity.getAge());
    }

    @Test
    public void testCanSetProperty() {
        TestEntity2 entity2 = new TestEntity2();
        Assertions.assertTrue((boolean)ClassUtils.canSetProperty((Object)((Object)entity2), (String)"name"));
        Assertions.assertFalse((boolean)ClassUtils.canSetProperty((Object)((Object)entity2), (String)"phone"));
        Assertions.assertFalse((boolean)ClassUtils.canSetProperty((Object)((Object)entity2), (String)"testEntity.name"));
        entity2.setTestEntity(new TestEntity());
        Assertions.assertTrue((boolean)ClassUtils.canSetProperty((Object)((Object)entity2), (String)"testEntity.name"));
        Assertions.assertFalse((boolean)ClassUtils.canSetProperty((Object)((Object)entity2), (String)"testEntity.phone"));
    }

    @Test
    public void testForClass() {
        Class clazz = ClassUtils.forClass((String)"com.ocs.dynamo.domain.TestEntity");
        Assertions.assertNotNull((Object)clazz);
    }

    @Test
    public void testForClassBogus() {
        Class clazz = ClassUtils.forClass((String)"com.ocs.dynamo.domain.TestEntityZ");
        Assertions.assertNull((Object)clazz);
    }

    @Test
    public void testForClassNull() {
        Class clazz = ClassUtils.forClass((String)"");
        Assertions.assertNull((Object)clazz);
    }

    @Test
    public void testGetAnnotationOnField() {
        Field fieldOne = ClassUtils.getField(TestObject.class, (String)"fieldOne");
        Attribute attribute = (Attribute)ClassUtils.getAnnotationOnField((Field)fieldOne, Attribute.class);
        Assertions.assertNotNull((Object)attribute);
        Assertions.assertEquals((Object)"desc", (Object)attribute.description());
        attribute = (Attribute)ClassUtils.getAnnotationOnField(TestObject.class, (String)"fieldOne", Attribute.class);
        Assertions.assertEquals((Object)"desc", (Object)attribute.description());
        String desc = (String)ClassUtils.getAnnotationAttributeValue((Field)fieldOne, Attribute.class, (String)"description");
        Assertions.assertEquals((Object)"desc", (Object)desc);
        Entity entity = (Entity)ClassUtils.getAnnotationOnField((Field)fieldOne, Entity.class);
        Assertions.assertNull((Object)entity);
    }

    @Test
    public void testGetAnnotationOnMethod() {
        Attribute attribute = (Attribute)ClassUtils.getAnnotationOnMethod(TestObject.class, (String)"fieldThree", Attribute.class);
        Assertions.assertNotNull((Object)attribute);
        Assertions.assertEquals((Object)"Bert", (Object)attribute.displayName());
    }

    @Test
    public void testGetBytes() {
        TestEntity entity = new TestEntity();
        entity.setSomeBytes(new byte[]{1, 2, 3});
        byte[] bytes = ClassUtils.getBytes((Object)((Object)entity), (String)"someBytes");
        Assertions.assertNotNull((Object)bytes);
        Assertions.assertEquals((int)3, (int)bytes.length);
        ClassUtils.setBytes((byte[])new byte[]{2, 3, 4}, (Object)((Object)entity), (String)"someBytes");
        bytes = entity.getSomeBytes();
        Assertions.assertEquals((int)2, (int)bytes[0]);
        Assertions.assertEquals((int)3, (int)bytes[1]);
        Assertions.assertEquals((int)4, (int)bytes[2]);
        ClassUtils.setBytes(null, (Object)((Object)entity), (String)"someBytes");
        Assertions.assertNull((Object)entity.getSomeBytes());
    }

    @Test
    public void testGetField() {
        Assertions.assertNull((Object)ClassUtils.getField(TestObject.class, (String)"bogus"));
        Field fieldOne = ClassUtils.getField(TestObject.class, (String)"fieldOne");
        Assertions.assertEquals(Integer.class, fieldOne.getType());
        Field fieldTwo = ClassUtils.getField(TestObject.class, (String)"fieldTwo");
        Assertions.assertEquals(String.class, fieldTwo.getType());
    }

    @Test
    public void testGetFieldRecursive() {
        Field fieldOne = ClassUtils.getField(TestObject2.class, (String)"fieldOne");
        Assertions.assertEquals(Integer.class, fieldOne.getType());
    }

    @Test
    public void testGetFieldValue() {
        TestEntity entity = new TestEntity();
        entity.setAge(12L);
        Assertions.assertEquals((Object)12L, (Object)ClassUtils.getFieldValue((Object)((Object)entity), (String)"age"));
    }

    @Test
    public void testGetFieldValueAsString() {
        TestEntity entity = new TestEntity();
        entity.setAge(12L);
        Assertions.assertEquals((Object)"12", (Object)ClassUtils.getFieldValueAsString((Object)((Object)entity), (String)"age"));
        entity.setAge(null);
        Assertions.assertNull((Object)ClassUtils.getFieldValueAsString((Object)((Object)entity), (String)"age"));
    }

    @Test
    public void testGetFieldValueDoesntExists() {
        TestEntity entity = new TestEntity();
        entity.setAge(12L);
        Assertions.assertThrows(OCSRuntimeException.class, () -> ClassUtils.getFieldValue((Object)((Object)entity), (String)"age2"));
    }

    @Test
    public void testGetFieldValueRecursive() {
        TestEntity entity = new TestEntity();
        entity.setAge(12L);
        TestEntity2 entity2 = new TestEntity2();
        entity2.setTestEntity(entity);
        Assertions.assertEquals((Object)12L, (Object)ClassUtils.getFieldValue((Object)((Object)entity2), (String)"testEntity.age"));
    }

    @Test
    public void testGetGetterMethod() {
        Method method = ClassUtils.getGetterMethod(TestEntity.class, (String)"age");
        Assertions.assertNotNull((Object)method);
        Method method3 = ClassUtils.getGetterMethod(TestEntity.class, (String)"age2");
        Assertions.assertNull((Object)method3);
    }

    @Test
    public void testGetMaxLength() {
        Assertions.assertEquals((int)-1, (int)ClassUtils.getMaxLength(TestObject.class, (String)"fieldOne"));
        Assertions.assertEquals((int)123, (int)ClassUtils.getMaxLength(TestObject.class, (String)"fieldTwo"));
    }

    @Test
    public void testGetMethod() {
        Assertions.assertNull((Object)ClassUtils.getGetterMethod(TestObject.class, (String)"bogus"));
        Method method = ClassUtils.getGetterMethod(TestObject.class, (String)"fieldOne");
        Assertions.assertEquals(Integer.class, method.getReturnType());
        method = ClassUtils.getGetterMethod(TestObject.class, (String)"fieldTwo");
        Assertions.assertEquals(String.class, method.getReturnType());
    }

    @Test
    public void testGetResolvedType() {
        Class type = ClassUtils.getResolvedType(TestObject3.class, (String)"objects", (int[])new int[]{0});
        Assertions.assertNotNull((Object)type);
        Assertions.assertEquals(TestObject.class, (Object)type);
        type = ClassUtils.getResolvedType(TestObject3.class, (String)"indexedObjects", (int[])new int[]{0});
        Assertions.assertNotNull((Object)type);
        Assertions.assertEquals(Integer.class, (Object)type);
        type = ClassUtils.getResolvedType(TestObject3.class, (String)"indexedObjects", (int[])new int[]{1, 0});
        Assertions.assertNotNull((Object)type);
        Assertions.assertEquals(TestObject.class, (Object)type);
    }

    @Test
    public void testHasMethod() {
        TestEntity entity = new TestEntity();
        Assertions.assertTrue((boolean)ClassUtils.hasMethod((Object)((Object)entity), (String)"getAge"));
        Assertions.assertTrue((boolean)ClassUtils.hasMethod((Object)((Object)entity), (String)"getSomeBoolean"));
        Assertions.assertFalse((boolean)ClassUtils.hasMethod((Object)((Object)entity), (String)"getAGe"));
        Assertions.assertFalse((boolean)ClassUtils.hasMethod((Object)((Object)entity), (String)"age"));
    }

    @Test
    public void testSetFieldValue() {
        TestEntity entity = new TestEntity();
        ClassUtils.setFieldValue((Object)((Object)entity), (String)"age", (Object)12L);
        Assertions.assertEquals((long)12L, (long)entity.getAge());
    }

    @Test
    public void testSetFieldValueDoenstExist() {
        TestEntity entity = new TestEntity();
        Assertions.assertThrows(OCSRuntimeException.class, () -> ClassUtils.setFieldValue((Object)((Object)entity), (String)"age2", (Object)12L));
    }

    @Test
    public void testSetFieldValueRecursive() {
        TestEntity entity = new TestEntity();
        TestEntity2 entity2 = new TestEntity2();
        entity2.setTestEntity(entity);
        ClassUtils.setFieldValue((Object)((Object)entity2), (String)"testEntity.age", (Object)12L);
        Assertions.assertEquals((long)12L, (long)entity.getAge());
    }

    private class TestObject3 {
        private Map<Integer, List<TestObject>> indexedObjects;
        private List<TestObject> objects;

        private TestObject3() {
        }

        public Map<Integer, List<TestObject>> getIndexedObjects() {
            return this.indexedObjects;
        }

        public List<TestObject> getObjects() {
            return this.objects;
        }
    }

    private class TestObject2
    extends TestObject {
        private TestObject2() {
        }
    }

    private class TestObject {
        private byte[] fieldBytes = new byte[]{1, 2, 3};
        @Attribute(description="desc")
        private Integer fieldOne;
        @Size(max=123)
        private @Size(max=123) String fieldTwo;
        private NestedTestObject nested;

        private TestObject() {
        }

        public byte[] getFieldBytes() {
            return this.fieldBytes;
        }

        public Integer getFieldOne() {
            return this.fieldOne;
        }

        @Attribute(displayName="Bert")
        public String getFieldThree() {
            return null;
        }

        public String getFieldTwo() {
            return this.fieldTwo;
        }

        public NestedTestObject getNested() {
            return this.nested;
        }

        public void setFieldBytes(byte[] fieldBytes) {
            this.fieldBytes = fieldBytes;
        }

        public void setFieldOne(Integer fieldOne) {
            this.fieldOne = fieldOne;
        }

        public void setFieldTwo(String fieldTwo) {
            this.fieldTwo = fieldTwo;
        }

        public void setNested(NestedTestObject nested) {
            this.nested = nested;
        }
    }

    private class NestedTestObject {
        private String name;

        private NestedTestObject() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

