/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.utils;

import com.ocs.dynamo.utils.DateUtils;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class DateUtilsTest {
    @Test
    public void testCreateJava8Date() {
        Assertions.assertNull((Object)DateUtils.createJava8Date(LocalDate.class, null, (String)"dd-MM-yyyy"));
        Assertions.assertNull((Object)DateUtils.createJava8Date(Date.class, (String)"01-01-1980", (String)"dd-MM-yyyy"));
        LocalDate d = (LocalDate)DateUtils.createJava8Date(LocalDate.class, (String)"01-01-1980", (String)"dd-MM-yyyy");
        Assertions.assertEquals((Object)"1980-01-01", (Object)d.toString());
        LocalTime lt = (LocalTime)DateUtils.createJava8Date(LocalTime.class, (String)"14:15:16", (String)"HH:mm:ss");
        Assertions.assertEquals((Object)"14:15:16", (Object)lt.toString());
        LocalDateTime ldt = (LocalDateTime)DateUtils.createJava8Date(LocalDateTime.class, (String)"01-02-1981 14:15:16", (String)"dd-MM-yyyy HH:mm:ss");
        Assertions.assertEquals((Object)"1981-02-01T14:15:16", (Object)ldt.toString());
        ZonedDateTime zdt = (ZonedDateTime)DateUtils.createJava8Date(ZonedDateTime.class, (String)"01-02-1981 14:15:16+0100", (String)"dd-MM-yyyy HH:mm:ssZ");
        Assertions.assertEquals((Object)"1981-02-01T14:15:16+01:00", (Object)zdt.toString());
    }

    @Test
    public void testCreateLocalDate() {
        Assertions.assertNull((Object)DateUtils.createLocalDate(null));
        LocalDate ld = DateUtils.createLocalDate((String)"01012015");
        Assertions.assertEquals((Object)"2015-01-01", (Object)ld.toString());
        ld = DateUtils.createLocalDate((String)"29022012");
        Assertions.assertEquals((Object)"2012-02-29", (Object)ld.toString());
        ld = DateUtils.createLocalDate((String)"29-02-2012", (String)"dd-MM-yyyy");
        Assertions.assertEquals((Object)"2012-02-29", (Object)ld.toString());
    }

    @Test
    public void testCreateLocalDateTime() {
        Assertions.assertNull((Object)DateUtils.createLocalDateTime(null));
        LocalDateTime ld = DateUtils.createLocalDateTime((String)"01012015 121314");
        Assertions.assertEquals((Object)"2015-01-01T12:13:14", (Object)ld.toString());
        ld = DateUtils.createLocalDateTime((String)"29022012 151617");
        Assertions.assertEquals((Object)"2012-02-29T15:16:17", (Object)ld.toString());
        ld = DateUtils.createLocalDateTime((String)"29-02-2012 15:16:17", (String)"dd-MM-yyyy HH:mm:ss");
        Assertions.assertEquals((Object)"2012-02-29T15:16:17", (Object)ld.toString());
    }

    @Test
    public void testCreateLocalTime() {
        Assertions.assertNull((Object)DateUtils.createLocalTime(null));
        LocalTime lt = DateUtils.createLocalTime((String)"121314");
        Assertions.assertEquals((Object)"12:13:14", (Object)lt.toString());
        lt = DateUtils.createLocalTime((String)"151617");
        Assertions.assertEquals((Object)"15:16:17", (Object)lt.toString());
        lt = DateUtils.createLocalTime((String)"15:16:17", (String)"HH:mm:ss");
        Assertions.assertEquals((Object)"15:16:17", (Object)lt.toString());
    }

    @Test
    public void testCreateZonedDateTime() {
        Assertions.assertNull((Object)DateUtils.createZonedDateTime(null));
        ZonedDateTime zdt = DateUtils.createZonedDateTime((String)"01-01-2017 12:13:14+0100", (String)"dd-MM-yyyy HH:mm:ssZ");
        Assertions.assertEquals((Object)"2017-01-01T12:13:14+01:00", (Object)zdt.toString());
        zdt = DateUtils.createZonedDateTime((String)"01-01-2017 12:13:14Z", (String)"dd-MM-yyyy HH:mm:ssz");
        Assertions.assertEquals((Object)"2017-01-01T12:13:14Z", (Object)zdt.toString());
        zdt = DateUtils.createZonedDateTime((String)"01-01-2017 12:13:14+0000");
        Assertions.assertEquals((Object)"2017-01-01T12:13:14Z", (Object)zdt.toString());
    }

    @Test
    public void testFormatDate() {
        LocalDate date = DateUtils.createLocalDate((String)"01042015");
        Assertions.assertNull((Object)DateUtils.formatDate(null, (String)"dd-MM-yyyy"));
        Assertions.assertNull((Object)DateUtils.formatDate((LocalDate)date, null));
        Assertions.assertEquals((Object)"01-04-2015", (Object)DateUtils.formatDate((LocalDate)date, (String)"dd-MM-yyyy"));
        Assertions.assertEquals((Object)"01/04/15", (Object)DateUtils.formatDate((LocalDate)date, (String)"dd/MM/yy"));
    }

    @Test
    public void testFormatLocalDateTime() {
        LocalDateTime date = DateUtils.createLocalDateTime((String)"01122013 111415");
        Assertions.assertNull((Object)DateUtils.formatDateTime(null, (String)"dd-MM-yyyy"));
        Assertions.assertNull((Object)DateUtils.formatDateTime((LocalDateTime)date, null));
        Assertions.assertEquals((Object)"01-12-2013 11:14:15", (Object)DateUtils.formatDateTime((LocalDateTime)date, (String)"dd-MM-yyyy HH:mm:ss"));
        Assertions.assertEquals((Object)"01/12/2013 11:14:15", (Object)DateUtils.formatDateTime((LocalDateTime)date, (String)"dd/MM/yyyy HH:mm:ss"));
    }

    @Test
    @Disabled
    public void testFormatZonedDateTime() {
        ZonedDateTime date = DateUtils.createZonedDateTime((String)"01-12-2013 11:14:15+0000");
        Assertions.assertNull((Object)DateUtils.formatZonedDateTime(null, (String)"dd-MM-yyyy HH:mm:ssz", (ZoneId)ZoneId.of("Europe/London")));
        Assertions.assertNull((Object)DateUtils.formatZonedDateTime((ZonedDateTime)date, null, (ZoneId)ZoneId.of("Europe/London")));
        Assertions.assertEquals((Object)"01-12-2013 11:14:15+00:00", (Object)DateUtils.formatZonedDateTime((ZonedDateTime)date, (String)"dd-MM-yyyy HH:mm:ssz", (ZoneId)ZoneId.of("Europe/London")));
        Assertions.assertEquals((Object)"01-12-2013 12:14:15+01:00", (Object)DateUtils.formatZonedDateTime((ZonedDateTime)date, (String)"dd-MM-yyyy HH:mm:ssZ", (ZoneId)ZoneId.of("Europe/Amsterdam")));
    }

    @Test
    public void testFormatJava8Date() {
        Assertions.assertEquals((Object)"31-03-2014", (Object)DateUtils.formatJava8Date(LocalDate.class, (Object)DateUtils.createLocalDate((String)"31032014"), (String)"dd-MM-yyyy", (ZoneId)ZoneId.systemDefault()));
        Assertions.assertEquals((Object)"31-03-2014 05:06:07", (Object)DateUtils.formatJava8Date(LocalDateTime.class, (Object)DateUtils.createLocalDateTime((String)"31032014 050607"), (String)"dd-MM-yyyy HH:mm:ss", (ZoneId)ZoneId.systemDefault()));
        Assertions.assertEquals((Object)"05:06:07", (Object)DateUtils.formatJava8Date(LocalTime.class, (Object)DateUtils.createLocalTime((String)"050607"), (String)"HH:mm:ss", (ZoneId)ZoneId.systemDefault()));
    }

    @Test
    public void testFormatLocalTime() {
        LocalTime t = DateUtils.createLocalTime((String)"111415");
        Assertions.assertNull((Object)DateUtils.formatTime(null, (String)"dd-MM-yyyy"));
        Assertions.assertNull((Object)DateUtils.formatTime((LocalTime)t, null));
        Assertions.assertEquals((Object)"11:14:15", (Object)DateUtils.formatTime((LocalTime)t, (String)"HH:mm:ss"));
        Assertions.assertEquals((Object)"11.14.15", (Object)DateUtils.formatTime((LocalTime)t, (String)"HH.mm.ss"));
    }

    @Test
    public void testGetLastWeekOfYear() {
        Assertions.assertEquals((int)52, (int)DateUtils.getLastWeekOfYear((int)2017));
        Assertions.assertEquals((int)52, (int)DateUtils.getLastWeekOfYear((int)2016));
        Assertions.assertEquals((int)53, (int)DateUtils.getLastWeekOfYear((int)2015));
        Assertions.assertEquals((int)53, (int)DateUtils.getLastWeekOfYear((int)2009));
    }

    @Test
    public void testGetNextWeekCode() {
        Assertions.assertEquals((Object)"2015-02", (Object)DateUtils.getNextWeekCode((String)"2015-01"));
        Assertions.assertEquals((Object)"2015-03", (Object)DateUtils.getNextWeekCode((String)"2015-02"));
        Assertions.assertEquals((Object)"2015-53", (Object)DateUtils.getNextWeekCode((String)"2015-52"));
        Assertions.assertEquals((Object)"2016-01", (Object)DateUtils.getNextWeekCode((String)"2015-53"));
        Assertions.assertEquals((Object)"2017-01", (Object)DateUtils.getNextWeekCode((String)"2016-52"));
    }

    @Test
    public void testGetQuarter() {
        int quarter = DateUtils.getQuarter(null);
        Assertions.assertEquals((int)-1, (int)quarter);
        quarter = DateUtils.getQuarter((LocalDate)DateUtils.createLocalDate((String)"01012014"));
        Assertions.assertEquals((int)1, (int)quarter);
        quarter = DateUtils.getQuarter((LocalDate)DateUtils.createLocalDate((String)"01042014"));
        Assertions.assertEquals((int)2, (int)quarter);
        quarter = DateUtils.getQuarter((LocalDate)DateUtils.createLocalDate((String)"01072014"));
        Assertions.assertEquals((int)3, (int)quarter);
        quarter = DateUtils.getQuarter((LocalDate)DateUtils.createLocalDate((String)"01112014"));
        Assertions.assertEquals((int)4, (int)quarter);
        quarter = DateUtils.getQuarter((LocalDate)DateUtils.createLocalDate((String)"01012014"));
        Assertions.assertEquals((int)1, (int)quarter);
        quarter = DateUtils.getQuarter((LocalDate)DateUtils.createLocalDate((String)"31032014"));
        Assertions.assertEquals((int)1, (int)quarter);
        quarter = DateUtils.getQuarter((LocalDate)DateUtils.createLocalDate((String)"01042014"));
        Assertions.assertEquals((int)2, (int)quarter);
        quarter = DateUtils.getQuarter((LocalDate)DateUtils.createLocalDate((String)"01072014"));
        Assertions.assertEquals((int)3, (int)quarter);
        quarter = DateUtils.getQuarter((LocalDate)DateUtils.createLocalDate((String)"01112014"));
        Assertions.assertEquals((int)4, (int)quarter);
    }

    @Test
    public void testGetStartDateOfWeek() {
        Assertions.assertEquals((Object)DateUtils.createLocalDate((String)"30122013"), (Object)DateUtils.getStartDateOfWeek((String)"2014-01"));
        Assertions.assertEquals((Object)DateUtils.createLocalDate((String)"06012014"), (Object)DateUtils.getStartDateOfWeek((String)"2014-02"));
        Assertions.assertEquals((Object)DateUtils.createLocalDate((String)"29122014"), (Object)DateUtils.getStartDateOfWeek((String)"2015-01"));
        Assertions.assertEquals((Object)DateUtils.createLocalDate((String)"05012015"), (Object)DateUtils.getStartDateOfWeek((String)"2015-02"));
    }

    @Test
    public void testGetStartDayOfWeek() {
        LocalDate ld = DateUtils.getStartDateOfWeek((String)"2013-51");
        Assertions.assertEquals((Object)"2013-12-16", (Object)ld.toString());
        ld = DateUtils.getStartDateOfWeek((String)"2013-52");
        Assertions.assertEquals((Object)"2013-12-23", (Object)ld.toString());
        ld = DateUtils.getStartDateOfWeek((String)"2014-01");
        Assertions.assertEquals((Object)"2013-12-30", (Object)ld.toString());
        ld = DateUtils.getStartDateOfWeek((String)"2015-53");
        Assertions.assertEquals((Object)"2015-12-28", (Object)ld.toString());
    }

    @Test
    public void testIsJava8DateType() {
        Assertions.assertTrue((boolean)DateUtils.isJava8DateType(LocalDate.class));
        Assertions.assertTrue((boolean)DateUtils.isJava8DateType(LocalTime.class));
        Assertions.assertTrue((boolean)DateUtils.isJava8DateType(LocalDateTime.class));
        Assertions.assertFalse((boolean)DateUtils.isJava8DateType(Date.class));
        Assertions.assertFalse((boolean)DateUtils.isJava8DateType(java.sql.Date.class));
        Assertions.assertFalse((boolean)DateUtils.isJava8DateType(Timestamp.class));
    }

    @Test
    public void testIsValidWeekCode() {
        Assertions.assertTrue((boolean)DateUtils.isValidWeekCode(null));
        Assertions.assertFalse((boolean)DateUtils.isValidWeekCode((String)"abc"));
        Assertions.assertFalse((boolean)DateUtils.isValidWeekCode((String)"2013"));
        Assertions.assertFalse((boolean)DateUtils.isValidWeekCode((String)"2013-1"));
        Assertions.assertFalse((boolean)DateUtils.isValidWeekCode((String)"2013-00"));
        Assertions.assertTrue((boolean)DateUtils.isValidWeekCode((String)"2013-01"));
        Assertions.assertTrue((boolean)DateUtils.isValidWeekCode((String)"2013-02"));
        Assertions.assertTrue((boolean)DateUtils.isValidWeekCode((String)"2013-52"));
        Assertions.assertFalse((boolean)DateUtils.isValidWeekCode((String)"2013-53"));
        Assertions.assertFalse((boolean)DateUtils.isValidWeekCode((String)"2014-53"));
        Assertions.assertTrue((boolean)DateUtils.isValidWeekCode((String)"2015-53"));
        Assertions.assertFalse((boolean)DateUtils.isValidWeekCode((String)"2015-54"));
    }

    @Test
    public void testToWeekCode() {
        Assertions.assertEquals((Object)"2013-51", (Object)DateUtils.toWeekCode((LocalDate)DateUtils.createLocalDate((String)"16122013")));
        Assertions.assertEquals((Object)"2013-52", (Object)DateUtils.toWeekCode((LocalDate)DateUtils.createLocalDate((String)"23122013")));
        Assertions.assertEquals((Object)"2014-01", (Object)DateUtils.toWeekCode((LocalDate)DateUtils.createLocalDate((String)"30122013")));
        Assertions.assertEquals((Object)"2014-02", (Object)DateUtils.toWeekCode((LocalDate)DateUtils.createLocalDate((String)"06012014")));
        Assertions.assertEquals((Object)"2015-52", (Object)DateUtils.toWeekCode((LocalDate)DateUtils.createLocalDate((String)"21122015")));
        Assertions.assertEquals((Object)"2015-53", (Object)DateUtils.toWeekCode((LocalDate)DateUtils.createLocalDate((String)"28122015")));
        Assertions.assertEquals((Object)"2016-01", (Object)DateUtils.toWeekCode((LocalDate)DateUtils.createLocalDate((String)"04012016")));
        Assertions.assertEquals((Object)"2016-02", (Object)DateUtils.toWeekCode((LocalDate)DateUtils.createLocalDate((String)"11012016")));
    }
}

