/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.utils;

import com.google.common.collect.Lists;
import com.ocs.dynamo.domain.TestEntity;
import com.ocs.dynamo.domain.TestEntity2;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.domain.model.EntityModelFactory;
import com.ocs.dynamo.domain.model.impl.EntityModelFactoryImpl;
import com.ocs.dynamo.service.MessageService;
import com.ocs.dynamo.service.impl.MessageServiceImpl;
import com.ocs.dynamo.test.BaseMockitoTest;
import com.ocs.dynamo.test.MockUtil;
import com.ocs.dynamo.utils.EntityModelUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Locale;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;

public class EntityModelUtilsTest
extends BaseMockitoTest {
    private EntityModelFactory factory = new EntityModelFactoryImpl();
    @Mock
    private MessageService messageService = new MessageServiceImpl();

    @BeforeEach
    public void setUp() {
        MockUtil.mockMessageService((MessageService)this.messageService);
    }

    @Test
    public void testGetDisplayPropertyValue() {
        EntityModel model = this.factory.getModel(TestEntity.class);
        TestEntity entity = new TestEntity();
        entity.setName("test name");
        String value = EntityModelUtils.getDisplayPropertyValue((Object)((Object)entity), (EntityModel)model);
        Assertions.assertEquals((Object)"test name", (Object)value);
    }

    @Test
    public void testGetDisplayPropertyValue2() {
        EntityModel model = this.factory.getModel(TestEntity.class);
        TestEntity entity = new TestEntity();
        entity.setName("test name");
        TestEntity entity2 = new TestEntity();
        entity2.setName("test name 2");
        String value = EntityModelUtils.getDisplayPropertyValue((Collection)Lists.newArrayList((Object[])new TestEntity[]{entity, entity2}), (EntityModel)model, (int)2, (MessageService)this.messageService, (Locale)Locale.ENGLISH);
        Assertions.assertEquals((Object)"test name, test name 2", (Object)value);
    }

    @Test
    public void testGetDisplayPropertyValue3() {
        EntityModel model = this.factory.getModel(TestEntity.class);
        TestEntity entity = new TestEntity();
        entity.setName("test name");
        TestEntity entity2 = new TestEntity();
        entity2.setName("test name 2");
        TestEntity entity3 = new TestEntity();
        entity3.setName("test name 3");
        String value = EntityModelUtils.getDisplayPropertyValue((Collection)Lists.newArrayList((Object[])new TestEntity[]{entity, entity2, entity3}), (EntityModel)model, (int)2, (MessageService)this.messageService, (Locale)Locale.ENGLISH);
        Assertions.assertEquals((Object)"test name, test name 2, ocs.and.others", (Object)value);
    }

    @Test
    public void testCopySimpleAttributes() {
        TestEntity2 source = new TestEntity2();
        source.setId(1);
        source.setName("Name");
        source.setTestEntity(new TestEntity());
        TestEntity2 target = new TestEntity2();
        EntityModelUtils.copySimpleAttributes((Object)((Object)source), (Object)((Object)target), (EntityModel)this.factory.getModel(TestEntity2.class), (String[])new String[0]);
        Assertions.assertEquals((Object)"Name", (Object)target.getName());
        Assertions.assertNull((Object)target.getId());
        Assertions.assertNull((Object)((Object)target.getTestEntity()));
    }

    @Test
    public void testCopySimpleAttributes2() {
        TestEntity source = new TestEntity();
        source.setAge(12L);
        source.setName("Name");
        source.setDiscount(BigDecimal.valueOf(12.0));
        source.setSomeBoolean(Boolean.TRUE);
        source.setId(24);
        TestEntity target = new TestEntity();
        EntityModelUtils.copySimpleAttributes((Object)((Object)source), (Object)((Object)target), (EntityModel)this.factory.getModel(TestEntity.class), (String[])new String[0]);
        Assertions.assertEquals((Object)"Name", (Object)target.getName());
        Assertions.assertEquals((long)12L, (long)target.getAge());
        Assertions.assertEquals((double)12.0, (double)target.getDiscount().longValue(), (double)0.001);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)target.getSomeBoolean());
        Assertions.assertNull((Object)target.getId());
    }

    @Test
    public void testCopySimpleAttributes_Ignore() {
        TestEntity source = new TestEntity();
        source.setAge(12L);
        source.setName("Name");
        source.setDiscount(BigDecimal.valueOf(12.0));
        source.setSomeBoolean(Boolean.TRUE);
        source.setId(24);
        TestEntity target = new TestEntity();
        EntityModelUtils.copySimpleAttributes((Object)((Object)source), (Object)((Object)target), (EntityModel)this.factory.getModel(TestEntity.class), (String[])new String[]{"name"});
        Assertions.assertNull((Object)target.getName());
    }
}

