/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.utils;

import com.google.common.collect.Sets;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.TestEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.domain.model.EntityModelFactory;
import com.ocs.dynamo.domain.model.annotation.Attribute;
import com.ocs.dynamo.domain.model.annotation.Model;
import com.ocs.dynamo.domain.model.impl.EntityModelFactoryImpl;
import com.ocs.dynamo.service.MessageService;
import com.ocs.dynamo.test.MockUtil;
import com.ocs.dynamo.utils.DateUtils;
import com.ocs.dynamo.utils.FormatUtils;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.persistence.ElementCollection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
public class FormatUtilsTest {
    private static final Locale LOCALE = new Locale("nl");
    private EntityModelFactory factory = new EntityModelFactoryImpl();
    @Mock
    private MessageService messageService;

    @BeforeEach
    public void setUp() {
        MockUtil.mockMessageService((MessageService)this.messageService);
    }

    @Test
    public void testFormatPropertyValue() {
        EntityModel model = this.factory.getModel(TestEntity.class);
        Assertions.assertEquals((Object)"Bob", (Object)FormatUtils.formatPropertyValue((EntityModelFactory)this.factory, (MessageService)this.messageService, (AttributeModel)model.getAttributeModel("name"), (Object)"Bob", (String)", ", (Locale)LOCALE, (ZoneId)ZoneId.systemDefault()));
        Assertions.assertEquals((Object)"true", (Object)FormatUtils.formatPropertyValue((EntityModelFactory)this.factory, (MessageService)this.messageService, (AttributeModel)model.getAttributeModel("someBoolean"), (Object)true, (String)", ", (Locale)LOCALE, (ZoneId)ZoneId.systemDefault()));
        Assertions.assertEquals((Object)"false", (Object)FormatUtils.formatPropertyValue((EntityModelFactory)this.factory, (MessageService)this.messageService, (AttributeModel)model.getAttributeModel("someBoolean"), (Object)false, (String)", ", (Locale)LOCALE, (ZoneId)ZoneId.systemDefault()));
        Assertions.assertEquals((Object)"On", (Object)FormatUtils.formatPropertyValue((EntityModelFactory)this.factory, (MessageService)this.messageService, (AttributeModel)model.getAttributeModel("someBoolean2"), (Object)true, (String)", ", (Locale)LOCALE, (ZoneId)ZoneId.systemDefault()));
        Assertions.assertEquals((Object)"Off", (Object)FormatUtils.formatPropertyValue((EntityModelFactory)this.factory, (MessageService)this.messageService, (AttributeModel)model.getAttributeModel("someBoolean2"), (Object)false, (String)", ", (Locale)LOCALE, (ZoneId)ZoneId.systemDefault()));
        Assertions.assertEquals((Object)"A", (Object)FormatUtils.formatPropertyValue((EntityModelFactory)this.factory, (MessageService)this.messageService, (AttributeModel)model.getAttributeModel("someEnum"), (Object)((Object)TestEntity.TestEnum.A), (String)", ", (Locale)LOCALE, (ZoneId)ZoneId.systemDefault()));
        Assertions.assertEquals((Object)"12,40", (Object)FormatUtils.formatPropertyValue((EntityModelFactory)this.factory, (MessageService)this.messageService, (AttributeModel)model.getAttributeModel("discount"), (Object)BigDecimal.valueOf(12.4), (String)", ", (Locale)LOCALE, (ZoneId)ZoneId.systemDefault()));
        Assertions.assertEquals((Object)"1.042,40", (Object)FormatUtils.formatPropertyValue((EntityModelFactory)this.factory, (MessageService)this.messageService, (AttributeModel)model.getAttributeModel("discount"), (Object)BigDecimal.valueOf(1042.4), (String)", ", (Locale)LOCALE, (ZoneId)ZoneId.systemDefault()));
        Assertions.assertEquals((Object)"1.042,40%", (Object)FormatUtils.formatPropertyValue((EntityModelFactory)this.factory, (MessageService)this.messageService, (AttributeModel)model.getAttributeModel("rate"), (Object)BigDecimal.valueOf(1042.4), (String)", ", (Locale)LOCALE, (ZoneId)ZoneId.systemDefault()));
        Assertions.assertEquals((Object)"1,000.40", (Object)FormatUtils.formatPropertyValue((EntityModelFactory)this.factory, (MessageService)this.messageService, (AttributeModel)model.getAttributeModel("discount"), (Object)BigDecimal.valueOf(1000.4), (String)", ", (Locale)Locale.US, (ZoneId)ZoneId.systemDefault()));
        Assertions.assertEquals((Object)"12/10/2015", (Object)FormatUtils.formatPropertyValue((EntityModelFactory)this.factory, (MessageService)this.messageService, (AttributeModel)model.getAttributeModel("birthDate"), (Object)DateUtils.createLocalDate((String)"12102015"), (String)", ", (Locale)LOCALE, (ZoneId)ZoneId.systemDefault()));
        Assertions.assertEquals((Object)"2015-42", (Object)FormatUtils.formatPropertyValue((EntityModelFactory)this.factory, (MessageService)this.messageService, (AttributeModel)model.getAttributeModel("birthWeek"), (Object)DateUtils.createLocalDate((String)"12102015"), (String)", ", (Locale)LOCALE, (ZoneId)ZoneId.systemDefault()));
        Assertions.assertEquals((Object)"1.234", (Object)FormatUtils.formatPropertyValue((EntityModelFactory)this.factory, (MessageService)this.messageService, (AttributeModel)model.getAttributeModel("someInt"), (Object)1234, (String)", ", (Locale)LOCALE, (ZoneId)ZoneId.systemDefault()));
        Assertions.assertEquals((Object)"1.234", (Object)FormatUtils.formatPropertyValue((EntityModelFactory)this.factory, (MessageService)this.messageService, (AttributeModel)model.getAttributeModel("age"), (Object)1234L, (String)", ", (Locale)LOCALE, (ZoneId)ZoneId.systemDefault()));
    }

    @Test
    public void testFormatMasterEntity() {
        EntityModel model = this.factory.getModel(Entity2.class);
        AttributeModel at = model.getAttributeModel("entity1");
        Assertions.assertNotNull((Object)at);
        Entity1 e1 = new Entity1();
        e1.setId(1);
        e1.setName("some name");
        Entity2 e2 = new Entity2();
        e2.setId(2);
        e2.setSize(2);
        e2.setEntity1(e1);
        String result = FormatUtils.formatPropertyValue((EntityModelFactory)this.factory, (MessageService)this.messageService, (AttributeModel)model.getAttributeModel("entity1"), (Object)((Object)e1), (String)", ", (Locale)LOCALE, (ZoneId)ZoneId.systemDefault());
        Assertions.assertEquals((Object)"some name", (Object)result);
    }

    @Test
    public void testFormatEntityCollection() {
        Entity1 t1 = new Entity1();
        t1.setId(1);
        t1.setName("a1");
        Entity1 t2 = new Entity1();
        t2.setId(2);
        t2.setName("a2");
        Entity1 t3 = new Entity1();
        t3.setId(3);
        t3.setName("a3");
        Entity3 e3 = new Entity3();
        e3.setEntities(Sets.newHashSet((Object[])new Entity1[]{t1, t2, t3}));
        String result = FormatUtils.formatEntityCollection((EntityModelFactory)this.factory, null, e3.getEntities(), (String)", ", (Locale)LOCALE, (String)"");
        Assertions.assertEquals((Object)"a1, a2, a3", (Object)result);
    }

    @Test
    public void testFormatEntityCollection_ElementCollection() {
        Entity4 e = new Entity4();
        e.setDecimals(Set.of(BigDecimal.valueOf(5L), BigDecimal.valueOf(6L)));
        String result = FormatUtils.formatEntityCollection((EntityModelFactory)this.factory, (AttributeModel)this.factory.getModel(Entity4.class).getAttributeModel("decimals"), e.getDecimals(), (String)",", (Locale)LOCALE, (String)"");
        Assertions.assertTrue((boolean)result.contains("5,00"));
        Assertions.assertTrue((boolean)result.contains("6,00"));
    }

    @Test
    public void testFormatEntityCollection_ElementCollectionPercentage() {
        Entity4 e = new Entity4();
        e.setDecimalPercentages(Set.of(BigDecimal.valueOf(5L), BigDecimal.valueOf(6L)));
        String result = FormatUtils.formatEntityCollection((EntityModelFactory)this.factory, (AttributeModel)this.factory.getModel(Entity4.class).getAttributeModel("decimalPercentages"), e.getDecimalPercentages(), (String)",", (Locale)LOCALE, (String)"");
        Assertions.assertTrue((boolean)result.contains("5,00%"));
        Assertions.assertTrue((boolean)result.contains("6,00%"));
    }

    class Entity4
    extends AbstractEntity<Integer> {
        private static final long serialVersionUID = -6617462805267353476L;
        private Integer id;
        @ElementCollection
        private Set<BigDecimal> decimals = new HashSet<BigDecimal>();
        @ElementCollection
        @Attribute(percentage=true)
        private Set<BigDecimal> decimalPercentages = new HashSet<BigDecimal>();

        Entity4() {
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public Set<BigDecimal> getDecimals() {
            return this.decimals;
        }

        public void setDecimals(Set<BigDecimal> decimals) {
            this.decimals = decimals;
        }

        public Set<BigDecimal> getDecimalPercentages() {
            return this.decimalPercentages;
        }

        public void setDecimalPercentages(Set<BigDecimal> decimalPercentages) {
            this.decimalPercentages = decimalPercentages;
        }
    }

    class Entity3
    extends AbstractEntity<Integer> {
        private static final long serialVersionUID = -6793879377561210713L;
        private Integer id;
        private Set<Entity1> entities = new HashSet<Entity1>();

        Entity3() {
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public Set<Entity1> getEntities() {
            return this.entities;
        }

        public void setEntities(Set<Entity1> entities) {
            this.entities = entities;
        }
    }

    class Entity2
    extends AbstractEntity<Integer> {
        private static final long serialVersionUID = -6048664928800386501L;
        private Integer id;
        private Integer size;
        private Entity1 entity1;

        Entity2() {
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public Entity1 getEntity1() {
            return this.entity1;
        }

        public void setEntity1(Entity1 entity1) {
            this.entity1 = entity1;
        }
    }

    @Model(displayProperty="name")
    class Entity1
    extends AbstractEntity<Integer> {
        private static final long serialVersionUID = -706695912687382812L;
        private Integer id;
        private String name;

        Entity1() {
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

