/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.utils;

import com.ocs.dynamo.test.BaseMockitoTest;
import com.ocs.dynamo.utils.NumberUtils;
import java.math.BigDecimal;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NumberUtilsTest
extends BaseMockitoTest {
    @Test
    public void testIsNumeric() {
        Assertions.assertFalse((boolean)NumberUtils.isNumeric(String.class));
        Assertions.assertTrue((boolean)NumberUtils.isNumeric(Byte.TYPE));
        Assertions.assertTrue((boolean)NumberUtils.isNumeric(Integer.TYPE));
        Assertions.assertTrue((boolean)NumberUtils.isNumeric(Long.TYPE));
        Assertions.assertTrue((boolean)NumberUtils.isNumeric(Short.TYPE));
        Assertions.assertTrue((boolean)NumberUtils.isNumeric(Double.TYPE));
        Assertions.assertTrue((boolean)NumberUtils.isNumeric(Float.TYPE));
        Assertions.assertTrue((boolean)NumberUtils.isNumeric(BigDecimal.class));
        Assertions.assertTrue((boolean)NumberUtils.isNumeric(Integer.class));
        Assertions.assertTrue((boolean)NumberUtils.isNumeric(Long.class));
    }

    @Test
    public void testFormat() {
        Assertions.assertEquals((Object)"Test", (Object)NumberUtils.format((Object)"Test"));
        Assertions.assertEquals((Object)"1234", (Object)NumberUtils.format((Object)1234L));
        Assertions.assertEquals((Object)this.formatNumber("4,45"), (Object)NumberUtils.format((Object)4.45));
        Assertions.assertEquals((Object)this.formatNumber("4,23"), (Object)NumberUtils.format((Object)BigDecimal.valueOf(4.23)));
        Assertions.assertEquals((Object)this.formatNumber("2,04"), (Object)NumberUtils.format((Object)Float.valueOf(2.04f)));
    }

    @Test
    public void testIsLong() {
        Assertions.assertTrue((boolean)NumberUtils.isLong(Long.class));
        Assertions.assertTrue((boolean)NumberUtils.isLong(Long.TYPE));
        Assertions.assertFalse((boolean)NumberUtils.isLong(Integer.class));
    }

    @Test
    public void testIsLong2() {
        Assertions.assertFalse((boolean)NumberUtils.isLong(null));
        Assertions.assertTrue((boolean)NumberUtils.isLong((Object)1L));
        Assertions.assertTrue((boolean)NumberUtils.isLong((Object)Long.valueOf("123")));
        Assertions.assertFalse((boolean)NumberUtils.isLong((Object)new Object()));
        Assertions.assertFalse((boolean)NumberUtils.isLong((Object)12345));
    }

    @Test
    public void testIsInteger() {
        Assertions.assertTrue((boolean)NumberUtils.isInteger(Integer.class));
        Assertions.assertTrue((boolean)NumberUtils.isInteger(Integer.TYPE));
        Assertions.assertFalse((boolean)NumberUtils.isInteger(Long.class));
    }

    @Test
    public void testIsInteger2() {
        Assertions.assertTrue((boolean)NumberUtils.isInteger((Object)4));
        Assertions.assertTrue((boolean)NumberUtils.isInteger((Object)12));
        Assertions.assertFalse((boolean)NumberUtils.isInteger((Object)5L));
        Assertions.assertFalse((boolean)NumberUtils.isInteger(null));
    }

    @Test
    public void testIsDouble() {
        Assertions.assertTrue((boolean)NumberUtils.isDouble(Double.TYPE));
        Assertions.assertTrue((boolean)NumberUtils.isDouble(Double.class));
    }

    @Test
    public void testIsDouble2() {
        Assertions.assertTrue((boolean)NumberUtils.isDouble((Object)4.2));
        Assertions.assertTrue((boolean)NumberUtils.isDouble((Object)12.13));
        Assertions.assertFalse((boolean)NumberUtils.isDouble((Object)5L));
        Assertions.assertFalse((boolean)NumberUtils.isDouble(null));
    }
}

