/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.utils;

import com.ocs.dynamo.domain.TestEntity;
import com.ocs.dynamo.utils.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringUtilsTest {
    @Test
    public void testCamelCaseToHumanFriendly() {
        Assertions.assertNull((Object)StringUtils.camelCaseToHumanFriendly(null, (boolean)true));
        Assertions.assertEquals((Object)"Slightly Complex", (Object)StringUtils.camelCaseToHumanFriendly((String)"slightlyComplex", (boolean)true));
        Assertions.assertEquals((Object)"Simple", (Object)StringUtils.camelCaseToHumanFriendly((String)"simple", (boolean)true));
        Assertions.assertEquals((Object)"Multiple Words Camel", (Object)StringUtils.camelCaseToHumanFriendly((String)"multiple wordsCamel", (boolean)true));
        Assertions.assertEquals((Object)"Slightly complex", (Object)StringUtils.camelCaseToHumanFriendly((String)"slightlyComplex", (boolean)false));
        Assertions.assertEquals((Object)"Simple", (Object)StringUtils.camelCaseToHumanFriendly((String)"simple", (boolean)false));
        Assertions.assertEquals((Object)"Multiple words camel", (Object)StringUtils.camelCaseToHumanFriendly((String)"multiple wordsCamel", (boolean)false));
    }

    @Test
    public void testRestrictToMaxFieldLength() {
        Assertions.assertNull((Object)StringUtils.restrictToMaxFieldLength(null, TestEntity.class, (String)"name"));
        String result = StringUtils.restrictToMaxFieldLength((String)"longlonglonglonglonglonglonglonglonglonglong", TestEntity.class, (String)"name");
        Assertions.assertEquals((int)25, (int)result.length());
        result = StringUtils.restrictToMaxFieldLength((String)"shortshort", TestEntity.class, (String)"name");
        Assertions.assertEquals((int)10, (int)result.length());
        result = StringUtils.restrictToMaxFieldLength((String)"longlonglonglonglonglonglonglonglonglonglong", TestEntity.class, (String)"somestring");
        Assertions.assertEquals((int)44, (int)result.length());
    }

    @Test
    public void testIsValidEmail() {
        Assertions.assertFalse((boolean)StringUtils.isValidEmail((String)" "));
        Assertions.assertFalse((boolean)StringUtils.isValidEmail((String)""));
        Assertions.assertFalse((boolean)StringUtils.isValidEmail((String)"@"));
        Assertions.assertTrue((boolean)StringUtils.isValidEmail((String)"a@b.com"));
        Assertions.assertFalse((boolean)StringUtils.isValidEmail((String)"a@b"));
        Assertions.assertTrue((boolean)StringUtils.isValidEmail((String)"kevin@opencirclesolutions.nl"));
    }

    @Test
    public void testPrependProtocol() {
        Assertions.assertEquals((Object)"http://www.google.nl", (Object)StringUtils.prependProtocol((String)"http://www.google.nl"));
        Assertions.assertEquals((Object)"http://www.google.nl", (Object)StringUtils.prependProtocol((String)"www.google.nl"));
    }
}

