/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.importer.impl;

import com.ocs.dynamo.exception.OCSImportException;
import com.ocs.dynamo.importer.impl.BaseTextImporter;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.input.CharSequenceReader;

public class BaseFixedLengthImporter
extends BaseTextImporter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int countRows(byte[] bytes, int sheetIndex) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytes)));){
            int count = 0;
            String line = reader.readLine();
            while (line != null) {
                ++count;
                line = reader.readLine();
            }
            int n = count;
            return n;
        }
        catch (IOException ex) {
            throw new OCSImportException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected List<Integer> parseFieldLengths(String fieldLengths) {
        try {
            String[] lengths = fieldLengths.split(",");
            ArrayList<Integer> result = new ArrayList<Integer>();
            for (String s : lengths) {
                Integer len = Integer.valueOf(s);
                result.add(len);
            }
            return result;
        }
        catch (NumberFormatException ex) {
            throw new OCSImportException("Invalid field length entered", (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<String[]> readFixedLengthFile(byte[] bytes, List<Integer> fieldLengths) {
        try (BufferedReader reader = new BufferedReader((Reader)new CharSequenceReader((CharSequence)new String(bytes, "UTF-8")));){
            ArrayList<String[]> result = new ArrayList<String[]>();
            String line = reader.readLine();
            while (true) {
                Iterator<Integer> iterator;
                int start;
                ArrayList<String> temp;
                if (line != null) {
                    temp = new ArrayList<String>();
                    start = 0;
                    iterator = fieldLengths.iterator();
                } else {
                    ArrayList<String[]> arrayList = result;
                    return arrayList;
                }
                while (iterator.hasNext()) {
                    String field;
                    Integer len = iterator.next();
                    if (start + len <= line.length()) {
                        field = line.substring(start, start + len);
                        temp.add(field.trim());
                    } else if (start <= line.length()) {
                        field = line.substring(start, line.length());
                        temp.add(field.trim());
                    }
                    start += len.intValue();
                }
                result.add(temp.toArray(new String[0]));
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            throw new OCSImportException(ex.getMessage(), (Throwable)ex);
        }
    }
}

