/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.importer.impl;

import com.ocs.dynamo.exception.OCSImportException;
import com.ocs.dynamo.importer.ImportField;
import com.ocs.dynamo.importer.dto.AbstractDTO;
import com.ocs.dynamo.utils.ClassUtils;
import com.ocs.dynamo.utils.NumberUtils;
import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

public abstract class BaseImporter<R, U> {
    private static final double PERCENTAGE_FACTOR = 100.0;

    public abstract int countRows(byte[] var1, int var2);

    protected abstract Boolean getBooleanValueWithDefault(U var1, ImportField var2);

    protected abstract Date getDateValueWithDefault(U var1, ImportField var2);

    protected Object getFieldValue(PropertyDescriptor d, U unit, ImportField field) {
        Object obj = null;
        if (String.class.equals(d.getPropertyType())) {
            String value = this.getStringValueWithDefault(unit, field);
            if (value != null) {
                value = value.trim();
            }
            obj = StringUtils.isEmpty((Object)value) ? null : value;
        } else if (d.getPropertyType().isEnum()) {
            String value = this.getStringValueWithDefault(unit, field);
            if (value != null) {
                value = value.trim();
                try {
                    Class<Enum> enumType = d.getPropertyType().asSubclass(Enum.class);
                    obj = Enum.valueOf(enumType, value.toUpperCase());
                }
                catch (IllegalArgumentException ex) {
                    throw new OCSImportException("Value " + value + " cannot be translated to an enumeration value", (Throwable)ex);
                }
            }
        } else if (this.isNumeric(d.getPropertyType())) {
            Double value = this.getNumericValueWithDefault(unit, field);
            if (value != null) {
                if (field.percentage() && this.isPercentageCorrectionSupported()) {
                    value = 100.0 * value;
                }
                if (field.cannotBeNegative() && value < 0.0) {
                    throw new OCSImportException("Negative value " + value + " found for field '" + d.getName() + "'");
                }
                BigDecimal rounded = BigDecimal.valueOf(value).setScale(0, RoundingMode.HALF_UP);
                Class<?> pType = d.getPropertyType();
                if (NumberUtils.isInteger(pType)) {
                    obj = rounded.intValue();
                } else if (NumberUtils.isLong(pType)) {
                    obj = rounded.longValue();
                } else if (NumberUtils.isFloat(pType)) {
                    obj = Float.valueOf(value.floatValue());
                } else if (BigDecimal.class.equals(pType)) {
                    obj = BigDecimal.valueOf(value);
                }
            }
        } else {
            if (Boolean.class.isAssignableFrom(d.getPropertyType())) {
                return this.getBooleanValueWithDefault(unit, field);
            }
            if (Date.class.isAssignableFrom(d.getPropertyType())) {
                return this.getDateValueWithDefault(unit, field);
            }
        }
        return obj;
    }

    protected abstract Double getNumericValueWithDefault(U var1, ImportField var2);

    protected abstract String getStringValueWithDefault(U var1, ImportField var2);

    protected abstract U getUnit(R var1, ImportField var2);

    private boolean isNumeric(Class<?> clazz) {
        return Number.class.isAssignableFrom(clazz) || Integer.TYPE.equals(clazz) || Long.TYPE.equals(clazz) || Double.TYPE.equals(clazz) || Float.TYPE.equals(clazz);
    }

    public abstract boolean isPercentageCorrectionSupported();

    protected abstract boolean isWithinRange(R var1, ImportField var2);

    public <T extends AbstractDTO> T processRow(int rowNum, R row, Class<T> clazz) {
        PropertyDescriptor[] descriptors;
        AbstractDTO t = (AbstractDTO)ClassUtils.instantiateClass(clazz, (Object[])new Object[0]);
        t.setRowNum(rowNum);
        for (PropertyDescriptor d : descriptors = BeanUtils.getPropertyDescriptors(clazz)) {
            ImportField field = (ImportField)ClassUtils.getAnnotation(clazz, (String)d.getName(), ImportField.class);
            if (field == null) continue;
            if (this.isWithinRange(row, field)) {
                U unit = this.getUnit(row, field);
                Object obj = this.getFieldValue(d, unit, field);
                if (obj != null) {
                    ClassUtils.setFieldValue((Object)t, (String)d.getName(), (Object)obj);
                    continue;
                }
                if (!field.required()) continue;
                throw new OCSImportException("Required value for field '" + d.getName() + "' is missing");
            }
            throw new OCSImportException("Row doesn't have enough columns");
        }
        return (T)t;
    }
}

