/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.importer.impl;

import com.ocs.dynamo.exception.OCSImportException;
import com.ocs.dynamo.importer.ImportField;
import com.ocs.dynamo.importer.impl.BaseImporter;
import com.ocs.dynamo.util.SystemPropertyUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.util.StringUtils;

public abstract class BaseTextImporter
extends BaseImporter<String[], String> {
    protected Boolean getBooleanValue(String unit) {
        String value = unit;
        if (StringUtils.isEmpty((Object)value)) {
            return Boolean.FALSE;
        }
        return Boolean.valueOf(value);
    }

    @Override
    protected Boolean getBooleanValueWithDefault(String unit, ImportField field) {
        Boolean result = this.getBooleanValue(unit);
        if (result == null && !StringUtils.isEmpty((Object)field.defaultValue())) {
            return Boolean.valueOf(field.defaultValue());
        }
        return result;
    }

    protected Date getDateValue(String unit) {
        String value = unit;
        if (!StringUtils.isEmpty((Object)value)) {
            try {
                return new SimpleDateFormat(SystemPropertyUtils.getDefaultDateFormat()).parse(value);
            }
            catch (ParseException e) {
                throw new OCSImportException(value + " cannot be converted to a date");
            }
        }
        return null;
    }

    @Override
    protected Date getDateValueWithDefault(String unit, ImportField field) {
        Date value = this.getDateValue(unit);
        if (value == null && field.defaultValue() != null) {
            try {
                return new SimpleDateFormat(SystemPropertyUtils.getDefaultDateFormat()).parse(field.defaultValue());
            }
            catch (ParseException e) {
                throw new OCSImportException(field.defaultValue() + " cannot be converted to a date");
            }
        }
        return value;
    }

    protected Double getNumericValue(String unit) {
        String value = unit;
        if (StringUtils.isEmpty((Object)value)) {
            return null;
        }
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException ex) {
            throw new OCSImportException(value + " cannot be converted to a number");
        }
    }

    @Override
    protected Double getNumericValueWithDefault(String unit, ImportField field) {
        Double value = this.getNumericValue(unit);
        if (value == null && !StringUtils.isEmpty((Object)field.defaultValue())) {
            value = Double.valueOf(field.defaultValue());
        }
        return value;
    }

    @Override
    protected String getStringValueWithDefault(String unit, ImportField field) {
        String result = unit;
        if (StringUtils.isEmpty((Object)result) && !StringUtils.isEmpty((Object)field.defaultValue())) {
            result = field.defaultValue();
        }
        return result;
    }

    @Override
    protected String getUnit(String[] row, ImportField field) {
        return row[field.index()];
    }

    @Override
    public boolean isPercentageCorrectionSupported() {
        return false;
    }

    @Override
    protected boolean isWithinRange(String[] row, ImportField field) {
        return field.index() < row.length;
    }
}

