/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.importer.impl;

import com.monitorjbl.xlsx.StreamingReader;
import com.ocs.dynamo.exception.OCSImportException;
import com.ocs.dynamo.exception.OCSRuntimeException;
import com.ocs.dynamo.exception.OCSValidationException;
import com.ocs.dynamo.importer.ImportField;
import com.ocs.dynamo.importer.dto.AbstractDTO;
import com.ocs.dynamo.importer.impl.BaseImporter;
import com.ocs.dynamo.util.SystemPropertyUtils;
import com.ocs.dynamo.utils.ClassUtils;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

public class BaseXlsImporter
extends BaseImporter<Row, Cell> {
    private static final int CACHE_SIZE = 500;

    protected boolean containsStringValue(Row row, String value) {
        if (row == null || !row.iterator().hasNext()) {
            return false;
        }
        boolean found = false;
        for (int i = row.getFirstCellNum(); !found && i < row.getLastCellNum(); ++i) {
            if (row.getCell(i) == null) continue;
            try {
                found = value.equalsIgnoreCase(row.getCell(i).getStringCellValue());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return found;
    }

    @Override
    public int countRows(byte[] bytes, int sheetIndex) {
        int count = 0;
        try (StreamingReader reader = this.createReader(bytes, sheetIndex, 500);){
            Row r;
            Iterator iterator = reader.iterator();
            while (iterator.hasNext() && !this.isRowEmpty(r = (Row)iterator.next())) {
                ++count;
            }
            int n = count;
            return n;
        }
    }

    public StreamingReader createReader(byte[] bytes, int sheetIndex, int cacheSize) {
        return StreamingReader.builder().rowCacheSize(cacheSize).sheetIndex(sheetIndex).read((InputStream)new ByteArrayInputStream(bytes));
    }

    public Workbook createWorkbook(byte[] bytes) {
        HSSFWorkbook workbook = null;
        try {
            workbook = new HSSFWorkbook((InputStream)new ByteArrayInputStream(bytes));
        }
        catch (OfficeXmlFileException ex) {
            try {
                workbook = new XSSFWorkbook((InputStream)new ByteArrayInputStream(bytes));
            }
            catch (IOException e) {
                throw new OCSRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
        catch (IOException e) {
            throw new OCSRuntimeException(e.getMessage(), (Throwable)e);
        }
        return workbook;
    }

    protected Boolean getBooleanValue(Cell cell) {
        if (cell != null && 4 == cell.getCellType()) {
            return cell.getBooleanCellValue();
        }
        if (cell != null && 1 == cell.getCellType()) {
            return Boolean.valueOf(cell.getStringCellValue());
        }
        return Boolean.FALSE;
    }

    @Override
    protected Boolean getBooleanValueWithDefault(Cell unit, ImportField field) {
        Boolean b = this.getBooleanValue(unit);
        if (b == null && field.defaultValue() != null) {
            return Boolean.valueOf(field.defaultValue());
        }
        return b;
    }

    protected Date getDateValue(Cell cell) {
        if (cell != null && (0 == cell.getCellType() || 3 == cell.getCellType())) {
            try {
                return cell.getDateCellValue();
            }
            catch (NullPointerException nex) {
                return null;
            }
        }
        return null;
    }

    @Override
    protected Date getDateValueWithDefault(Cell cell, ImportField field) {
        Date value = this.getDateValue(cell);
        if (value == null && field.defaultValue() != null && !"".equals(field.defaultValue())) {
            try {
                value = new SimpleDateFormat(SystemPropertyUtils.getDefaultDateFormat()).parse(field.defaultValue());
            }
            catch (ParseException e) {
                throw new OCSImportException(field.defaultValue() + " cannot be converted to a date");
            }
        }
        return value;
    }

    protected Double getNumericValue(Cell cell) {
        if (cell != null && (0 == cell.getCellType() || 3 == cell.getCellType())) {
            try {
                return cell.getNumericCellValue();
            }
            catch (NullPointerException nex) {
                return null;
            }
            catch (Exception ex) {
                throw new OCSImportException("Found an invalid numeric value: " + cell.getStringCellValue(), (Throwable)ex);
            }
        }
        if (cell != null && 1 == cell.getCellType() && !StringUtils.isEmpty((Object)cell.getStringCellValue().trim())) {
            throw new OCSImportException("Found an invalid numeric value: " + cell.getStringCellValue());
        }
        return null;
    }

    @Override
    public Double getNumericValueWithDefault(Cell cell, ImportField field) {
        Double value = this.getNumericValue(cell);
        if (value == null && !StringUtils.isEmpty((Object)field.defaultValue())) {
            value = Double.valueOf(field.defaultValue());
        }
        return value;
    }

    protected Date getRequiredDateValue(Cell cell) {
        Date result = this.getDateValue(cell);
        if (result == null) {
            throw new OCSValidationException("Required value not set: " + cell.getColumnIndex());
        }
        return result;
    }

    protected Double getRequiredNumericValue(Cell cell) {
        Double result = this.getNumericValue(cell);
        if (result == null) {
            throw new OCSValidationException("Required value not set: " + cell.getColumnIndex());
        }
        return result;
    }

    protected String getRequiredStringValue(Cell cell) {
        String result = this.getStringValue(cell);
        if (result == null) {
            throw new OCSValidationException("Required value not set: " + cell.getColumnIndex());
        }
        return result;
    }

    protected String getStringValue(Cell cell) {
        if (cell != null && (1 == cell.getCellType() || cell.getCellType() == 3)) {
            String value = cell.getStringCellValue();
            return value == null ? null : value.trim();
        }
        if (cell != null && 0 == cell.getCellType()) {
            Double d = cell.getNumericCellValue();
            return d == null ? null : Long.toString(d.longValue());
        }
        return null;
    }

    @Override
    protected String getStringValueWithDefault(Cell cell, ImportField field) {
        String value = this.getStringValue(cell);
        if (StringUtils.isEmpty((Object)value) && !StringUtils.isEmpty((Object)field.defaultValue())) {
            value = field.defaultValue();
        }
        return value;
    }

    @Override
    protected Cell getUnit(Row row, ImportField field) {
        return row.getCell(row.getFirstCellNum() + field.index());
    }

    @Override
    public boolean isPercentageCorrectionSupported() {
        return true;
    }

    public boolean isRowEmpty(Row row) {
        if (row == null || row.getFirstCellNum() < 0) {
            return true;
        }
        for (Cell next : row) {
            String value = next.getStringCellValue();
            if (StringUtils.isEmpty((Object)value)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean isWithinRange(Row row, ImportField field) {
        return row.getFirstCellNum() + field.index() < row.getLastCellNum();
    }

    public <T extends AbstractDTO> T processRows(Sheet sheet, int firstRowIndex, int colIndex, Class<T> clazz) {
        AbstractDTO t = (AbstractDTO)ClassUtils.instantiateClass(clazz, (Object[])new Object[0]);
        String firstCellValue = null;
        try {
            firstCellValue = sheet.getRow(firstRowIndex).getCell(colIndex).getStringCellValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (firstCellValue != null && !"".equals(firstCellValue.toString())) {
            PropertyDescriptor[] descriptors;
            for (PropertyDescriptor d : descriptors = BeanUtils.getPropertyDescriptors(clazz)) {
                ImportField field = (ImportField)ClassUtils.getAnnotation(clazz, (String)d.getName(), ImportField.class);
                if (field == null) continue;
                int rowNum = firstRowIndex + field.index();
                if (rowNum <= sheet.getLastRowNum()) {
                    Row row = sheet.getRow(rowNum);
                    Cell unit = row.getCell(colIndex);
                    Object obj = this.getFieldValue(d, unit, field);
                    if (obj != null) {
                        ClassUtils.setFieldValue((Object)t, (String)d.getName(), (Object)obj);
                        continue;
                    }
                    if (!field.required()) continue;
                    throw new OCSImportException("Required value for field '" + d.getName() + "' is missing");
                }
                throw new OCSImportException("Input doesn't have enoug rows: row " + rowNum + " does not exist");
            }
        }
        return (T)t;
    }
}

