/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.importer.impl;

import com.ocs.dynamo.exception.OCSImportException;
import com.ocs.dynamo.importer.dto.AbstractDTO;
import com.ocs.dynamo.importer.impl.BaseXlsImporter;
import com.ocs.dynamo.service.MessageService;
import com.ocs.dynamo.util.SystemPropertyUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class XlsRowImportTemplate<ID, T extends AbstractDTO> {
    private BaseXlsImporter importer;
    private int colIndex;
    private byte[] bytes;
    private int sheetIndex;
    private boolean checkForDuplicates;
    private List<String> errors;
    private int firstRowNumber;
    private int recordLength;
    private Set<ID> keys = new HashSet<ID>();
    private MessageService messageService;
    private Class<T> clazz;

    public XlsRowImportTemplate(BaseXlsImporter importer, MessageService messageService, byte[] bytes, List<String> errors, Class<T> clazz, int sheetIndex, int firstRowNumber, int colIndex, int recordLength, boolean checkForDuplicates) {
        this.messageService = messageService;
        this.importer = importer;
        this.bytes = bytes;
        this.sheetIndex = sheetIndex;
        this.errors = errors;
        this.checkForDuplicates = checkForDuplicates;
        this.firstRowNumber = firstRowNumber;
        this.colIndex = colIndex;
        this.clazz = clazz;
        this.recordLength = recordLength;
    }

    public List<T> execute() throws IOException {
        ArrayList<T> results = new ArrayList<T>();
        try (Workbook wb = this.importer.createWorkbook(this.bytes);){
            Sheet sheet = wb.getSheetAt(this.sheetIndex);
            int i = 0;
            while (i <= sheet.getLastRowNum()) {
                if (i >= this.firstRowNumber) {
                    try {
                        T t;
                        if (this.importer.isRowEmpty(sheet.getRow(i))) break;
                        if ((t = this.importer.processRows(sheet, ++i, this.colIndex, this.clazz)) != null && this.extractKey(t) != null) {
                            Object key = this.extractKey(t);
                            if (key instanceof String) {
                                key = ((String)key).toLowerCase();
                            }
                            if (this.checkForDuplicates) {
                                if (!this.keys.contains(key)) {
                                    this.keys.add(key);
                                    results.add(t);
                                } else {
                                    this.errors.add(this.messageService.getMessage("ocs.duplicate.row", new Locale(SystemPropertyUtils.getDefaultLocale()), new Object[]{i + 1, key}));
                                }
                            } else {
                                results.add(t);
                            }
                        }
                    }
                    catch (OCSImportException ex) {
                        this.errors.add(String.format("Row %d: %s", i + 1, ex.getMessage()));
                    }
                    i += this.recordLength;
                    continue;
                }
                ++i;
            }
            ArrayList<T> arrayList = results;
            return arrayList;
        }
    }

    protected abstract ID extractKey(T var1);
}

