/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.importer.template;

import com.ocs.dynamo.exception.OCSImportException;
import com.ocs.dynamo.service.MessageService;
import com.ocs.dynamo.util.SystemPropertyUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class TextImportTemplate<ID, T> {
    private static final Logger LOG = Logger.getLogger(TextImportTemplate.class);
    private List<String[]> lines;
    private boolean checkForDuplicates;
    private List<String> errors;
    private MessageService messageService;
    private Set<ID> keys = new HashSet<ID>();

    public TextImportTemplate(MessageService messageService, List<String[]> lines, List<String> errors, boolean checkForDuplicates) {
        this.lines = lines;
        this.errors = errors;
        this.checkForDuplicates = checkForDuplicates;
        this.messageService = messageService;
    }

    protected abstract boolean isAppropriateRow(String[] var1);

    protected abstract T process(int var1, String[] var2);

    protected abstract ID getKeyFromRow(T var1);

    public List<T> execute() {
        ArrayList results = new ArrayList();
        for (int i = 0; i < this.lines.size(); ++i) {
            String[] row = this.lines.get(i);
            if (row == null || i <= 0 || !this.isAppropriateRow(row)) continue;
            try {
                this.executeRow(i, row, results);
                continue;
            }
            catch (OCSImportException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
                this.errors.add(String.format("Row %d: %s", i + 1, ex.getMessage()));
            }
        }
        return results;
    }

    private void executeRow(int i, String[] row, List<T> results) {
        T t = this.process(i, row);
        Object key = this.getKeyFromRow(t);
        if (this.checkForDuplicates) {
            if (key instanceof String) {
                key = ((String)key).toLowerCase();
            }
            if (!this.keys.contains(key)) {
                this.keys.add(key);
                results.add(t);
            } else {
                this.errors.add(this.messageService.getMessage("ocs.duplicate.row", new Locale(SystemPropertyUtils.getDefaultDateLocale()), new Object[]{i + 1, key}));
            }
        } else {
            results.add(t);
        }
    }
}

