/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.jasperreports;

import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

public class JRContainerDataSource
implements JRDataSource {
    private Container container;
    private Object currentItemId;
    private Item currentItem;
    private Iterator<?> ids;

    public JRContainerDataSource(Container container) {
        this.container = container;
        this.ids = container.getItemIds().iterator();
        if (this.ids != null && this.ids.hasNext()) {
            this.currentItemId = this.ids.next();
            this.currentItem = container.getItem(this.currentItemId);
        }
    }

    public Object getFieldValue(JRField field) throws JRException {
        if (this.currentItemId != null) {
            String fieldName = field.getName().replaceAll("_", ".");
            Property p = this.currentItem.getItemProperty((Object)fieldName);
            return p == null ? null : p.getValue();
        }
        return null;
    }

    public boolean next() throws JRException {
        if (this.ids != null && this.ids.hasNext()) {
            this.currentItemId = this.ids.next();
            this.currentItem = this.container.getItem(this.currentItemId);
            return true;
        }
        return false;
    }
}

