/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.jasperreports;

import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.IndexedDataSource;

public class JRIndexedContainerDataSource
implements JRRewindableDataSource,
IndexedDataSource {
    private Container.Indexed container;
    private Object currentItemId;
    private Item currentItem;

    public JRIndexedContainerDataSource(Container.Indexed container) {
        this.container = container;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object result = null;
        if (this.currentItem != null) {
            String fieldName = field.getName().replaceAll("_", ".");
            Property p = this.currentItem.getItemProperty((Object)fieldName);
            if (p == null) {
                fieldName = field.getPropertiesMap().getProperty("com.ocs.dynamo.containerPropertyName");
                p = this.currentItem.getItemProperty((Object)fieldName);
            }
            if (p != null && (result = p.getValue()) != null && !(result instanceof String) && field.getValueClass() == String.class) {
                result = result.toString();
            }
        }
        return result;
    }

    public boolean next() throws JRException {
        if (this.currentItem == null) {
            this.moveFirst();
            return this.currentItem != null;
        }
        this.currentItemId = this.container.nextItemId(this.currentItemId);
        this.currentItem = this.container.getItem(this.currentItemId);
        return this.currentItem != null;
    }

    public void moveFirst() throws JRException {
        if (this.container.size() > 0) {
            this.currentItemId = this.container.firstItemId();
            this.currentItem = this.container.getItem(this.currentItemId);
        } else {
            this.currentItemId = null;
            this.currentItem = null;
        }
    }

    public int getRecordIndex() {
        return this.container.indexOfId(this.currentItemId);
    }

    public Container.Indexed getContainer() {
        return this.container;
    }
}

