/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.jasperreports;

import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.exception.OCSRuntimeException;
import com.ocs.dynamo.filter.FilterUtil;
import com.ocs.dynamo.ui.container.ServiceContainer;
import com.vaadin.data.Container;
import com.vaadin.data.util.AbstractBeanContainer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JasperReport;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.lang.StringUtils;

public final class JRUtils {
    static final String CONTAINER_PROPERTY_NAME = "com.ocs.dynamo.containerPropertyName";
    static final String FILTER_PROPERTY_NAME = "com.ocs.dynamo.filterPropertyName";
    static final String PROPERTY_NESTED_NAME = "com.ocs.dynamo.propertyNestedName";
    static final String FILTER_TYPE = "com.ocs.dynamo.filterType";

    private JRUtils() {
    }

    public static void addContainerPropertiesFromReport(Container container, JasperReport jasperReport, EntityModel<?> em) {
        if (container == null || jasperReport == null) {
            return;
        }
        Collection ids = container.getContainerPropertyIds();
        for (JRField f : jasperReport.getFields()) {
            String cpn;
            if (!f.hasProperties() || !f.getPropertiesMap().containsProperty(CONTAINER_PROPERTY_NAME) || ids.contains(cpn = f.getPropertiesMap().getProperty(CONTAINER_PROPERTY_NAME))) continue;
            if (container instanceof AbstractBeanContainer) {
                ((AbstractBeanContainer)container).addNestedContainerProperty(cpn);
                continue;
            }
            if (container instanceof ServiceContainer) {
                AttributeModel am = em == null ? null : em.getAttributeModel(cpn);
                ServiceContainer sc = (ServiceContainer)container;
                sc.addContainerProperty((Object)cpn, f.getValueClass(), null, false, am == null ? false : am.isSortable());
                continue;
            }
            container.addContainerProperty((Object)cpn, f.getValueClass(), null);
        }
    }

    public static Map<String, Object> createParametersFromFilter(JasperReport jasperReport, Container.Filter filter) {
        HashMap<String, Object> fillParameters = new HashMap<String, Object>();
        if (jasperReport != null && filter != null) {
            for (JRParameter p : jasperReport.getParameters()) {
                Object result;
                JRPropertiesMap pm = p.getPropertiesMap();
                String parameterName = p.getName();
                if (!pm.containsProperty(FILTER_PROPERTY_NAME)) continue;
                String name = pm.getProperty(FILTER_PROPERTY_NAME);
                Class<?> ptype = null;
                try {
                    ptype = Class.forName(pm.getProperty(FILTER_TYPE));
                }
                catch (ClassNotFoundException | NullPointerException exception) {
                    // empty catch block
                }
                if (!StringUtils.isNotBlank((String)name) || (result = FilterUtil.extractFilterValue((Container.Filter)filter, (String)name, (Class[])new Class[]{ptype})) == null) continue;
                String nestedPropertyName = pm.getProperty(PROPERTY_NESTED_NAME);
                if (StringUtils.isNotBlank((String)nestedPropertyName)) {
                    result = result instanceof Collection ? JRUtils.getPropertyNestedValue(fillParameters, parameterName, nestedPropertyName, (Collection)result) : JRUtils.getNestedProperty(nestedPropertyName, result);
                }
                fillParameters.put(parameterName, result);
            }
        }
        return fillParameters;
    }

    private static Collection<?> getPropertyNestedValue(Map<String, Object> fillParameters, String parameterName, String nestedPropertyName, Collection result) {
        ArrayList<Object> resultCollection = (ArrayList<Object>)fillParameters.remove(parameterName);
        if (resultCollection == null) {
            resultCollection = new ArrayList<Object>();
        }
        for (Object o : result) {
            resultCollection.add(JRUtils.getNestedProperty(nestedPropertyName, o));
        }
        return resultCollection;
    }

    private static Object getNestedProperty(String prop, Object bean) {
        try {
            return BeanUtilsBean.getInstance().getPropertyUtils().getNestedProperty(bean, prop);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new OCSRuntimeException("Failed to get bean property", (Throwable)e);
        }
    }

    public static JRParameter findParameterWithPropertyValue(JasperReport jasperReport, String propertyName, Object propertyValue) {
        JRParameter result = null;
        if (jasperReport != null && propertyName != null && !"".equals(propertyName) && propertyValue != null) {
            for (JRParameter p : jasperReport.getParameters()) {
                String value = p.getPropertiesMap().getProperty(propertyName);
                if (!propertyValue.equals(value)) continue;
                result = p;
                break;
            }
        }
        return result;
    }
}

