/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite;

import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.domain.model.impl.ModelBasedFieldFactory;
import com.ocs.dynamo.jasperreports.JRContainerDataSource;
import com.ocs.dynamo.jasperreports.JRIndexedContainerDataSource;
import com.ocs.dynamo.jasperreports.JRUtils;
import com.ocs.dynamo.service.MessageService;
import com.ocs.dynamo.ui.composite.layout.BaseCustomComponent;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.ocs.jasperreports.ReportGenerator;
import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.server.Extension;
import com.vaadin.server.FileDownloader;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.server.StreamResource;
import com.vaadin.server.VaadinSession;
import com.vaadin.server.WrappedHttpSession;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.AbstractSelect;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.HorizontalSplitPanel;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperReport;
import org.apache.commons.lang.StringUtils;

public class JRReportViewer<T>
extends BaseCustomComponent {
    protected static final String NO_DATA_FOUND_KEY = "ocs.no.data.found";
    protected static final String REPORT_AREA_ID = "reportArea";
    protected static final String REPORT_EXTENSION = ".jasper";
    protected static final String REPORT_NA_KEY = "ocs.report.not.available";
    private static final long serialVersionUID = 6981827314136814213L;
    private boolean alreadyLoaded = false;
    private Container container;
    private Map<String, Object> currentParameters;
    private EntityModel<T> entityModel;
    private Button exportReport;
    private JasperReport jasperReport;
    private JRDataSource jrDataSource;
    private ComponentContainer main;
    private Label reportArea;
    private Enum<? extends ReportDefinition> reportDefinition;
    private ReportGenerator reportGenerator;
    private AbstractSelect reportSelection;
    private CheckBox showMargins;
    private String templatePath;
    private Component toolbar;
    private boolean splitlayout = false;
    private ComboBox exportTypeSelection;
    private HorizontalLayout exportSelection;

    public JRReportViewer(ReportGenerator reportGenerator, Enum<? extends ReportDefinition> reportDefinition, EntityModel<T> entityModel, String templatePath) {
        this.reportGenerator = reportGenerator;
        this.reportDefinition = reportDefinition;
        this.entityModel = entityModel;
        this.templatePath = templatePath;
    }

    public void build() {
        this.setId(((Object)((Object)this)).getClass().getSimpleName());
        this.toolbar = this.buildToolbar();
        this.reportArea = this.buildReportArea();
        this.main = this.buildMain();
        this.setCompositionRoot((Component)this.main);
    }

    protected ComponentContainer buildMain() {
        HorizontalSplitPanel main = null;
        if (this.isSplitlayout()) {
            HorizontalSplitPanel sp = new HorizontalSplitPanel(this.toolbar, (Component)this.reportArea);
            sp.setSizeFull();
            sp.setSplitPosition(30.0f, Sizeable.Unit.PERCENTAGE);
            main = sp;
        } else {
            VerticalLayout vl = new VerticalLayout();
            vl.setMargin(true);
            vl.setSpacing(true);
            vl.addComponent(this.toolbar);
            vl.addComponent((Component)this.reportArea);
            main = vl;
        }
        return main;
    }

    protected Component buildExportSelection() {
        this.exportSelection = new HorizontalLayout();
        this.exportSelection.setSpacing(true);
        this.exportSelection.addComponent((Component)new Label("Export as:"));
        this.exportReport = new Button("Export");
        this.exportTypeSelection = (ComboBox)ModelBasedFieldFactory.getInstance(this.entityModel, (MessageService)this.getMessageService()).createEnumCombo(ReportGenerator.Format.class, ComboBox.class);
        this.exportTypeSelection.setValue((Object)ReportGenerator.Format.PDF);
        this.exportTypeSelection.setNullSelectionAllowed(false);
        this.exportTypeSelection.addValueChangeListener((Property.ValueChangeListener)new ReportSelectionValueChangeListener());
        this.exportSelection.addComponent((Component)this.exportTypeSelection);
        this.exportSelection.addComponent((Component)this.exportReport);
        this.exportSelection.setEnabled(false);
        return this.exportSelection;
    }

    public void limitExportSelection(ReportGenerator.Format ... supportedFormats) {
        if (supportedFormats != null && supportedFormats.length > 0) {
            HashSet<ReportGenerator.Format> formatsToShow = new HashSet<ReportGenerator.Format>(Arrays.asList(supportedFormats));
            for (ReportGenerator.Format format : ReportGenerator.Format.values()) {
                if (formatsToShow.contains((Object)format)) continue;
                this.exportTypeSelection.removeItem((Object)format);
            }
        }
    }

    protected Label buildReportArea() {
        Label label = new Label(this.getMessageService().getMessage(REPORT_NA_KEY));
        label.setContentMode(ContentMode.HTML);
        label.setId(REPORT_AREA_ID);
        return label;
    }

    protected Component buildReportOptions() {
        this.showMargins = new CheckBox("Show margins", false);
        return this.showMargins;
    }

    protected Component buildReportSelection() {
        FormLayout content = new FormLayout();
        content.setSpacing(true);
        this.reportSelection = (AbstractSelect)ModelBasedFieldFactory.getInstance(this.entityModel, (MessageService)this.getMessageService()).createEnumCombo(this.reportDefinition.getClass(), ComboBox.class);
        this.reportSelection.setCaption(this.getMessageService().getMessage(this.entityModel.getReference() + "." + this.reportDefinition.getClass().getSimpleName()));
        this.reportSelection.setNullSelectionAllowed(false);
        this.reportSelection.setRequired(true);
        this.reportSelection.select(this.reportSelection.getItemIds().iterator().next());
        this.reportSelection.setSizeFull();
        this.reportSelection.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = -3358229370015557129L;

            public void valueChange(Property.ValueChangeEvent event) {
                if (JRReportViewer.this.exportSelection != null) {
                    JRReportViewer.this.exportSelection.setEnabled(false);
                }
            }
        });
        content.addComponent((Component)this.reportSelection);
        if (((Enum[])this.reportDefinition.getClass().getEnumConstants()).length <= 1) {
            this.reportSelection.setVisible(false);
        }
        return content;
    }

    protected Component buildToolbar() {
        HorizontalLayout content = new HorizontalLayout();
        content.setSizeFull();
        content.setSpacing(true);
        content.addComponent(this.buildReportSelection());
        content.addComponent(this.buildExportSelection());
        content.addComponent(this.buildReportOptions());
        Panel panel = new Panel();
        panel.setContent((Component)content);
        return panel;
    }

    public void clear() {
        this.reportArea.setValue(this.getMessageService().getMessage(REPORT_NA_KEY));
    }

    public void displayReport(Container.Filter filter, Map<String, Object> parameters) {
        String html;
        this.currentParameters = parameters;
        ReportDefinition rd = this.getReportSelectionValue();
        String path = this.getFullPath(rd);
        this.jasperReport = this.reportGenerator.loadTemplate(path);
        Map<String, Object> params = JRUtils.createParametersFromFilter(this.jasperReport, filter);
        params.put("showMargins", this.showMargins.getValue());
        params.putAll(this.currentParameters);
        this.currentParameters.putAll(params);
        this.jrDataSource = null;
        if (!rd.requiresDatabaseConnection()) {
            this.jrDataSource = this.container instanceof Container.Indexed ? new JRIndexedContainerDataSource((Container.Indexed)this.container) : new JRContainerDataSource(this.container);
        }
        if ((html = this.reportGenerator.executeReportAsHtml(this.jasperReport, params, this.jrDataSource, ((WrappedHttpSession)VaadinSession.getCurrent().getSession()).getHttpSession(), VaadinSession.getCurrent().getLocale())) == null || "".equals(html) || !rd.requiresDatabaseConnection() && this.container != null && this.container.size() <= 0) {
            this.reportArea.setValue(this.getMessageService().getMessage(NO_DATA_FOUND_KEY));
            this.exportSelection.setEnabled(false);
        } else {
            if (rd.requiresExternalScript()) {
                VaadinUtils.loadScript((String)REPORT_AREA_ID, (String)html, (boolean)rd.requiresExternalScript(), (boolean)this.alreadyLoaded);
                this.alreadyLoaded = true;
            } else {
                this.reportArea.setValue(html);
            }
            this.exportSelection.setEnabled(true);
        }
    }

    public HorizontalLayout getExportReport() {
        return this.exportSelection;
    }

    protected String getFullPath(ReportDefinition rd) {
        return (StringUtils.isEmpty((String)this.templatePath) ? "" : this.templatePath) + rd.getReportTemplateName() + REPORT_EXTENSION;
    }

    public ComponentContainer getMain() {
        return this.main;
    }

    public Component getReportArea() {
        return this.reportArea;
    }

    public Enum<? extends ReportDefinition> getReportDefinition() {
        return this.reportDefinition;
    }

    public AbstractSelect getReportSelection() {
        return this.reportSelection;
    }

    public ReportDefinition getReportSelectionValue() {
        return (ReportDefinition)this.getReportSelection().getValue();
    }

    public CheckBox getShowMargins() {
        return this.showMargins;
    }

    public Component getToolbar() {
        return this.toolbar;
    }

    public void setContainer(Container container, boolean defineProperties) {
        this.container = container;
        if (defineProperties) {
            for (ReportDefinition type : (ReportDefinition[])this.reportDefinition.getClass().getEnumConstants()) {
                if (type.requiresDatabaseConnection()) continue;
                JRUtils.addContainerPropertiesFromReport(container, this.reportGenerator.loadTemplate(this.getFullPath(type)), this.entityModel);
            }
        }
    }

    public boolean isSplitlayout() {
        return this.splitlayout;
    }

    public void setSplitlayout(boolean splitlayout) {
        this.splitlayout = splitlayout;
    }

    private final class ReportSelectionValueChangeListener
    implements Property.ValueChangeListener {
        private static final long serialVersionUID = 8469214535980470234L;
        private FileDownloader downloader;

        private ReportSelectionValueChangeListener() {
            this.attachDownloader();
        }

        public void valueChange(Property.ValueChangeEvent event) {
            if (this.downloader != null) {
                JRReportViewer.this.exportReport.removeExtension((Extension)this.downloader);
            }
            this.attachDownloader();
        }

        private void attachDownloader() {
            ReportGenerator.Format selectedFormat = (ReportGenerator.Format)((Object)JRReportViewer.this.exportTypeSelection.getValue());
            if (selectedFormat != null) {
                this.downloader = new FileDownloader((Resource)this.createResourceForExport(selectedFormat));
                this.downloader.extend((AbstractComponent)JRReportViewer.this.exportReport);
            }
        }

        protected StreamResource createResourceForExport(final ReportGenerator.Format format) {
            return new StreamResource(new StreamResource.StreamSource(){
                private static final long serialVersionUID = -5207351556320212325L;

                public InputStream getStream() {
                    if (JRReportViewer.this.jasperReport != null) {
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        JRReportViewer.this.reportGenerator.executeReport(JRReportViewer.this.jasperReport, JRReportViewer.this.currentParameters, JRReportViewer.this.jrDataSource, format, ((WrappedHttpSession)VaadinSession.getCurrent().getSession()).getHttpSession(), VaadinSession.getCurrent().getLocale(), os);
                        return new ByteArrayInputStream(os.toByteArray());
                    }
                    return null;
                }
            }, "report." + format.getExtension());
        }
    }

    public static interface ReportDefinition {
        public String getReportTemplateName();

        public boolean requiresDatabaseConnection();

        public boolean requiresExternalScript();
    }
}

