/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.jasperreports;

import com.ocs.dynamo.exception.OCSRuntimeException;
import com.ocs.jasperreports.UniqueWebHtmlResourceHandler;
import com.ocs.jasperreports.export.ExporterFactory;
import com.ocs.jasperreports.renderer.HtmlSvgImageFontExporter;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.HtmlResourceHandler;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.export.Exporter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleHtmlExporterConfiguration;
import net.sf.jasperreports.export.SimpleHtmlExporterOutput;
import net.sf.jasperreports.export.SimpleHtmlReportConfiguration;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.stereotype.Service;

@Service
public class ReportGenerator {
    private DataSource dataSource;

    @Inject
    public ReportGenerator(DataSource dataSource) {
        this();
        this.dataSource = dataSource;
    }

    public ReportGenerator() {
        this.setTempFolder(null);
    }

    private void setTempFolder(String tempFolder) {
        if (tempFolder == null || !new File(tempFolder).isDirectory()) {
            System.setProperty("jasper.reports.compile.temp", System.getProperty("java.io.tmpdir"));
        } else {
            System.setProperty("jasper.reports.compile.temp", tempFolder);
        }
    }

    public JasperReport loadTemplate(String templatePath) {
        try {
            InputStream in = JRLoader.getLocationInputStream((String)templatePath);
            return (JasperReport)JRLoader.loadObject((InputStream)in);
        }
        catch (JRException e) {
            throw new OCSRuntimeException("Failed to find jasper report template!", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JasperPrint fillReport(JasperReport jasperReport, Map<String, Object> parameters, JRDataSource jrDataSource) {
        try {
            if (jrDataSource != null) {
                return JasperFillManager.fillReport((JasperReport)jasperReport, parameters, (JRDataSource)jrDataSource);
            }
            try (Connection connection = this.dataSource.getConnection();){
                JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, parameters, (Connection)connection);
                return jasperPrint;
            }
        }
        catch (SQLException | JRException e) {
            throw new OCSRuntimeException("Failed to fill jasper report!", e);
        }
    }

    public String executeReportAsHtml(JasperReport jasperReport, Map<String, Object> parameters, JRDataSource jrDataSource, HttpSession session, Locale locale) {
        StringBuilder sb = this.executeReport(jasperReport, parameters, jrDataSource, Format.HTML, session, locale, null);
        return sb.toString();
    }

    public StringBuilder executeReport(JasperReport jasperReport, Map<String, Object> parameters, JRDataSource jrDataSource, Format format, HttpSession session, Locale locale, OutputStream outputStream) {
        HashMap<String, Object> copyParameters = new HashMap<String, Object>(parameters);
        copyParameters.put(Format.class.getSimpleName(), format.name());
        if (!copyParameters.containsKey("REPORT_LOCALE")) {
            copyParameters.put("REPORT_LOCALE", locale);
        }
        boolean showMargins = (Boolean)ObjectUtils.defaultIfNull((Object)parameters.get("showMargins"), (Object)Boolean.TRUE);
        JasperPrint jasperPrint = this.fillReport(jasperReport, copyParameters, jrDataSource);
        if (Format.HTML.equals((Object)format)) {
            return this.exportReportToHTML(jasperPrint, session, showMargins);
        }
        this.exportReport(jasperPrint, format, outputStream);
        return null;
    }

    private StringBuilder exportReportToHTML(JasperPrint jasperPrint, HttpSession session, boolean showMargins) {
        StringBuilder sb = new StringBuilder();
        try {
            HtmlSvgImageFontExporter exporter = new HtmlSvgImageFontExporter();
            exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
            SimpleHtmlExporterOutput out = new SimpleHtmlExporterOutput(sb);
            out.setImageHandler((HtmlResourceHandler)new UniqueWebHtmlResourceHandler("servlets/image?image={0}"));
            exporter.setExporterOutput((ExporterOutput)out);
            SimpleHtmlExporterConfiguration exporterConfig = new SimpleHtmlExporterConfiguration();
            if (!showMargins) {
                exporterConfig.setBetweenPagesHtml("");
                exporterConfig.setHtmlHeader("");
                exporterConfig.setHtmlFooter("");
            }
            exporter.setConfiguration((ExporterConfiguration)exporterConfig);
            SimpleHtmlReportConfiguration reportConfiguration = new SimpleHtmlReportConfiguration();
            reportConfiguration.setEmbeddedSvgUseFonts(Boolean.valueOf(true));
            reportConfiguration.setIgnoreHyperlink(Boolean.valueOf(false));
            reportConfiguration.setIgnorePageMargins(Boolean.valueOf(true));
            exporter.setConfiguration((ReportExportConfiguration)reportConfiguration);
            session.setAttribute("net.sf.jasperreports.j2ee.jasper_print", (Object)jasperPrint);
            exporter.exportReport();
        }
        catch (JRException e) {
            throw new OCSRuntimeException("Failed to export jasper report to HTML!", (Throwable)e);
        }
        return sb;
    }

    private void exportReport(JasperPrint jasperPrint, Format format, OutputStream outputStream) {
        try {
            Exporter exporter = ExporterFactory.getExporter(format, jasperPrint, outputStream);
            exporter.exportReport();
        }
        catch (JRException e) {
            throw new OCSRuntimeException("Failed to export jasper report to PDF!", (Throwable)e);
        }
    }

    public static enum Format {
        HTML("html"),
        PDF("pdf"),
        EXCEL("xls"),
        POWERPOINT("pptx"),
        DOC("doc");

        private final String extension;

        private Format(String extension) {
            this.extension = extension;
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

