/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.jasperreports.chart;

import com.ocs.jasperreports.chart.ChartCustomizer;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.data.Range;

public class AbstractChartCustomizer {
    protected void expandRange(ChartCustomizer.XYMarker rangeMarker, ValueAxis rangeAxis) {
        if (!rangeMarker.isExpandAxis()) {
            return;
        }
        double rangeMarkerValue = rangeMarker.getValue();
        double extraSpace = rangeMarkerValue / 100.0 * 15.0;
        double rangeMarkerUpper = rangeMarkerValue + extraSpace;
        double rangeMarkerLower = rangeMarkerValue - extraSpace;
        Range axisRange = rangeAxis.getRange();
        if (rangeMarkerLower < axisRange.getLowerBound()) {
            this.setLowerBound(rangeMarkerLower, rangeAxis);
        }
        if (rangeMarkerValue > axisRange.getUpperBound()) {
            this.setUpperBound(rangeMarkerUpper, rangeAxis);
        }
    }

    private void setLowerBound(double min, ValueAxis rangeAxis) {
        if (rangeAxis.getUpperBound() > min) {
            rangeAxis.setRange(new Range(min, rangeAxis.getUpperBound()), true, false);
        } else {
            rangeAxis.setRange(new Range(min, min + 1.0), true, false);
        }
    }

    private void setUpperBound(double max, ValueAxis rangeAxis) {
        if (rangeAxis.getLowerBound() < max) {
            rangeAxis.setRange(new Range(rangeAxis.getLowerBound(), max), true, false);
        } else {
            rangeAxis.setRange(new Range(max - 1.0, max), true, false);
        }
    }
}

