/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.jasperreports.chart;

import com.ocs.jasperreports.chart.AbstractChartCustomizer;
import com.ocs.jasperreports.chart.ChartCustomizer;
import com.ocs.jasperreports.chart.CustomChartCustomizer;
import com.ocs.jasperreports.chart.FullWidthCategoryDomainAxis;
import java.awt.Stroke;
import java.util.Collection;
import org.jfree.chart.annotations.Annotation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryMarker;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Marker;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.Layer;

public class CategoryChartCustomizer
extends AbstractChartCustomizer
implements CustomChartCustomizer<CategoryPlot> {
    @Override
    public void setLabels(CategoryPlot plot) {
        plot.getRenderer().setBaseItemLabelGenerator((CategoryItemLabelGenerator)new CategoryLabelGenerator());
        plot.getRenderer().setBaseItemLabelsVisible(true);
    }

    @Override
    public void addRangeMarkerToPlot(CategoryPlot plot, Marker marker) {
        ChartCustomizer.XYMarker rangeMarker = (ChartCustomizer.XYMarker)marker;
        ValueAxis rangeAxis = plot.getRangeAxis();
        this.expandRange(rangeMarker, rangeAxis);
        plot.addRangeMarker(marker, Layer.FOREGROUND);
    }

    @Override
    public void addDomainMarkerToPlot(CategoryPlot plot, Marker marker) {
        CategoryAxis domainAxis = plot.getDomainAxis();
        if (!(domainAxis instanceof FullWidthCategoryDomainAxis)) {
            FullWidthCategoryDomainAxis categoryColoredDomainAxis = new FullWidthCategoryDomainAxis(domainAxis);
            plot.setDomainAxis((CategoryAxis)categoryColoredDomainAxis);
        }
        plot.addDomainMarker((CategoryMarker)marker, Layer.BACKGROUND);
    }

    @Override
    public void addQuadrant(CategoryPlot plot, ChartCustomizer.Quadrant quadrant) {
        throw new UnsupportedOperationException("addQuadrant is unsupported for Category charts");
    }

    @Override
    public void setStrokeTypes(CategoryPlot plot, Collection<ChartCustomizer.StrokeType> sts) {
        for (ChartCustomizer.StrokeType st : sts) {
            int seriesIndex = st.getSeriesIndex();
            Stroke stroke = st.getStroke();
            int datasetCount = plot.getDatasetCount();
            int totalSeries = 0;
            for (int i = 0; i < datasetCount; ++i) {
                CategoryDataset dataset = plot.getDataset(i);
                int rowCount = dataset.getRowCount();
                if (totalSeries + rowCount >= seriesIndex) {
                    plot.getRenderer(i).setSeriesStroke(seriesIndex - totalSeries - 1, stroke);
                    continue;
                }
                totalSeries += rowCount;
            }
        }
    }

    @Override
    public void addAnnotationToPlot(CategoryPlot plot, Annotation annotation) {
    }

    static class CategoryLabelGenerator
    extends StandardCategoryItemLabelGenerator {
        CategoryLabelGenerator() {
        }

        public String generateLabel(CategoryDataset dataset, int row, int column) {
            Number value = dataset.getValue(row, column);
            if (value != null && value instanceof ChartCustomizer.BigDecimalLabelWrapper) {
                return ((ChartCustomizer.BigDecimalLabelWrapper)value).getLabel();
            }
            return super.generateLabel(dataset, row, column);
        }
    }
}

