/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.jasperreports.chart;

import com.ocs.jasperreports.chart.ChartCustomizer;
import java.awt.Paint;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.sf.jasperreports.components.charts.AbstractChartCustomizer;
import net.sf.jasperreports.components.charts.ChartComponent;
import net.sf.jasperreports.engine.JRRuntimeException;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.SpiderWebPlot;

public class ChartComponentCustomizer
extends AbstractChartCustomizer {
    private static final String SERIES_PAINT = ".SeriesPaint";

    public void customize(JFreeChart chart, ChartComponent chartComponent) {
        String key = chartComponent.getContext().getComponentElement().getKey();
        ChartCustomizer.customizeLegend(chart, this.getVariableValue(key + ".Legend"));
        if (chart.getPlot() instanceof SpiderWebPlot) {
            SpiderWebPlot plot = (SpiderWebPlot)chart.getPlot();
            try {
                Object seriesPaint = this.getVariableValue(key + SERIES_PAINT);
                List<Paint> sps = null;
                if (seriesPaint instanceof Collection) {
                    sps = (List<Paint>)seriesPaint;
                } else if (seriesPaint instanceof Paint[]) {
                    sps = Arrays.asList((Paint[])seriesPaint);
                }
                if (sps != null) {
                    int i = 0;
                    for (Paint p : sps) {
                        plot.setSeriesPaint(i++, p);
                    }
                } else if (seriesPaint instanceof Paint) {
                    plot.setSeriesPaint((Paint)seriesPaint);
                }
            }
            catch (JRRuntimeException jRRuntimeException) {
                // empty catch block
            }
        }
    }
}

