/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.jasperreports.chart;

import com.ocs.jasperreports.chart.AbstractChartCustomizer;
import com.ocs.jasperreports.chart.CategoryChartCustomizer;
import com.ocs.jasperreports.chart.CustomChartCustomizer;
import com.ocs.jasperreports.chart.XYChartCustomizer;
import com.ocs.jasperreports.renderer.SvgFontRenderer;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sf.jasperreports.charts.util.ChartHyperlinkProvider;
import net.sf.jasperreports.charts.util.SvgChartRendererFactory;
import net.sf.jasperreports.engine.JRAbstractChartCustomizer;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.base.JRBasePrintHyperlink;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.SimpleRenderToImageAwareDataRenderer;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.Annotation;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.XYAnnotationEntity;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.TextAnchor;
import org.jfree.ui.VerticalAlignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartCustomizer<T extends Plot>
extends JRAbstractChartCustomizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChartCustomizer.class);
    public static final String ANNOTATION = ".Annotation";
    public static final String LABELS = ".Labels";
    public static final String MARKER_RANGE = ".MarkerRange";
    public static final String MARKER_DOMAIN = ".MarkerDomain";
    public static final String QUADRANT = ".Quadrant";
    public static final String STROKE_TYPE = ".StrokeType";
    public static final String LEGEND = ".Legend";

    public static void customizeLegend(JFreeChart chart, Object legendVariable) {
        try {
            if (legendVariable instanceof LegendTitle) {
                chart.removeLegend();
                chart.addLegend((LegendTitle)legendVariable);
            }
            if (legendVariable instanceof LegendOptions) {
                LegendOptions lo = (LegendOptions)legendVariable;
                LegendTitle legend = chart.getLegend();
                if (lo.border != null) {
                    legend.setBorder((double)lo.border.intValue(), (double)lo.border.intValue(), (double)lo.border.intValue(), (double)lo.border.intValue());
                }
                if (lo.horizontalAlignment != null) {
                    legend.setHorizontalAlignment(lo.horizontalAlignment);
                }
                if (lo.verticalAlignment != null) {
                    legend.setVerticalAlignment(lo.verticalAlignment);
                }
            }
        }
        catch (JRRuntimeException jRRuntimeException) {
            // empty catch block
        }
    }

    public void customize(JFreeChart chart, JRChart jasperChart) {
        Object markers2;
        String key = jasperChart.getKey();
        Plot plot = chart.getPlot();
        try {
            Object legend = this.getVariableValue(key + LEGEND);
            if (legend != null) {
                ChartCustomizer.customizeLegend(chart, legend);
            }
        }
        catch (JRRuntimeException legend) {
            // empty catch block
        }
        AbstractChartCustomizer chartCustomizer = null;
        if (plot instanceof XYPlot) {
            chartCustomizer = new XYChartCustomizer();
        } else if (plot instanceof CategoryPlot) {
            chartCustomizer = new CategoryChartCustomizer();
        } else {
            LOGGER.info("No implementation available to customize");
            return;
        }
        try {
            Quadrant q = (Quadrant)this.getVariableValue(key + QUADRANT);
            if (q != null) {
                chartCustomizer.addQuadrant(plot, q);
            }
        }
        catch (JRRuntimeException q) {
            // empty catch block
        }
        try {
            if (Boolean.TRUE.equals((Boolean)this.getVariableValue(key + LABELS))) {
                chartCustomizer.setLabels(plot);
            }
        }
        catch (JRRuntimeException q) {
            // empty catch block
        }
        try {
            markers2 = this.getVariableValue(key + MARKER_RANGE);
            this.addMarkers((CustomChartCustomizer<T>)((Object)chartCustomizer), (T)plot, markers2, true);
        }
        catch (JRRuntimeException markers2) {
            // empty catch block
        }
        try {
            markers2 = this.getVariableValue(key + MARKER_DOMAIN);
            this.addMarkers((CustomChartCustomizer<T>)((Object)chartCustomizer), (T)plot, markers2, false);
        }
        catch (JRRuntimeException markers3) {
            // empty catch block
        }
        try {
            Object strokeTypes = this.getVariableValue(key + STROKE_TYPE);
            this.addStrokeTypes((CustomChartCustomizer<T>)((Object)chartCustomizer), (T)plot, strokeTypes);
        }
        catch (JRRuntimeException strokeTypes) {
            // empty catch block
        }
        try {
            Object annotations = this.getVariableValue(key + ANNOTATION);
            if (annotations != null) {
                this.addAnnotations((CustomChartCustomizer<T>)((Object)chartCustomizer), (T)plot, annotations);
            }
        }
        catch (JRRuntimeException jRRuntimeException) {
            // empty catch block
        }
    }

    private void addStrokeTypes(CustomChartCustomizer<T> chartCustomizer, T plot, Object strokeTypes) {
        Collection<Object> sts = Collections.emptyList();
        if (strokeTypes instanceof Collection) {
            sts = (Collection)strokeTypes;
        } else if (strokeTypes instanceof StrokeType[]) {
            sts = Arrays.asList((StrokeType[])strokeTypes);
        } else if (strokeTypes instanceof StrokeType) {
            sts = Collections.singleton((StrokeType)strokeTypes);
        }
        chartCustomizer.setStrokeTypes(plot, sts);
    }

    protected void addMarkers(CustomChartCustomizer<T> customChartCustomizer, T plot, Object markers, boolean range) {
        List<Marker> mks = null;
        if (markers instanceof Collection) {
            mks = (List<Marker>)markers;
        } else if (markers instanceof Marker[]) {
            mks = Arrays.asList((Marker[])markers);
        }
        if (mks != null) {
            for (Marker m : mks) {
                this.addMarker(customChartCustomizer, plot, m, range);
            }
        } else if (markers instanceof Marker) {
            this.addMarker(customChartCustomizer, plot, (Marker)markers, range);
        }
    }

    protected void addMarker(CustomChartCustomizer<T> customChartCustomizer, T plot, Marker marker, boolean range) {
        if (marker != null) {
            if (range) {
                marker.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
                marker.setLabelTextAnchor(TextAnchor.BOTTOM_RIGHT);
                customChartCustomizer.addRangeMarkerToPlot(plot, marker);
            } else {
                marker.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
                marker.setLabelTextAnchor(TextAnchor.TOP_LEFT);
                customChartCustomizer.addDomainMarkerToPlot(plot, marker);
            }
        }
    }

    protected void addAnnotations(CustomChartCustomizer<T> customChartCustomizer, T plot, Object annotations) {
        List<Annotation> ans = null;
        if (annotations instanceof Collection) {
            ans = (List<Annotation>)annotations;
        } else if (annotations instanceof Annotation[]) {
            ans = Arrays.asList((Annotation[])annotations);
        }
        if (ans != null) {
            for (Annotation a : ans) {
                this.addAnnotation(customChartCustomizer, plot, a);
            }
        } else if (annotations instanceof Annotation) {
            this.addAnnotation(customChartCustomizer, plot, (Annotation)annotations);
        }
    }

    protected void addAnnotation(CustomChartCustomizer<T> customChartCustomizer, T plot, Annotation annotation) {
        if (annotation != null) {
            customChartCustomizer.addAnnotationToPlot(plot, annotation);
        }
    }

    public static class StrokeType {
        private final int seriesIndex;
        private final Stroke stroke;

        public StrokeType(int seriesIndex, Stroke stroke) {
            this.seriesIndex = seriesIndex;
            this.stroke = stroke;
        }

        public int getSeriesIndex() {
            return this.seriesIndex;
        }

        public Stroke getStroke() {
            return this.stroke;
        }
    }

    public static class CategoryMarker
    extends org.jfree.chart.plot.CategoryMarker {
        public CategoryMarker(Comparable key) {
            super(key);
        }

        public CategoryMarker(Comparable key, Paint paint, Stroke stroke) {
            super(key, paint, stroke);
        }

        public CategoryMarker(Comparable key, Paint paint, Stroke stroke, Paint outlinePaint, Stroke outlineStroke, float alpha) {
            super(key, paint, stroke, outlinePaint, outlineStroke, alpha);
        }
    }

    public static class XYMarker
    extends ValueMarker {
        private boolean expandAxis;

        public XYMarker(double value, Color color, String label, boolean expandAxis) {
            super(value);
            this.expandAxis = expandAxis;
            this.setPaint(color);
            this.setLabel(label);
        }

        public XYMarker(double value, Color color, String label, float alpha, Color labelColor, boolean expandAxis) {
            super(value);
            this.expandAxis = expandAxis;
            this.setPaint(color);
            this.setLabel(label);
            this.setAlpha(alpha);
            this.setLabelPaint(labelColor);
            this.setLabelBackgroundColor(Color.white);
        }

        public XYMarker(double value, Paint paint, Stroke stroke, Paint outlinePaint, Stroke outlineStroke, float alpha, boolean expandAxis) {
            super(value, paint, stroke, outlinePaint, outlineStroke, alpha);
            this.expandAxis = expandAxis;
        }

        public XYMarker(double value, Paint paint, Stroke stroke, boolean expandAxis) {
            super(value, paint, stroke);
            this.expandAxis = expandAxis;
        }

        public XYMarker(double value, boolean expandAxis) {
            super(value);
            this.expandAxis = expandAxis;
        }

        public boolean isExpandAxis() {
            return this.expandAxis;
        }
    }

    public static class Quadrant {
        private double qOx;
        private double qOy;
        private Color qClt;
        private Color qCrt;
        private Color qClb;
        private Color qCrb;
        private String urlMessageFormat;
        private String tooltipMessageFormat;

        public Quadrant(double qOx, double qOy, Color qClt, Color qCrt, Color qClb, Color qCrb) {
            this.qOx = qOx;
            this.qOy = qOy;
            this.qClt = qClt;
            this.qCrt = qCrt;
            this.qClb = qClb;
            this.qCrb = qCrb;
        }

        public Quadrant(double qOx, double qOy, Color qClt, Color qCrt, Color qClb, Color qCrb, String urlMessageFormat, String tooltipMessageFormat) {
            this.qOx = qOx;
            this.qOy = qOy;
            this.qClt = qClt;
            this.qCrt = qCrt;
            this.qClb = qClb;
            this.qCrb = qCrb;
            if (urlMessageFormat != null) {
                this.urlMessageFormat = urlMessageFormat;
            }
            if (tooltipMessageFormat != null) {
                this.tooltipMessageFormat = tooltipMessageFormat;
            }
        }

        public double getqOx() {
            return this.qOx;
        }

        public double getqOy() {
            return this.qOy;
        }

        public Color getqClt() {
            return this.qClt;
        }

        public Color getqCrt() {
            return this.qCrt;
        }

        public Color getqClb() {
            return this.qClb;
        }

        public Color getqCrb() {
            return this.qCrb;
        }

        public String getUrlMessageFormat() {
            return this.urlMessageFormat;
        }

        public String getTooltipMessageFormat() {
            return this.tooltipMessageFormat;
        }
    }

    public static enum Action {
        ZOOM;

    }

    public static class BigDecimalLabelWrapper
    extends BigDecimal {
        private String label;

        public BigDecimalLabelWrapper(BigDecimal value, String label) {
            super(value.doubleValue());
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static class SvgChartRenderableFactoryDecorator
    extends SvgChartRendererFactory {
        public Renderable getRenderable(JasperReportsContext jasperReportsContext, JFreeChart chart, ChartHyperlinkProvider chartHyperlinkProvider, Rectangle2D rectangle) {
            Renderable renderable = super.getRenderable(jasperReportsContext, chart, (ChartHyperlinkProvider)new ChartHyperlinkProviderDecorator(chartHyperlinkProvider), rectangle);
            return new SvgFontRenderer((SimpleRenderToImageAwareDataRenderer)renderable);
        }
    }

    public static class ChartHyperlinkProviderDecorator
    implements ChartHyperlinkProvider {
        private ChartHyperlinkProvider chartHyperlinkProvider;

        public ChartHyperlinkProviderDecorator(ChartHyperlinkProvider chartHyperlinkProvider) {
            this.chartHyperlinkProvider = chartHyperlinkProvider;
        }

        public JRPrintHyperlink getEntityHyperlink(ChartEntity entity) {
            if (entity instanceof XYAnnotationEntity) {
                XYAnnotationEntity e = (XYAnnotationEntity)entity;
                JRBasePrintHyperlink link = new JRBasePrintHyperlink();
                link.setHyperlinkType(HyperlinkTypeEnum.REFERENCE);
                link.setHyperlinkReference(e.getURLText());
                link.setHyperlinkTooltip(e.getToolTipText());
                return link;
            }
            return this.chartHyperlinkProvider.getEntityHyperlink(entity);
        }

        public boolean hasHyperlinks() {
            return this.chartHyperlinkProvider.hasHyperlinks();
        }
    }

    public static class LegendOptions {
        private Integer border;
        private HorizontalAlignment horizontalAlignment;
        private VerticalAlignment verticalAlignment;

        public LegendOptions(Integer border, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
            this.border = border;
            this.horizontalAlignment = horizontalAlignment;
            this.verticalAlignment = verticalAlignment;
        }
    }
}

