/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.jasperreports.chart;

import com.ocs.jasperreports.chart.AbstractChartCustomizer;
import com.ocs.jasperreports.chart.ChartCustomizer;
import com.ocs.jasperreports.chart.CustomChartCustomizer;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Locale;
import org.jfree.chart.annotations.Annotation;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYBoxAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.BubbleXYItemLabelGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.ui.Layer;

public class XYChartCustomizer
extends AbstractChartCustomizer
implements CustomChartCustomizer<XYPlot> {
    @Override
    public void setLabels(XYPlot plot) {
        plot.getRenderer().setBaseItemLabelGenerator((XYItemLabelGenerator)new XYLabelGenerator());
        plot.getRenderer().setBaseItemLabelsVisible(true);
    }

    @Override
    public void addRangeMarkerToPlot(XYPlot plot, Marker marker) {
        ChartCustomizer.XYMarker rangeMarker = (ChartCustomizer.XYMarker)marker;
        ValueAxis rangeAxis = plot.getRangeAxis();
        this.expandRange(rangeMarker, rangeAxis);
        plot.addRangeMarker(marker, Layer.FOREGROUND);
    }

    @Override
    public void addDomainMarkerToPlot(XYPlot plot, Marker marker) {
        ChartCustomizer.XYMarker rangeMarker = (ChartCustomizer.XYMarker)marker;
        ValueAxis domainAxis = plot.getDomainAxis();
        this.expandRange(rangeMarker, domainAxis);
        plot.addDomainMarker(marker, Layer.FOREGROUND);
    }

    @Override
    public void addQuadrant(XYPlot plot, ChartCustomizer.Quadrant quadrant) {
        Point2D.Double pointQuadOrigin = new Point2D.Double(quadrant.getqOx(), quadrant.getqOy());
        plot.setQuadrantOrigin((Point2D)pointQuadOrigin);
        plot.setQuadrantPaint(0, (Paint)quadrant.getqClt());
        plot.setQuadrantPaint(1, (Paint)quadrant.getqCrt());
        plot.setQuadrantPaint(2, (Paint)quadrant.getqClb());
        plot.setQuadrantPaint(3, (Paint)quadrant.getqCrb());
        if (quadrant.getUrlMessageFormat() != null || quadrant.getTooltipMessageFormat() != null) {
            ValueAxis xAxis = plot.getDomainAxis();
            ValueAxis yAxis = plot.getRangeAxis();
            this.addXYBoxAnnotation(plot, xAxis.getLowerBound(), quadrant.getqOy(), quadrant.getqOx(), yAxis.getUpperBound(), quadrant.getUrlMessageFormat(), quadrant.getTooltipMessageFormat());
            this.addXYBoxAnnotation(plot, quadrant.getqOx(), quadrant.getqOy(), xAxis.getUpperBound(), yAxis.getUpperBound(), quadrant.getUrlMessageFormat(), quadrant.getTooltipMessageFormat());
            this.addXYBoxAnnotation(plot, xAxis.getLowerBound(), yAxis.getLowerBound(), quadrant.getqOx(), quadrant.getqOy(), quadrant.getUrlMessageFormat(), quadrant.getTooltipMessageFormat());
            this.addXYBoxAnnotation(plot, quadrant.getqOx(), yAxis.getLowerBound(), xAxis.getUpperBound(), quadrant.getqOy(), quadrant.getUrlMessageFormat(), quadrant.getTooltipMessageFormat());
        }
    }

    public void addXYBoxAnnotation(XYPlot plot, double minx, double miny, double maxx, double maxy, String urlMessageFormat, String tooltipMessageFormat) {
        this.addXYBoxAnnotation(plot, minx, miny, maxx, maxy, null, null, urlMessageFormat, tooltipMessageFormat);
    }

    public void addXYBoxAnnotation(XYPlot plot, double minx, double miny, double maxx, double maxy, Stroke stroke, Paint paint, String urlMessageFormat, String tooltipMessageFormat) {
        if (minx < maxx && miny < maxy) {
            XYBoxAnnotation annotation = new XYBoxAnnotation(minx, miny, maxx, maxy, stroke, paint, null);
            if (urlMessageFormat != null) {
                MessageFormat mf = new MessageFormat(urlMessageFormat, Locale.ENGLISH);
                annotation.setURL(mf.format(new Object[]{minx, miny, maxx, maxy}));
            }
            if (tooltipMessageFormat != null) {
                annotation.setToolTipText(MessageFormat.format(tooltipMessageFormat, minx, miny, maxx, maxy));
            }
            plot.getRenderer().addAnnotation((XYAnnotation)annotation, Layer.BACKGROUND);
        }
    }

    @Override
    public void setStrokeTypes(XYPlot plot, Collection<ChartCustomizer.StrokeType> sts) {
    }

    @Override
    public void addAnnotationToPlot(XYPlot plot, Annotation annotation) {
        if (annotation instanceof XYAnnotation) {
            plot.addAnnotation((XYAnnotation)annotation);
        }
    }

    private static class XYLabelGenerator
    extends BubbleXYItemLabelGenerator {
        private XYLabelGenerator() {
        }

        public String generateLabel(XYDataset dataset, int series, int item) {
            Number z;
            if (dataset instanceof XYZDataset && (z = ((XYZDataset)dataset).getZ(series, item)) != null && z instanceof ChartCustomizer.BigDecimalLabelWrapper) {
                return ((ChartCustomizer.BigDecimalLabelWrapper)z).getLabel();
            }
            return String.valueOf(dataset.getSeriesKey(series));
        }
    }

    public static class TextAnnotation
    extends XYTextAnnotation {
        public TextAnnotation(String text, double x, double y) {
            super(text, x, y);
        }

        public TextAnnotation(String text, double x, double y, String url) {
            super(text, x, y);
            this.setURL(url);
        }

        public TextAnnotation(String text, double x, double y, String url, String tooltip) {
            super(text, x, y);
            this.setURL(url);
            this.setToolTipText(tooltip);
        }
    }
}

