/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.jasperreports.export;

import com.ocs.jasperreports.ReportGenerator;
import com.ocs.jasperreports.export.WriterOutputStreamExporterOutput;
import java.io.OutputStream;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.ooxml.JRPptxExporter;
import net.sf.jasperreports.export.Exporter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimplePdfExporterConfiguration;
import net.sf.jasperreports.export.SimplePdfReportConfiguration;
import net.sf.jasperreports.export.SimplePptxExporterConfiguration;
import net.sf.jasperreports.export.SimplePptxReportConfiguration;
import net.sf.jasperreports.export.SimpleRtfExporterConfiguration;
import net.sf.jasperreports.export.SimpleRtfReportConfiguration;
import net.sf.jasperreports.export.SimpleXlsExporterConfiguration;
import net.sf.jasperreports.export.SimpleXlsReportConfiguration;

public final class ExporterFactory {
    private ExporterFactory() {
    }

    public static Exporter getExporter(ReportGenerator.Format format, JasperPrint jasperPrint, OutputStream outputStream) {
        JRXlsExporter exporter;
        switch (format) {
            case EXCEL: {
                exporter = ExporterFactory.getExcelExporter();
                break;
            }
            case POWERPOINT: {
                exporter = ExporterFactory.getPptxExporter();
                break;
            }
            case DOC: {
                exporter = ExporterFactory.getRtfExporter();
                break;
            }
            default: {
                exporter = ExporterFactory.getPdfExporter();
            }
        }
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
        exporter.setExporterOutput((ExporterOutput)new WriterOutputStreamExporterOutput(outputStream));
        return exporter;
    }

    private static JRPptxExporter getPptxExporter() {
        DefaultJasperReportsContext jasperReportsContext = DefaultJasperReportsContext.getInstance();
        JRPptxExporter exporter = new JRPptxExporter((JasperReportsContext)jasperReportsContext);
        SimplePptxExporterConfiguration exporterConfiguration = new SimplePptxExporterConfiguration();
        exporter.setConfiguration((ExporterConfiguration)exporterConfiguration);
        SimplePptxReportConfiguration reportConfiguration = new SimplePptxReportConfiguration();
        exporter.setConfiguration((ReportExportConfiguration)reportConfiguration);
        return exporter;
    }

    private static JRRtfExporter getRtfExporter() {
        DefaultJasperReportsContext jasperReportsContext = DefaultJasperReportsContext.getInstance();
        JRRtfExporter exporter = new JRRtfExporter((JasperReportsContext)jasperReportsContext);
        SimpleRtfExporterConfiguration exporterConfiguration = new SimpleRtfExporterConfiguration();
        exporter.setConfiguration((ExporterConfiguration)exporterConfiguration);
        SimpleRtfReportConfiguration reportConfiguration = new SimpleRtfReportConfiguration();
        exporter.setConfiguration((ReportExportConfiguration)reportConfiguration);
        return exporter;
    }

    private static JRPdfExporter getPdfExporter() {
        DefaultJasperReportsContext jasperReportsContext = DefaultJasperReportsContext.getInstance();
        JRPdfExporter exporter = new JRPdfExporter((JasperReportsContext)jasperReportsContext);
        SimplePdfExporterConfiguration exporterConfiguration = new SimplePdfExporterConfiguration();
        exporter.setConfiguration((ExporterConfiguration)exporterConfiguration);
        SimplePdfReportConfiguration reportConfiguration = new SimplePdfReportConfiguration();
        exporter.setConfiguration((ReportExportConfiguration)reportConfiguration);
        return exporter;
    }

    private static JRXlsExporter getExcelExporter() {
        DefaultJasperReportsContext jasperReportsContext = DefaultJasperReportsContext.getInstance();
        JRXlsExporter exporter = new JRXlsExporter((JasperReportsContext)jasperReportsContext);
        SimpleXlsExporterConfiguration exporterConfiguration = new SimpleXlsExporterConfiguration();
        exporter.setConfiguration((ExporterConfiguration)exporterConfiguration);
        SimpleXlsReportConfiguration reportConfiguration = new SimpleXlsReportConfiguration();
        exporter.setConfiguration((ReportExportConfiguration)reportConfiguration);
        return exporter;
    }
}

