/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.jasperreports.renderer;

import com.ocs.jasperreports.renderer.SvgFontRenderer;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRImageAlignment;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementIndex;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.export.AbstractHtmlExporter;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.HtmlResourceHandler;
import net.sf.jasperreports.engine.export.tabulator.TableCell;
import net.sf.jasperreports.engine.type.HorizontalImageAlignEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalImageAlignEnum;
import net.sf.jasperreports.engine.util.ImageUtil;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRTypeSniffer;
import net.sf.jasperreports.engine.util.Pair;
import net.sf.jasperreports.export.HtmlExporterOutput;
import net.sf.jasperreports.renderers.AreaHyperlinksRenderable;
import net.sf.jasperreports.renderers.DataRenderable;
import net.sf.jasperreports.renderers.DimensionRenderable;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.ResourceRenderer;
import net.sf.jasperreports.renderers.util.RendererUtil;
import net.sf.jasperreports.renderers.util.SvgDataSniffer;
import net.sf.jasperreports.renderers.util.SvgFontProcessor;
import org.w3c.tools.codec.Base64Encoder;

public class HtmlSvgImageFontExporter
extends HtmlExporter {
    protected void writeImage(JRPrintImage image, TableCell cell) throws IOException, JRException {
        Renderable renderer;
        boolean isLazy;
        int availableImageHeight;
        this.startCell((JRPrintElement)image, cell);
        int availableImageWidth = image.getWidth() - image.getLineBox().getLeftPadding() - image.getLineBox().getRightPadding();
        if (availableImageWidth < 0) {
            availableImageWidth = 0;
        }
        if ((availableImageHeight = image.getHeight() - image.getLineBox().getTopPadding() - image.getLineBox().getBottomPadding()) < 0) {
            availableImageHeight = 0;
        }
        String horizontalAlignment = this.getImageHorizontalAlignmentStyle(image);
        String verticalAlignment = this.getImageVerticalAlignmentStyle(image);
        StringBuilder styleBuffer = new StringBuilder();
        ScaleImageEnum scaleImage = image.getScaleImageValue();
        if (scaleImage != ScaleImageEnum.CLIP) {
            if (!horizontalAlignment.equals("left")) {
                styleBuffer.append("text-align: ");
                styleBuffer.append(horizontalAlignment);
                styleBuffer.append(";");
            }
            if (!verticalAlignment.equals("top")) {
                styleBuffer.append(" vertical-align: ");
                styleBuffer.append(verticalAlignment);
                styleBuffer.append(";");
            }
        }
        if ((isLazy = RendererUtil.isLazy((Renderable)(renderer = image.getRenderer()))) || scaleImage == ScaleImageEnum.CLIP && availableImageHeight > 0) {
            styleBuffer.append("height: ");
            styleBuffer.append(this.toSizeUnit(availableImageHeight));
            styleBuffer.append("; ");
        }
        this.appendElementCellGenericStyle(cell, styleBuffer);
        this.appendBackcolorStyle(cell, styleBuffer);
        boolean addedToStyle = this.appendBorderStyle(cell.getBox(), styleBuffer);
        if (!addedToStyle) {
            this.appendPen(styleBuffer, image.getLinePen(), null);
        }
        this.appendPaddingStyle(image.getLineBox(), styleBuffer);
        this.writeStyle(styleBuffer);
        this.finishStartCell();
        if (image.getAnchorName() != null) {
            this.writer.write("<a name=\"");
            this.writer.write(image.getAnchorName());
            this.writer.write("\"/>");
        }
        if (image.getBookmarkLevel() != 0) {
            this.writer.write("<a name=\"");
            this.writer.write("JR_BKMRK_" + this.reportIndex + "_" + this.pageIndex + "_" + cell.getElementAddress());
            this.writer.write("\"/>");
        }
        if (renderer != null) {
            InternalImageProcessorResult imageProcessorResult;
            boolean useBackgroundLazyImage;
            List imageMapAreas;
            String imageMapName;
            boolean hyperlinkStarted;
            boolean hasHyperlinks;
            boolean startedDiv;
            block53: {
                startedDiv = false;
                if (scaleImage == ScaleImageEnum.CLIP || isLazy && (scaleImage == ScaleImageEnum.RETAIN_SHAPE || scaleImage == ScaleImageEnum.REAL_HEIGHT || scaleImage == ScaleImageEnum.REAL_SIZE || image.getHorizontalImageAlign() != HorizontalImageAlignEnum.LEFT || image.getVerticalImageAlign() != VerticalImageAlignEnum.TOP)) {
                    this.writer.write("<div style=\"width: 100%; height: 100%; position: relative; overflow: hidden;\">\n");
                    startedDiv = true;
                }
                boolean hasAreaHyperlinks = renderer instanceof AreaHyperlinksRenderable && ((AreaHyperlinksRenderable)renderer).hasImageAreaHyperlinks();
                hasHyperlinks = false;
                if (hasAreaHyperlinks) {
                    hyperlinkStarted = false;
                    hasHyperlinks = true;
                } else {
                    hasHyperlinks = hyperlinkStarted = this.startHyperlink((JRPrintHyperlink)image);
                }
                imageMapName = null;
                imageMapAreas = null;
                if (hasAreaHyperlinks) {
                    Rectangle renderingArea = new Rectangle(image.getWidth(), image.getHeight());
                    if (renderer instanceof DataRenderable) {
                        imageMapName = (String)this.imageMaps.get(new Pair((Object)renderer.getId(), (Object)renderingArea));
                    }
                    if (imageMapName == null) {
                        Renderable originalRenderer = image.getRenderer();
                        imageMapName = "map_" + this.getElementIndex(cell).toString() + "-" + originalRenderer.getId();
                        imageMapAreas = ((AreaHyperlinksRenderable)originalRenderer).getImageAreaHyperlinks((Rectangle2D)renderingArea);
                        if (renderer instanceof DataRenderable) {
                            this.imageMaps.put(new Pair((Object)renderer.getId(), (Object)renderingArea), imageMapName);
                        }
                    }
                }
                useBackgroundLazyImage = isLazy && (scaleImage == ScaleImageEnum.RETAIN_SHAPE || scaleImage == ScaleImageEnum.REAL_HEIGHT || scaleImage == ScaleImageEnum.REAL_SIZE || image.getHorizontalImageAlign() != HorizontalImageAlignEnum.LEFT || image.getVerticalImageAlign() != VerticalImageAlignEnum.TOP);
                InternalImageProcessor imageProcessor = new InternalImageProcessor((JRPrintElement)image, isLazy, !useBackgroundLazyImage && scaleImage != ScaleImageEnum.FILL_FRAME && !isLazy, cell, availableImageWidth, availableImageHeight);
                imageProcessorResult = null;
                try {
                    imageProcessorResult = imageProcessor.process(renderer);
                }
                catch (Exception e) {
                    Renderable onErrorRenderer = this.getRendererUtil().handleImageError(e, image.getOnErrorTypeValue());
                    if (onErrorRenderer == null) break block53;
                    imageProcessorResult = imageProcessor.process(onErrorRenderer);
                }
            }
            if (imageProcessorResult != null) {
                if (useBackgroundLazyImage) {
                    this.writer.write("<div style=\"width: 100%; height: 100%; background-image: url('");
                    String imagePath = imageProcessorResult.imageSource;
                    if (imagePath != null) {
                        this.writer.write(imagePath);
                    }
                    this.writer.write("'); background-repeat: no-repeat; background-position: " + horizontalAlignment + " " + (image.getVerticalImageAlign() == VerticalImageAlignEnum.MIDDLE ? "center" : verticalAlignment) + ";background-size: ");
                    switch (scaleImage) {
                        case FILL_FRAME: {
                            this.writer.write("100% 100%");
                            break;
                        }
                        case CLIP: {
                            this.writer.write("auto");
                            break;
                        }
                        default: {
                            this.writer.write("contain");
                        }
                    }
                    this.writer.write(";\"></div>");
                } else if (imageProcessorResult.isEmbededSvgData) {
                    this.writer.write("<svg");
                    switch (scaleImage) {
                        case FILL_FRAME: {
                            Dimension2D dimension = imageProcessorResult.dimension;
                            if (dimension != null) {
                                this.writer.write(" viewBox=\"0 0 ");
                                this.writer.write(String.valueOf(dimension.getWidth()));
                                this.writer.write(" ");
                                this.writer.write(String.valueOf(dimension.getHeight()));
                                this.writer.write("\"");
                            }
                            this.writer.write(" width=\"");
                            this.writer.write(String.valueOf(availableImageWidth));
                            this.writer.write("\"");
                            this.writer.write(" height=\"");
                            this.writer.write(String.valueOf(availableImageHeight));
                            this.writer.write("\"");
                            this.writer.write(" preserveAspectRatio=\"none\"");
                            break;
                        }
                        case CLIP: {
                            double normalWidth = availableImageWidth;
                            double normalHeight = availableImageHeight;
                            Dimension2D dimension = imageProcessorResult.dimension;
                            if (dimension != null) {
                                normalWidth = dimension.getWidth();
                                normalHeight = dimension.getHeight();
                                this.writer.write(" viewBox=\"");
                                this.writer.write(String.valueOf((int)((double)ImageUtil.getXAlignFactor((JRImageAlignment)image) * (normalWidth - (double)availableImageWidth))));
                                this.writer.write(" ");
                                this.writer.write(String.valueOf((int)((double)ImageUtil.getYAlignFactor((JRImageAlignment)image) * (normalHeight - (double)availableImageHeight))));
                                this.writer.write(" ");
                                this.writer.write(String.valueOf(availableImageWidth));
                                this.writer.write(" ");
                                this.writer.write(String.valueOf(availableImageHeight));
                                this.writer.write("\"");
                            }
                            this.writer.write(" width=\"");
                            this.writer.write(String.valueOf(availableImageWidth));
                            this.writer.write("\"");
                            this.writer.write(" height=\"");
                            this.writer.write(String.valueOf(availableImageHeight));
                            this.writer.write("\"");
                            break;
                        }
                        default: {
                            double ratio;
                            if (availableImageHeight <= 0) break;
                            double normalWidth = availableImageWidth;
                            double normalHeight = availableImageHeight;
                            Dimension2D dimension = imageProcessorResult.dimension;
                            if (dimension != null) {
                                normalWidth = dimension.getWidth();
                                normalHeight = dimension.getHeight();
                                this.writer.write(" viewBox=\"0 0 ");
                                this.writer.write(String.valueOf(normalWidth));
                                this.writer.write(" ");
                                this.writer.write(String.valueOf(normalHeight));
                                this.writer.write("\"");
                            }
                            if ((ratio = normalWidth / normalHeight) > (double)availableImageWidth / (double)availableImageHeight) {
                                this.writer.write(" width=\"");
                                this.writer.write(String.valueOf(availableImageWidth));
                                this.writer.write("\"");
                                break;
                            }
                            this.writer.write(" height=\"");
                            this.writer.write(String.valueOf(availableImageHeight));
                            this.writer.write("\"");
                        }
                    }
                    this.writer.write("><g>\n");
                    this.writer.write(imageProcessorResult.imageSource);
                    this.writer.write("</g></svg>");
                } else {
                    this.writer.write("<img");
                    this.writer.write(" src=\"");
                    String imagePath = imageProcessorResult.imageSource;
                    if (imagePath != null) {
                        this.writer.write(imagePath);
                    }
                    this.writer.write("\"");
                    switch (scaleImage) {
                        case FILL_FRAME: {
                            this.writer.write(" style=\"width: ");
                            this.writer.write(this.toSizeUnit(availableImageWidth));
                            this.writer.write("; height: ");
                            this.writer.write(this.toSizeUnit(availableImageHeight));
                            this.writer.write("\"");
                            break;
                        }
                        case CLIP: {
                            int positionTop;
                            int positionLeft;
                            HorizontalImageAlignEnum horizontalAlign = image.getHorizontalImageAlign();
                            VerticalImageAlignEnum verticalAlign = image.getVerticalImageAlign();
                            if (isLazy || horizontalAlign == HorizontalImageAlignEnum.LEFT && verticalAlign == VerticalImageAlignEnum.TOP) {
                                positionLeft = 0;
                                positionTop = 0;
                            } else {
                                double normalWidth = availableImageWidth;
                                double normalHeight = availableImageHeight;
                                Dimension2D dimension = imageProcessorResult.dimension;
                                if (dimension != null) {
                                    normalWidth = dimension.getWidth();
                                    normalHeight = dimension.getHeight();
                                }
                                positionLeft = (int)((double)ImageUtil.getXAlignFactor((HorizontalImageAlignEnum)horizontalAlign) * ((double)availableImageWidth - normalWidth));
                                positionTop = (int)((double)ImageUtil.getYAlignFactor((VerticalImageAlignEnum)verticalAlign) * ((double)availableImageHeight - normalHeight));
                            }
                            this.writer.write(" style=\"position: absolute; left:");
                            this.writer.write(this.toSizeUnit(positionLeft));
                            this.writer.write("; top: ");
                            this.writer.write(this.toSizeUnit(positionTop));
                            this.writer.write(";\"");
                            break;
                        }
                        default: {
                            double ratio;
                            if (availableImageHeight <= 0) break;
                            double normalWidth = availableImageWidth;
                            double normalHeight = availableImageHeight;
                            Dimension2D dimension = imageProcessorResult.dimension;
                            if (dimension != null) {
                                normalWidth = dimension.getWidth();
                                normalHeight = dimension.getHeight();
                            }
                            if ((ratio = normalWidth / normalHeight) > (double)availableImageWidth / (double)availableImageHeight) {
                                this.writer.write(" style=\"width: ");
                                this.writer.write(this.toSizeUnit(availableImageWidth));
                                this.writer.write("\"");
                                break;
                            }
                            this.writer.write(" style=\"height: ");
                            this.writer.write(this.toSizeUnit(availableImageHeight));
                            this.writer.write("\"");
                        }
                    }
                    if (imageMapName != null) {
                        this.writer.write(" usemap=\"#" + imageMapName + "\"");
                    }
                    this.writer.write(" alt=\"\"");
                    if (hasHyperlinks) {
                        this.writer.write(" border=\"0\"");
                    }
                    if (image.getHyperlinkTooltip() != null) {
                        this.writer.write(" title=\"");
                        this.writer.write(JRStringUtil.xmlEncode((String)image.getHyperlinkTooltip()));
                        this.writer.write("\"");
                    }
                    this.writer.write("/>");
                }
            }
            if (hyperlinkStarted) {
                this.endHyperlink();
            }
            if (startedDiv) {
                this.writer.write("</div>");
            }
            if (imageMapAreas != null) {
                this.writer.write("\n");
                this.writeImageMap(imageMapName, image, imageMapAreas);
            }
        }
        this.endCell();
    }

    private class InternalImageProcessor {
        private final JRPrintElement imageElement;
        private final boolean isLazy;
        private final boolean embedImage;
        private final boolean needDimension;
        private final TableCell cell;
        private final int availableImageWidth;
        private final int availableImageHeight;

        protected InternalImageProcessor(JRPrintElement imageElement, boolean isLazy, boolean needDimension, TableCell cell, int availableImageWidth, int availableImageHeight) {
            this.imageElement = imageElement;
            this.isLazy = isLazy;
            this.embedImage = HtmlSvgImageFontExporter.this.isEmbedImage(imageElement);
            this.needDimension = needDimension;
            this.cell = cell;
            this.availableImageWidth = availableImageWidth;
            this.availableImageHeight = availableImageHeight;
        }

        protected InternalImageProcessorResult process(Renderable renderer) throws JRException, IOException {
            String imageSource = null;
            Dimension2D dimension = null;
            boolean isEmbededSvgData = false;
            if (this.isLazy) {
                imageSource = RendererUtil.getResourceLocation((Renderable)renderer);
            } else {
                if (renderer instanceof ResourceRenderer) {
                    renderer = HtmlSvgImageFontExporter.this.renderersCache.getLoadedRenderer((ResourceRenderer)renderer);
                }
                if (this.needDimension) {
                    DimensionRenderable dimensionRenderer = HtmlSvgImageFontExporter.this.renderersCache.getDimensionRenderable(renderer);
                    Dimension2D dimension2D = dimension = dimensionRenderer == null ? null : dimensionRenderer.getDimension(HtmlSvgImageFontExporter.this.jasperReportsContext);
                }
                if (!this.embedImage && renderer instanceof DataRenderable && HtmlSvgImageFontExporter.this.rendererToImagePathMap.containsKey(renderer.getId())) {
                    imageSource = (String)HtmlSvgImageFontExporter.this.rendererToImagePathMap.get(renderer.getId());
                } else if (this.embedImage) {
                    DataRenderable dataRenderer = null;
                    dataRenderer = HtmlSvgImageFontExporter.this.isConvertSvgToImage(this.imageElement) ? HtmlSvgImageFontExporter.this.getRendererUtil().getImageDataRenderable(HtmlSvgImageFontExporter.this.renderersCache, renderer, new Dimension(this.availableImageWidth, this.availableImageHeight), ModeEnum.OPAQUE == this.imageElement.getModeValue() ? this.imageElement.getBackcolor() : null) : HtmlSvgImageFontExporter.this.getRendererUtil().getDataRenderable(renderer, new Dimension(this.availableImageWidth, this.availableImageHeight), ModeEnum.OPAQUE == this.imageElement.getModeValue() ? this.imageElement.getBackcolor() : null);
                    byte[] imageData = dataRenderer.getData(HtmlSvgImageFontExporter.this.jasperReportsContext);
                    SvgDataSniffer.SvgInfo svgInfo = HtmlSvgImageFontExporter.this.getRendererUtil().getSvgInfo(imageData);
                    if (svgInfo != null) {
                        imageData = this.processSvgWithFonts(imageData);
                        isEmbededSvgData = true;
                        String encoding = svgInfo.getEncoding();
                        imageSource = new String(imageData, encoding == null ? "UTF-8" : encoding);
                        DimensionRenderable dimensionRenderer = HtmlSvgImageFontExporter.this.renderersCache.getDimensionRenderable(renderer);
                        dimension = dimensionRenderer == null ? null : dimensionRenderer.getDimension(HtmlSvgImageFontExporter.this.jasperReportsContext);
                    } else {
                        String imageMimeType = JRTypeSniffer.getImageTypeValue((byte[])imageData).getMimeType();
                        ByteArrayInputStream bais = new ByteArrayInputStream(imageData);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        Base64Encoder encoder = new Base64Encoder((InputStream)bais, (OutputStream)baos);
                        encoder.process();
                        imageSource = "data:" + imageMimeType + ";base64," + new String(baos.toByteArray(), "UTF-8");
                    }
                } else {
                    HtmlResourceHandler imageHandler;
                    HtmlResourceHandler htmlResourceHandler = imageHandler = HtmlSvgImageFontExporter.this.getImageHandler() == null ? ((HtmlExporterOutput)HtmlSvgImageFontExporter.this.getExporterOutput()).getImageHandler() : HtmlSvgImageFontExporter.this.getImageHandler();
                    if (imageHandler != null) {
                        DataRenderable dataRenderer = null;
                        dataRenderer = HtmlSvgImageFontExporter.this.isConvertSvgToImage(this.imageElement) ? HtmlSvgImageFontExporter.this.getRendererUtil().getImageDataRenderable(HtmlSvgImageFontExporter.this.renderersCache, renderer, new Dimension(this.availableImageWidth, this.availableImageHeight), ModeEnum.OPAQUE == this.imageElement.getModeValue() ? this.imageElement.getBackcolor() : null) : HtmlSvgImageFontExporter.this.getRendererUtil().getDataRenderable(renderer, new Dimension(this.availableImageWidth, this.availableImageHeight), ModeEnum.OPAQUE == this.imageElement.getModeValue() ? this.imageElement.getBackcolor() : null);
                        byte[] imageData = dataRenderer.getData(HtmlSvgImageFontExporter.this.jasperReportsContext);
                        SvgDataSniffer.SvgInfo svgInfo = HtmlSvgImageFontExporter.this.getRendererUtil().getSvgInfo(imageData);
                        if (svgInfo != null) {
                            imageData = this.processSvgWithFonts(imageData);
                            if (dataRenderer instanceof SvgFontRenderer) {
                                ((SvgFontRenderer)dataRenderer).setFontFixedData(imageData);
                            }
                        }
                        String fileExtension = HtmlSvgImageFontExporter.this.getRendererUtil().isSvgData(imageData) ? "svg" : JRTypeSniffer.getImageTypeValue((byte[])imageData).getFileExtension();
                        String imageName = AbstractHtmlExporter.getImageName((JRPrintElementIndex)HtmlSvgImageFontExporter.this.getElementIndex(this.cell), (String)fileExtension);
                        imageHandler.handleResource(imageName, imageData);
                        imageSource = imageHandler.getResourcePath(imageName);
                        if (dataRenderer == renderer) {
                            HtmlSvgImageFontExporter.this.rendererToImagePathMap.put(renderer.getId(), imageSource);
                        }
                    }
                }
            }
            return new InternalImageProcessorResult(imageSource, dimension, isEmbededSvgData);
        }

        private byte[] processSvgWithFonts(byte[] imageData) {
            if (HtmlSvgImageFontExporter.this.isEmbeddedSvgUseFonts(this.imageElement)) {
                Locale locale = HtmlSvgImageFontExporter.this.getLocale();
                SvgFontProcessor svgFontProcessor = new SvgFontProcessor(HtmlSvgImageFontExporter.this.jasperReportsContext, locale){

                    public String getFontFamily(String fontFamily, Locale locale) {
                        return HtmlSvgImageFontExporter.this.getFontFamily(true, fontFamily, locale);
                    }
                };
                imageData = svgFontProcessor.process(imageData);
            }
            return imageData;
        }
    }

    private static class InternalImageProcessorResult {
        private final String imageSource;
        private final Dimension2D dimension;
        private final boolean isEmbededSvgData;

        protected InternalImageProcessorResult(String imagePath, Dimension2D dimension, boolean isEmbededSvgData) {
            this.imageSource = imagePath;
            this.dimension = dimension;
            this.isEmbededSvgData = isEmbededSvgData;
        }

        public String getImageSource() {
            return this.imageSource;
        }

        public Dimension2D getDimension() {
            return this.dimension;
        }

        public boolean isEmbededSvgData() {
            return this.isEmbededSvgData;
        }
    }
}

